/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.net.jcip.annotations.ThreadSafe;
import org.gradle.internal.logging.config.LoggingRouter;
import org.gradle.internal.logging.config.LoggingSystem;
import org.gradle.internal.logging.console.AnsiConsole;
import org.gradle.internal.logging.console.BuildLogLevelFilterRenderer;
import org.gradle.internal.logging.console.BuildStatusRenderer;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.ConsoleLayoutCalculator;
import org.gradle.internal.logging.console.DefaultColorMap;
import org.gradle.internal.logging.console.DefaultWorkInProgressFormatter;
import org.gradle.internal.logging.console.StyledTextOutputBackedRenderer;
import org.gradle.internal.logging.console.ThrottlingOutputEventListener;
import org.gradle.internal.logging.console.UserInputConsoleRenderer;
import org.gradle.internal.logging.console.UserInputStandardOutputRenderer;
import org.gradle.internal.logging.console.WorkInProgressRenderer;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.format.PrettyPrefixedLogHeaderFormatter;
import org.gradle.internal.logging.sink.ConsoleConfigureAction;
import org.gradle.internal.logging.sink.GroupingProgressLogEventGenerator;
import org.gradle.internal.logging.sink.ProgressLogEventGenerator;
import org.gradle.internal.logging.text.StreamBackedStandardOutputListener;
import org.gradle.internal.logging.text.StreamingStyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.time.Clock;

@ThreadSafe
public class OutputEventRenderer
implements OutputEventListener,
LoggingRouter {
    private final Object lock = new Object();
    private final AtomicReference<LogLevel> logLevel = new AtomicReference<LogLevel>(LogLevel.LIFECYCLE);
    private final Clock clock;
    private final ListenerBroadcast<OutputEventListener> formatters = new ListenerBroadcast<OutputEventListener>(OutputEventListener.class);
    private final ListenerBroadcast<StandardOutputListener> stdoutListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private final ListenerBroadcast<StandardOutputListener> stderrListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private ColorMap colourMap;
    private OutputStream originalStdOut;
    private OutputStream originalStdErr;
    private StreamBackedStandardOutputListener stdOutListener;
    private StreamBackedStandardOutputListener stdErrListener;
    private OutputEventListener console;

    public OutputEventRenderer(final Clock clock) {
        this.clock = clock;
        LazyListener stdOutChain = new LazyListener(new Factory<OutputEventListener>(){

            @Override
            public OutputEventListener create() {
                return OutputEventRenderer.this.onNonError(new UserInputStandardOutputRenderer(new BuildLogLevelFilterRenderer(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput((StandardOutputListener)OutputEventRenderer.this.stdoutListeners.getSource())), false)), clock));
            }
        });
        this.formatters.add(stdOutChain);
        LazyListener stdErrChain = new LazyListener(new Factory<OutputEventListener>(){

            @Override
            public OutputEventListener create() {
                return OutputEventRenderer.this.onError(new BuildLogLevelFilterRenderer(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput((StandardOutputListener)OutputEventRenderer.this.stderrListeners.getSource())), false)));
            }
        });
        this.formatters.add(stdErrChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingSystem.Snapshot snapshot() {
        Object object = this.lock;
        synchronized (object) {
            return new SnapshotImpl(this.logLevel.get(), this.console);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(LoggingSystem.Snapshot state) {
        Object object = this.lock;
        synchronized (object) {
            SnapshotImpl snapshot = (SnapshotImpl)state;
            if (snapshot.logLevel != this.logLevel.get()) {
                this.configure(snapshot.logLevel);
            }
            if (snapshot.console != this.console) {
                if (snapshot.console == null) {
                    this.formatters.remove(this.console);
                    this.console.onOutput(new EndOutputEvent());
                    this.console = null;
                } else {
                    throw new UnsupportedOperationException("Cannot restore previous console. This is not implemented yet.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorMap getColourMap() {
        Object object = this.lock;
        synchronized (object) {
            if (this.colourMap == null) {
                this.colourMap = new DefaultColorMap();
            }
        }
        return this.colourMap;
    }

    public OutputStream getOriginalStdOut() {
        return this.originalStdOut;
    }

    public OutputStream getOriginalStdErr() {
        return this.originalStdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachProcessConsole(ConsoleOutput consoleOutput) {
        Object object = this.lock;
        synchronized (object) {
            ConsoleConfigureAction.execute(this, consoleOutput);
        }
    }

    public void attachAnsiConsole(OutputStream outputStream) {
        this.attachAnsiConsole(outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachAnsiConsole(OutputStream outputStream, boolean verbose) {
        Object object = this.lock;
        synchronized (object) {
            FallbackConsoleMetaData consoleMetaData = FallbackConsoleMetaData.INSTANCE;
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            AnsiConsole console = new AnsiConsole((Appendable)writer, (Flushable)writer, this.getColourMap(), (ConsoleMetaData)consoleMetaData, true);
            this.addConsole(console, true, true, consoleMetaData, verbose);
        }
    }

    public void attachSystemOutAndErr() {
        this.addStandardOutputListener();
        this.addStandardErrorListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStandardOutputListener() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdOut = System.out;
            if (this.stdOutListener != null) {
                this.stdoutListeners.remove(this.stdOutListener);
            }
            this.stdOutListener = new StreamBackedStandardOutputListener(System.out);
            this.addStandardOutputListener(this.stdOutListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStandardErrorListener() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdErr = System.err;
            if (this.stdErrListener != null) {
                this.stderrListeners.remove(this.stdErrListener);
            }
            this.stdErrListener = new StreamBackedStandardOutputListener(System.err);
            this.addStandardErrorListener(this.stdErrListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStandardOutputListener() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdOutListener != null) {
                this.stdoutListeners.remove(this.stdOutListener);
                this.stdOutListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStandardErrorListener() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdErrListener != null) {
                this.stderrListeners.remove(this.stdErrListener);
                this.stdErrListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.formatters.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.formatters.remove(listener);
        }
    }

    public OutputEventRenderer addConsole(Console console, boolean stdout, boolean stderr, ConsoleMetaData consoleMetaData) {
        return this.addConsole(console, stdout, stderr, consoleMetaData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputEventRenderer addConsole(Console console, boolean stdout, boolean stderr, ConsoleMetaData consoleMetaData, boolean verbose) {
        ThrottlingOutputEventListener consoleChain = new ThrottlingOutputEventListener(new UserInputConsoleRenderer(new BuildStatusRenderer(new WorkInProgressRenderer(new BuildLogLevelFilterRenderer(new GroupingProgressLogEventGenerator(new StyledTextOutputBackedRenderer(console.getBuildOutputArea()), this.clock, new PrettyPrefixedLogHeaderFormatter(), verbose)), console.getBuildProgressArea(), new DefaultWorkInProgressFormatter(consoleMetaData), new ConsoleLayoutCalculator(consoleMetaData)), console.getStatusBar(), console, consoleMetaData, this.clock), console), this.clock);
        Object object = this.lock;
        synchronized (object) {
            if (stdout && stderr) {
                this.console = consoleChain;
                this.removeStandardOutputListener();
                this.removeStandardErrorListener();
            } else if (stdout) {
                this.console = this.onNonError(consoleChain);
                this.removeStandardOutputListener();
            } else {
                this.console = this.onError(consoleChain);
                this.removeStandardErrorListener();
            }
            consoleChain.onOutput(new LogLevelChangeEvent(this.logLevel.get()));
            this.formatters.add(this.console);
        }
        return this;
    }

    private OutputEventListener onError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() == LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    private OutputEventListener onNonError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() != LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.add(listener);
        }
    }

    public void addStandardOutputListener(OutputStream outputStream) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(outputStream));
    }

    public void addStandardErrorListener(OutputStream outputStream) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.remove(listener);
        }
    }

    public void configure(LogLevel logLevel) {
        this.onOutput(new LogLevelChangeEvent(logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent event) {
        if (event.getLogLevel() != null && event.getLogLevel().compareTo((Enum)this.logLevel.get()) < 0 && !this.isProgressEvent(event)) {
            return;
        }
        if (event instanceof LogLevelChangeEvent) {
            LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
            LogLevel newLogLevel = changeEvent.getNewLogLevel();
            if (newLogLevel == this.logLevel.get()) {
                return;
            }
            this.logLevel.set(newLogLevel);
        }
        Object object = this.lock;
        synchronized (object) {
            this.formatters.getSource().onOutput(event);
        }
    }

    private boolean isProgressEvent(OutputEvent event) {
        return event instanceof ProgressStartEvent || event instanceof ProgressEvent || event instanceof ProgressCompleteEvent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyListener
    implements OutputEventListener {
        private Factory<OutputEventListener> factory;
        private OutputEventListener delegate;

        private LazyListener(Factory<OutputEventListener> factory) {
            this.factory = factory;
        }

        @Override
        public void onOutput(OutputEvent event) {
            if (this.delegate == null) {
                this.delegate = this.factory.create();
                this.factory = null;
            }
            this.delegate.onOutput(event);
        }
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final LogLevel logLevel;
        private final OutputEventListener console;

        SnapshotImpl(LogLevel logLevel, OutputEventListener console) {
            this.logLevel = logLevel;
            this.console = console;
        }
    }
}

