/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.gcp.gcs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.impldep.com.google.api.services.storage.model.StorageObject;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.gcp.gcs.GcsClient;
import org.gradle.internal.resource.transport.gcp.gcs.ResourceMapper;

public class GcsResource
implements ExternalResourceReadResponse {
    private final GcsClient gcsClient;
    private final StorageObject gcsObject;
    private final URI uri;

    public GcsResource(GcsClient gcsClient, StorageObject gcsObject, URI uri) {
        this.gcsClient = gcsClient;
        this.gcsObject = gcsObject;
        this.uri = uri;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.gcsClient.getResourceStream(this.gcsObject);
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        return ResourceMapper.toExternalResourceMetaData(this.uri, this.gcsObject);
    }

    @Override
    public void close() throws IOException {
    }
}

