/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileState;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;

public class CompilationStateSerializer
implements Serializer<CompilationState> {
    private final Serializer<File> fileSerializer;
    private final Serializer<HashCode> hashSerializer = new HashCodeSerializer();

    public CompilationStateSerializer() {
        this.fileSerializer = new BaseSerializerFactory().getSerializerFor(File.class);
    }

    @Override
    public CompilationState read(Decoder decoder) throws Exception {
        HashMap<Integer, IncludeFileState> ids = new HashMap<Integer, IncludeFileState>();
        int sourceFileCount = decoder.readSmallInt();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < sourceFileCount; ++i) {
            File sourceFile = this.fileSerializer.read(decoder);
            HashCode sourceHashCode = this.hashSerializer.read(decoder);
            int includeFileCount = decoder.readSmallInt();
            ImmutableSet.Builder includeFileStateBuilder = ImmutableSet.builder();
            for (int j = 0; j < includeFileCount; ++j) {
                int id = decoder.readSmallInt();
                IncludeFileState includeFileState = (IncludeFileState)ids.get(id);
                if (includeFileState == null) {
                    File includeFile = this.fileSerializer.read(decoder);
                    HashCode includeHashCode = this.hashSerializer.read(decoder);
                    includeFileState = new IncludeFileState(includeHashCode, includeFile);
                    ids.put(id, includeFileState);
                }
                includeFileStateBuilder.add((Object)includeFileState);
            }
            builder.put((Object)sourceFile, (Object)new SourceFileState(sourceHashCode, (ImmutableSet<IncludeFileState>)includeFileStateBuilder.build()));
        }
        return new CompilationState((ImmutableMap<File, SourceFileState>)builder.build());
    }

    @Override
    public void write(Encoder encoder, CompilationState value) throws Exception {
        HashMap<File, Integer> ids = new HashMap<File, Integer>();
        encoder.writeSmallInt(value.getFileStates().size());
        for (Map.Entry entry : value.getFileStates().entrySet()) {
            SourceFileState sourceFileState = (SourceFileState)entry.getValue();
            this.fileSerializer.write(encoder, (File)entry.getKey());
            this.hashSerializer.write(encoder, sourceFileState.getHash());
            encoder.writeSmallInt(sourceFileState.getResolvedIncludes().size());
            for (IncludeFileState includeFileState : sourceFileState.getResolvedIncludes()) {
                Integer id = (Integer)ids.get(includeFileState.getIncludeFile());
                if (id == null) {
                    id = ids.size();
                    ids.put(includeFileState.getIncludeFile(), id);
                    encoder.writeSmallInt(id);
                    this.fileSerializer.write(encoder, includeFileState.getIncludeFile());
                    this.hashSerializer.write(encoder, includeFileState.getHash());
                    continue;
                }
                encoder.writeSmallInt(id);
            }
        }
    }
}

