/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.util.CollectionUtils;

public class DefaultIncludeDirectives
implements IncludeDirectives {
    private final ImmutableList<Include> allIncludes;
    private final ImmutableList<Macro> macros;
    private final ImmutableList<MacroFunction> macroFunctions;

    public DefaultIncludeDirectives(ImmutableList<Include> allIncludes, ImmutableList<Macro> macros, ImmutableList<MacroFunction> macroFunctions) {
        this.allIncludes = allIncludes;
        this.macros = macros;
        this.macroFunctions = macroFunctions;
    }

    @Override
    public List<Include> getQuotedIncludes() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.QUOTED;
            }
        });
    }

    @Override
    public List<Include> getSystemIncludes() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.SYSTEM;
            }
        });
    }

    @Override
    public List<Include> getMacroIncludes() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.MACRO;
            }
        });
    }

    @Override
    public List<Include> getAll() {
        return this.allIncludes;
    }

    @Override
    public List<Include> getIncludesOnly() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return !element.isImport();
            }
        });
    }

    @Override
    public List<Macro> getMacros() {
        return this.macros;
    }

    @Override
    public List<MacroFunction> getMacrosFunctions() {
        return this.macroFunctions;
    }

    @Override
    public IncludeDirectives discardImports() {
        return new DefaultIncludeDirectives((ImmutableList<Include>)ImmutableList.copyOf(this.getIncludesOnly()), this.macros, this.macroFunctions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIncludeDirectives that = (DefaultIncludeDirectives)o;
        return this.allIncludes.equals(that.allIncludes) && this.macros.equals(that.macros) && this.macroFunctions.equals(that.macroFunctions);
    }

    public int hashCode() {
        return this.allIncludes.hashCode() ^ this.macros.hashCode() ^ this.macroFunctions.hashCode();
    }
}

