/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.language.swift.internal.DefaultSwiftCompileSpec;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;

@Incubating
@CacheableTask
public class SwiftCompile
extends DefaultTask {
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private boolean debug;
    private boolean optimize;
    private final Property<String> moduleName;
    private final RegularFileProperty moduleFile;
    private final ConfigurableFileCollection modules;
    private final ListProperty<String> compilerArgs;
    private final DirectoryProperty objectFileDir;
    private final ConfigurableFileCollection source;
    private final Map<String, String> macros = new LinkedHashMap<String, String>();

    public SwiftCompile() {
        this.source = this.getProject().files(new Object[0]);
        this.compilerArgs = this.getProject().getObjects().listProperty(String.class);
        this.objectFileDir = this.newOutputDirectory();
        this.moduleName = this.getProject().getObjects().property(String.class);
        this.moduleFile = this.newOutputFile();
        this.modules = this.getProject().files(new Object[0]);
    }

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros.clear();
        this.macros.putAll(macros);
    }

    @Input
    public boolean isDebuggable() {
        return this.debug;
    }

    public void setDebuggable(boolean debug) {
        this.debug = debug;
    }

    @Input
    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    @Input
    public ListProperty<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @OutputDirectory
    public DirectoryProperty getObjectFileDir() {
        return this.objectFileDir;
    }

    @OutputFile
    public RegularFileProperty getModuleFile() {
        return this.moduleFile;
    }

    @Optional
    @Input
    public Property<String> getModuleName() {
        return this.moduleName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public ConfigurableFileCollection getModules() {
        return this.modules;
    }

    @Nested
    protected CompilerVersion getCompilerVersion() {
        NativeToolChainInternal toolChain = (NativeToolChainInternal)this.getToolChain();
        NativePlatformInternal targetPlatform = (NativePlatformInternal)this.getTargetPlatform();
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        VersionAwareCompiler compiler = (VersionAwareCompiler)toolProvider.newCompiler(SwiftCompileSpec.class);
        return compiler.getVersion();
    }

    @TaskAction
    void compile() {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getOutputs());
        cleaner.setDestinationDir(this.getObjectFileDir().getAsFile().get());
        cleaner.execute();
        if (this.getSource().isEmpty()) {
            this.setDidWork(cleaner.getDidWork());
            return;
        }
        BuildOperationLogger operationLogger = this.getServices().get(BuildOperationLoggerFactory.class).newOperationLogger(this.getName(), this.getTemporaryDir());
        DefaultSwiftCompileSpec spec = new DefaultSwiftCompileSpec();
        spec.setModuleName((String)this.moduleName.getOrNull());
        spec.setModuleFile(((RegularFile)this.moduleFile.get()).getAsFile());
        for (File file : this.modules.getFiles()) {
            spec.include(file.getParentFile());
        }
        spec.setTargetPlatform(this.targetPlatform);
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(((Directory)this.objectFileDir.get()).getAsFile());
        spec.source(this.getSource());
        spec.setMacros(this.getMacros());
        spec.args((List)this.getCompilerArgs().get());
        spec.setDebuggable(this.isDebuggable());
        spec.setOptimized(this.isOptimized());
        spec.setIncrementalCompile(false);
        spec.setOperationLogger(operationLogger);
        PlatformToolProvider platformToolProvider = this.toolChain.select(this.targetPlatform);
        Compiler<SwiftCompileSpec> baseCompiler = platformToolProvider.newCompiler(SwiftCompileSpec.class);
        Compiler<SwiftCompileSpec> loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(baseCompiler);
        WorkResult result = loggingCompiler.execute(spec);
        this.setDidWork(result.getDidWork());
    }
}

