/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.api.Transformer;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.ArchitectureDescriptor;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.ArchitectureDescriptorBuilder;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetadata;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioVersionLocator;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TreeVisitor;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVisualStudioLocator
implements VisualStudioLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVisualStudioLocator.class);
    private static final String PATH_COMMON = "Common7/";
    private static final String PATH_BIN = "bin/";
    private static final String LEGACY_COMPILER_FILENAME = "cl.exe";
    private static final String VS2017_COMPILER_FILENAME = "HostX86/x86/cl.exe";
    private final Map<File, VisualStudioInstall> foundInstalls = new HashMap<File, VisualStudioInstall>();
    private final VisualStudioVersionLocator commandLineLocator;
    private final VisualStudioVersionLocator windowsRegistryLocator;
    private final VisualStudioVersionLocator systemPathLocator;
    private final VisualStudioMetaDataProvider versionDeterminer;
    private final SystemInfo systemInfo;
    private boolean initialised;

    public DefaultVisualStudioLocator(VisualStudioVersionLocator commandLineLocator, VisualStudioVersionLocator windowsRegistryLocator, VisualStudioVersionLocator systemPathLocator, VisualStudioMetaDataProvider versionDeterminer, SystemInfo systemInfo) {
        this.commandLineLocator = commandLineLocator;
        this.windowsRegistryLocator = windowsRegistryLocator;
        this.systemPathLocator = systemPathLocator;
        this.versionDeterminer = versionDeterminer;
        this.systemInfo = systemInfo;
    }

    @Override
    public List<VisualStudioLocator.SearchResult> locateAllVisualStudioVersions() {
        this.initializeVisualStudioInstalls();
        List<VisualStudioInstall> sortedInstalls = CollectionUtils.sort(this.foundInstalls.values(), new Comparator<VisualStudioInstall>(){

            @Override
            public int compare(VisualStudioInstall o1, VisualStudioInstall o2) {
                return o2.getVersion().compareTo(o1.getVersion());
            }
        });
        if (sortedInstalls.isEmpty()) {
            return Lists.newArrayList((Object[])new VisualStudioLocator.SearchResult[]{new InstallNotFound("Could not locate a Visual Studio installation, using the Windows registry and system path.")});
        }
        return CollectionUtils.collect(sortedInstalls, new Transformer<VisualStudioLocator.SearchResult, VisualStudioInstall>(){

            @Override
            public VisualStudioLocator.SearchResult transform(VisualStudioInstall visualStudioInstall) {
                return new InstallFound(visualStudioInstall);
            }
        });
    }

    @Override
    public VisualStudioLocator.SearchResult locateDefaultVisualStudioInstall() {
        return this.locateDefaultVisualStudioInstall(null);
    }

    @Override
    public VisualStudioLocator.SearchResult locateDefaultVisualStudioInstall(File candidate) {
        if (candidate != null) {
            return this.locateUserSpecifiedInstall(candidate);
        }
        return this.determineDefaultInstall();
    }

    private void initializeVisualStudioInstalls() {
        if (!this.initialised) {
            this.locateInstallsWith(this.commandLineLocator);
            if (this.foundInstalls.isEmpty()) {
                this.locateInstallsWith(this.windowsRegistryLocator);
            }
            if (this.foundInstalls.isEmpty()) {
                this.locateInstallsWith(this.systemPathLocator);
            }
            this.initialised = true;
        }
    }

    private void locateInstallsWith(VisualStudioVersionLocator versionLocator) {
        List<VisualStudioMetadata> installs = versionLocator.getVisualStudioInstalls();
        for (VisualStudioMetadata install : installs) {
            this.addInstallIfValid(install, versionLocator.getSource());
        }
    }

    private boolean addInstallIfValid(VisualStudioMetadata install, String source) {
        File visualCppDir = install.getVisualCppDir();
        File visualStudioDir = install.getInstallDir();
        if (this.foundInstalls.containsKey(visualStudioDir)) {
            return true;
        }
        if (DefaultVisualStudioLocator.isValidInstall(install) && install.getVisualCppVersion() != VersionNumber.UNKNOWN) {
            LOGGER.debug("Found Visual C++ {} at {}", (Object)install.getVisualCppVersion(), (Object)visualCppDir);
            VersionNumber visualStudioVersion = install.getVersion();
            String visualStudioDisplayVersion = install.getVersion() == VersionNumber.UNKNOWN ? "from " + source : install.getVersion().toString();
            VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ " + install.getVisualCppVersion(), visualStudioDir, visualCppDir, install.getVisualCppVersion(), install.getCompatibility());
            VisualStudioInstall visualStudio = new VisualStudioInstall("Visual Studio " + visualStudioDisplayVersion, visualStudioDir, visualStudioVersion, visualCpp);
            this.foundInstalls.put(visualStudioDir, visualStudio);
            return true;
        }
        LOGGER.debug("Ignoring candidate Visual C++ directory {} as it does not look like a Visual C++ installation.", (Object)visualCppDir);
        return false;
    }

    private VisualStudioLocator.SearchResult locateUserSpecifiedInstall(File candidate) {
        VisualStudioMetadata install = this.versionDeterminer.getVisualStudioMetadataFromInstallDir(candidate);
        if (install != null && this.addInstallIfValid(install, "user provided path")) {
            return new InstallFound(this.foundInstalls.get(install.getInstallDir()));
        }
        LOGGER.debug("Ignoring candidate Visual C++ install for {} as it does not look like a Visual C++ installation.", (Object)candidate);
        return new InstallNotFound(String.format("The specified installation directory '%s' does not appear to contain a Visual Studio installation.", candidate));
    }

    private VisualCppInstall buildVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version, VisualStudioMetadata.Compatibility compatibility) {
        switch (compatibility) {
            case LEGACY: {
                return this.buildLegacyVisualCppInstall(name, vsPath, basePath, version);
            }
            case VS2017_OR_LATER: {
                return this.buildVisualCppInstall(name, vsPath, basePath, version);
            }
        }
        throw new IllegalArgumentException("Cannot build VisualCpp install for unknown compatibility level: " + (Object)((Object)compatibility));
    }

    private VisualCppInstall buildLegacyVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version) {
        boolean isNativeAmd64;
        ArrayList architectureDescriptorBuilders = Lists.newArrayList();
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_X86_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_AMD64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_IA64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_ARM_ON_X86);
        boolean bl = isNativeAmd64 = this.systemInfo.getArchitecture() == SystemInfo.Architecture.amd64;
        if (isNativeAmd64) {
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_AMD64_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_X86_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_ARM_ON_AMD64);
        }
        HashMap descriptors = Maps.newHashMap();
        for (ArchitectureDescriptorBuilder architectureDescriptorBuilder : architectureDescriptorBuilders) {
            ArchitectureDescriptor descriptor = architectureDescriptorBuilder.buildDescriptor(basePath, vsPath);
            if (!descriptor.isInstalled()) continue;
            descriptors.put(architectureDescriptorBuilder.architecture, descriptor);
        }
        return new VisualCppInstall(name, version, descriptors);
    }

    private VisualCppInstall buildVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version) {
        boolean isNativeAmd64;
        ArrayList architectureDescriptorBuilders = Lists.newArrayList();
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.X86_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.AMD64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.ARM_ON_X86);
        boolean bl = isNativeAmd64 = this.systemInfo.getArchitecture() == SystemInfo.Architecture.amd64;
        if (isNativeAmd64) {
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.AMD64_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.X86_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.ARM_ON_AMD64);
        }
        HashMap descriptors = Maps.newHashMap();
        for (ArchitectureDescriptorBuilder architectureDescriptorBuilder : architectureDescriptorBuilders) {
            ArchitectureDescriptor descriptor = architectureDescriptorBuilder.buildDescriptor(basePath, vsPath);
            if (!descriptor.isInstalled()) continue;
            descriptors.put(architectureDescriptorBuilder.architecture, descriptor);
        }
        return new VisualCppInstall(name, version, descriptors);
    }

    private VisualStudioLocator.SearchResult determineDefaultInstall() {
        this.initializeVisualStudioInstalls();
        VisualStudioInstall candidate = null;
        for (VisualStudioInstall visualStudio : this.foundInstalls.values()) {
            if (candidate != null && visualStudio.getVersion().compareTo(candidate.getVersion()) <= 0) continue;
            candidate = visualStudio;
        }
        return candidate == null ? new InstallNotFound("Could not locate a Visual Studio installation, using the command line tool, Windows registry or system path.") : new InstallFound(candidate);
    }

    private static boolean isValidInstall(VisualStudioMetadata install) {
        switch (install.getCompatibility()) {
            case LEGACY: {
                return new File(install.getInstallDir(), PATH_COMMON).isDirectory() && DefaultVisualStudioLocator.isLegacyVisualCpp(install.getVisualCppDir());
            }
            case VS2017_OR_LATER: {
                return new File(install.getInstallDir(), PATH_COMMON).isDirectory() && DefaultVisualStudioLocator.isVS2017VisualCpp(install.getVisualCppDir());
            }
        }
        throw new IllegalArgumentException("Cannot determine valid install for unknown compatibility: " + (Object)((Object)install.getCompatibility()));
    }

    private static boolean isLegacyVisualCpp(File candidate) {
        return new File(candidate, "bin/cl.exe").isFile();
    }

    private static boolean isVS2017VisualCpp(File candidate) {
        return new File(candidate, "bin/HostX86/x86/cl.exe").isFile();
    }

    private static class InstallNotFound
    implements VisualStudioLocator.SearchResult {
        private final String message;

        private InstallNotFound(String message) {
            this.message = message;
        }

        @Override
        public VisualStudioInstall getVisualStudio() {
            return null;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node(this.message);
        }
    }

    private static class InstallFound
    implements VisualStudioLocator.SearchResult {
        private final VisualStudioInstall install;

        public InstallFound(VisualStudioInstall install) {
            this.install = (VisualStudioInstall)Preconditions.checkNotNull((Object)install);
        }

        @Override
        public VisualStudioInstall getVisualStudio() {
            return this.install;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

