/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LegacyWindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitWindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitWindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.util.TreeVisitor;

public class DefaultWindowsSdkLocator
implements WindowsSdkLocator {
    private final WindowsSdkLocator legacyWindowsSdkLocator;
    private final WindowsKitComponentLocator<WindowsKitWindowsSdk> windowsKitWindowsSdkLocator;

    @VisibleForTesting
    DefaultWindowsSdkLocator(WindowsSdkLocator legacyWindowsSdkLocator, WindowsKitComponentLocator<WindowsKitWindowsSdk> windowsKitWindowsSdkLocator) {
        this.legacyWindowsSdkLocator = legacyWindowsSdkLocator;
        this.windowsKitWindowsSdkLocator = windowsKitWindowsSdkLocator;
    }

    public DefaultWindowsSdkLocator(OperatingSystem operatingSystem, WindowsRegistry windowsRegistry) {
        this(new LegacyWindowsSdkLocator(operatingSystem, windowsRegistry), new WindowsKitWindowsSdkLocator(windowsRegistry));
    }

    @Override
    public WindowsSdkLocator.SearchResult locateWindowsSdks(File candidate) {
        return new SdkSearchResult(this.legacyWindowsSdkLocator.locateWindowsSdks(candidate), this.windowsKitWindowsSdkLocator.locateComponents(candidate));
    }

    @Override
    public List<WindowsSdk> locateAllWindowsSdks() {
        ArrayList allSdks = Lists.newArrayList();
        allSdks.addAll(this.legacyWindowsSdkLocator.locateAllWindowsSdks());
        allSdks.addAll(this.windowsKitWindowsSdkLocator.locateAllComponents());
        return allSdks;
    }

    private static class SdkSearchResult
    implements WindowsSdkLocator.SearchResult {
        final WindowsSdkLocator.SearchResult legacySearchResult;
        final WindowsKitComponentLocator.SearchResult<WindowsKitWindowsSdk> windowsKitSearchResult;

        SdkSearchResult(WindowsSdkLocator.SearchResult legacySearchResult, WindowsKitComponentLocator.SearchResult<WindowsKitWindowsSdk> windowsKitSearchResult) {
            this.legacySearchResult = legacySearchResult;
            this.windowsKitSearchResult = windowsKitSearchResult;
        }

        @Override
        public WindowsSdk getSdk() {
            if (this.windowsKitSearchResult.isAvailable()) {
                return this.windowsKitSearchResult.getComponent();
            }
            if (this.legacySearchResult.isAvailable()) {
                return this.legacySearchResult.getSdk();
            }
            return null;
        }

        @Override
        public boolean isAvailable() {
            return this.windowsKitSearchResult.isAvailable() || this.legacySearchResult.isAvailable();
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            this.legacySearchResult.explain(visitor);
        }
    }
}

