/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.gson.stream.JsonReader;
import org.gradle.internal.io.NullOutputStream;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.AbstractVisualStudioVersionLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppMetadata;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetadata;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetadataBuilder;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioVersionLocator;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.VersionNumber;

public class CommandLineToolVersionLocator
extends AbstractVisualStudioVersionLocator
implements VisualStudioVersionLocator {
    private static final Logger LOGGER = Logging.getLogger(CommandLineToolVersionLocator.class);
    private final ExecActionFactory execActionFactory;
    private final WindowsRegistry windowsRegistry;
    private final OperatingSystem os;
    private final VisualCppMetadataProvider visualCppMetadataProvider;
    private static final String[] PROGRAM_FILES_KEYS = new String[]{"ProgramFilesDir", "ProgramFilesDir (x86)"};
    private static final String REGISTRY_PATH_WINDOWS = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion";
    private static final String VISUAL_STUDIO_INSTALLER = "Microsoft Visual Studio/Installer";
    private static final String VSWHERE_EXE = "vswhere.exe";
    private static final String INSTALLATION_PATH_KEY = "installationPath";
    private static final String INSTALLATION_VERSION_KEY = "installationVersion";

    public CommandLineToolVersionLocator(ExecActionFactory execActionFactory, WindowsRegistry windowsRegistry, OperatingSystem os, VisualCppMetadataProvider visualCppMetadataProvider) {
        this.execActionFactory = execActionFactory;
        this.windowsRegistry = windowsRegistry;
        this.os = os;
        this.visualCppMetadataProvider = visualCppMetadataProvider;
    }

    @Override
    protected List<VisualStudioMetadata> locateInstalls() {
        ArrayList installs = Lists.newArrayList();
        File vswhereBinary = this.findVswhereBinary();
        if (vswhereBinary != null) {
            ArrayList args = Lists.newArrayList((Object[])new String[]{"-all", "-legacy", "-format", "json"});
            String json = this.getVswhereOutput(vswhereBinary, args);
            installs.addAll(this.parseJson(json));
        }
        return installs;
    }

    @Override
    public String getSource() {
        return "command line tool";
    }

    private File findVswhereBinary() {
        for (String programFilesKey : PROGRAM_FILES_KEYS) {
            File programFilesDir;
            try {
                programFilesDir = new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, REGISTRY_PATH_WINDOWS, programFilesKey));
            }
            catch (MissingRegistryEntryException e) {
                continue;
            }
            File candidate = new File(programFilesDir, "Microsoft Visual Studio/Installer/vswhere.exe");
            if (!candidate.exists() || !candidate.isFile()) continue;
            return candidate;
        }
        return this.os.findInPath(VSWHERE_EXE);
    }

    private String getVswhereOutput(File vswhereBinary, List<String> args) {
        ExecAction exec = this.execActionFactory.newExecAction();
        exec.args(args);
        exec.executable(vswhereBinary.getAbsolutePath());
        exec.setWorkingDir(vswhereBinary.getParentFile());
        StreamByteBuffer buffer = new StreamByteBuffer();
        exec.setStandardOutput(buffer.getOutputStream());
        exec.setErrorOutput(NullOutputStream.INSTANCE);
        exec.setIgnoreExitValue(true);
        ExecResult result = exec.execute();
        int exitValue = result.getExitValue();
        if (exitValue == 0) {
            return buffer.readAsString("UTF-8");
        }
        LOGGER.debug("vswhere.exe returned a non-zero exit value ({}) - ignoring", result.getExitValue());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VisualStudioMetadata> parseJson(String json) {
        ArrayList installs = Lists.newArrayList();
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        try {
            try {
                reader.beginArray();
                while (reader.hasNext()) {
                    installs.add(this.readInstall(reader));
                }
                reader.endArray();
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        return installs;
    }

    private VisualStudioMetadata readInstall(JsonReader reader) throws IOException {
        String visualStudioInstallPath = null;
        String visualStudioVersion = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (key.equals(INSTALLATION_PATH_KEY)) {
                visualStudioInstallPath = reader.nextString();
                continue;
            }
            if (key.equals(INSTALLATION_VERSION_KEY)) {
                visualStudioVersion = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        File visualStudioInstallDir = new File(visualStudioInstallPath);
        VisualCppMetadata visualCppMetadata = this.findVisualCppMetadata(visualStudioInstallDir, visualStudioVersion);
        return new VisualStudioMetadataBuilder().installDir(visualStudioInstallDir).visualCppDir(visualCppMetadata.getVisualCppDir()).version(VersionNumber.parse(visualStudioVersion)).visualCppVersion(visualCppMetadata.getVersion()).build();
    }

    private VisualCppMetadata findVisualCppMetadata(File installDir, String version) {
        if (VersionNumber.parse(version).getMajor() >= 15) {
            return this.visualCppMetadataProvider.getVisualCppFromMetadataFile(installDir);
        }
        return this.visualCppMetadataProvider.getVisualCppFromRegistry(version);
    }
}

