/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.nativeplatform.toolchain.internal.metadata.AbstractMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerType;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadata;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;

public class SwiftcMetadataProvider
extends AbstractMetadataProvider<SwiftcMetadata> {
    private static final CompilerType SWIFTC_COMPILER_TYPE = new CompilerType(){

        @Override
        public String getIdentifier() {
            return "swiftc";
        }

        @Override
        public String getDescription() {
            return "SwiftC";
        }
    };

    public SwiftcMetadataProvider(ExecActionFactory execActionFactory) {
        super(execActionFactory);
    }

    @Override
    protected List<String> compilerArgs() {
        return ImmutableList.of((Object)"--version");
    }

    @Override
    protected SwiftcMetadata brokenMetadata(String message) {
        return new BrokenMetadata(message);
    }

    @Override
    public CompilerType getCompilerType() {
        return SWIFTC_COMPILER_TYPE;
    }

    @Override
    protected SwiftcMetadata parseCompilerOutput(String stdout, String stderr, File swiftc) {
        BufferedReader reader = new BufferedReader(new StringReader(stdout));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("Swift version")) continue;
                return new DefaultSwiftcMetadata(line);
            }
            return new BrokenMetadata(String.format("Could not determine %s metadata: %s produced unexpected output.", this.getCompilerType().getDescription(), swiftc.getName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class DefaultSwiftcMetadata
    implements SwiftcMetadata {
        private final String versionString;

        public DefaultSwiftcMetadata(String versionString) {
            this.versionString = versionString;
        }

        @Override
        public String getVendor() {
            return this.versionString;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
        }
    }

    private class BrokenMetadata
    extends AbstractMetadataProvider.AbstractBrokenMetadata
    implements SwiftcMetadata {
        public BrokenMetadata(String message) {
            super(message);
        }
    }
}

