/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;

public class ExecOutputHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecOutputHandleRunner.class);
    private final String displayName;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final int bufferSize;

    public ExecOutputHandleRunner(String displayName, InputStream inputStream, OutputStream outputStream) {
        this(displayName, inputStream, outputStream, 2048);
    }

    ExecOutputHandleRunner(String displayName, InputStream inputStream, OutputStream outputStream, int bufferSize) {
        this.displayName = displayName;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.bufferSize = bufferSize;
    }

    public void run() {
        byte[] buffer = new byte[this.bufferSize];
        try {
            int nread;
            while ((nread = this.inputStream.read(buffer)) >= 0) {
                this.outputStream.write(buffer, 0, nread);
                this.outputStream.flush();
            }
            CompositeStoppable.stoppable(this.inputStream, this.outputStream).stop();
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Could not %s.", this.displayName), t);
        }
    }

    public void closeInput() throws IOException {
        this.inputStream.close();
    }

    public String toString() {
        return this.displayName;
    }
}

