/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.util.BulkReadInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisconnectableInputStream
extends BulkReadInputStream {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final byte[] buffer;
    private int readPos;
    private int writePos;
    private boolean closed;
    private boolean inputFinished;

    public DisconnectableInputStream(InputStream source) {
        this(source, 1024);
    }

    public DisconnectableInputStream(InputStream source, int bufferLength) {
        this(source, new ThreadExecuter(), bufferLength);
    }

    DisconnectableInputStream(InputStream source, Action<Runnable> executer) {
        this(source, executer, 1024);
    }

    DisconnectableInputStream(final InputStream source, Action<Runnable> executer, int bufferLength) {
        this.buffer = new byte[bufferLength];
        Runnable consume = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (true) {
                        int pos;
                        DisconnectableInputStream.this.lock.lock();
                        try {
                            while (!DisconnectableInputStream.this.closed && DisconnectableInputStream.this.writePos == DisconnectableInputStream.this.buffer.length && DisconnectableInputStream.this.writePos != DisconnectableInputStream.this.readPos) {
                                DisconnectableInputStream.this.condition.await();
                            }
                            assert (DisconnectableInputStream.this.writePos >= DisconnectableInputStream.this.readPos);
                            if (DisconnectableInputStream.this.closed) {
                                DisconnectableInputStream.this.inputFinished = true;
                                DisconnectableInputStream.this.condition.signalAll();
                                return;
                            }
                            if (DisconnectableInputStream.this.readPos == DisconnectableInputStream.this.writePos) {
                                DisconnectableInputStream.this.readPos = 0;
                                DisconnectableInputStream.this.writePos = 0;
                            }
                            pos = DisconnectableInputStream.this.writePos;
                        }
                        finally {
                            DisconnectableInputStream.this.lock.unlock();
                        }
                        int nread = source.read(DisconnectableInputStream.this.buffer, pos, DisconnectableInputStream.this.buffer.length - pos);
                        DisconnectableInputStream.this.lock.lock();
                        try {
                            if (nread > 0) {
                                assert (DisconnectableInputStream.this.writePos >= DisconnectableInputStream.this.readPos);
                                DisconnectableInputStream.this.writePos += nread;
                                assert (DisconnectableInputStream.this.buffer.length >= DisconnectableInputStream.this.writePos);
                                DisconnectableInputStream.this.condition.signalAll();
                            }
                            if (nread >= 0) continue;
                            DisconnectableInputStream.this.inputFinished = true;
                            DisconnectableInputStream.this.condition.signalAll();
                            return;
                        }
                        finally {
                            DisconnectableInputStream.this.lock.unlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    DisconnectableInputStream.this.lock.lock();
                    try {
                        DisconnectableInputStream.this.inputFinished = true;
                        DisconnectableInputStream.this.condition.signalAll();
                    }
                    finally {
                        DisconnectableInputStream.this.lock.unlock();
                    }
                    throw UncheckedException.throwAsUncheckedException(throwable);
                }
            }
        };
        executer.execute(consume);
    }

    @Override
    public int read(byte[] bytes, int pos, int count) throws IOException {
        this.lock.lock();
        try {
            while (!this.inputFinished && !this.closed && this.readPos == this.writePos) {
                this.condition.await();
            }
            if (this.closed) {
                int n = -1;
                return n;
            }
            if (this.writePos > this.readPos) {
                int nread = Math.min(count, this.writePos - this.readPos);
                System.arraycopy(this.buffer, this.readPos, bytes, pos, nread);
                this.readPos += nread;
                assert (this.writePos >= this.readPos);
                this.condition.signalAll();
                int n = nread;
                return n;
            }
            assert (this.inputFinished);
            int nread = -1;
            return nread;
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.closed = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThreadExecuter
    implements Action<Runnable> {
        ThreadExecuter() {
        }

        @Override
        public void execute(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("DisconnectableInputStream source reader");
            thread.setDaemon(true);
            thread.start();
        }
    }
}

