/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.VersionControlSystem;
import org.gradle.vcs.VersionRef;
import org.gradle.vcs.git.internal.GitVersionControlSystem;
import org.gradle.vcs.internal.DirectoryRepositorySpec;
import org.gradle.vcs.internal.SimpleVersionControlSystem;
import org.gradle.vcs.internal.VersionControlSystemFactory;

public class DefaultVersionControlSystemFactory
implements VersionControlSystemFactory {
    private final CacheRepository cacheRepository;

    DefaultVersionControlSystemFactory(CacheRepository cacheRepository) {
        this.cacheRepository = cacheRepository;
    }

    @Override
    public VersionControlSystem create(VersionControlSpec spec) {
        VersionControlSystem vcs = spec instanceof DirectoryRepositorySpec ? new SimpleVersionControlSystem() : new GitVersionControlSystem();
        return new LockingVersionControlSystem(vcs, this.cacheRepository);
    }

    private static final class LockingVersionControlSystem
    implements VersionControlSystem {
        private final VersionControlSystem delegate;
        private final CacheRepository cacheRepository;

        private LockingVersionControlSystem(VersionControlSystem delegate, CacheRepository cacheRepository) {
            this.delegate = delegate;
            this.cacheRepository = cacheRepository;
        }

        @Override
        public Set<VersionRef> getAvailableVersions(VersionControlSpec spec) {
            try {
                return this.delegate.getAvailableVersions(spec);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not list available versions for '%s'.", spec.getDisplayName()), e);
            }
        }

        @Override
        public File populate(final File versionDir, final VersionRef ref, final VersionControlSpec spec) {
            try (PersistentCache cache = this.cacheRepository.cache(versionDir).withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive)).open();){
                File file = cache.useCache(new Factory<File>(){

                    @Override
                    @Nullable
                    public File create() {
                        return LockingVersionControlSystem.this.delegate.populate(versionDir, ref, spec);
                    }
                });
                return file;
            }
        }
    }
}

