/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityExpressionRootMethodsUtil {
    @Nullable
    public static PsiMethod findWebSecurityExpressionRootMethod(@Nullable String methodName, @Nullable Module module) {
        return SecurityExpressionRootMethodsUtil.findExpressionMethod(methodName, module, "org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
    }

    private static PsiMethod findExpressionMethod(@Nullable String methodName, @Nullable Module module, String expressionRootClss) {
        if (module != null && methodName != null) {
            for (PsiMethod psiMethod : SecurityExpressionRootMethodsUtil.getExpressionRootMethods(SecurityExpressionRootMethodsUtil.getExpressionRootClass(module, expressionRootClss))) {
                if (!methodName.startsWith(psiMethod.getName())) continue;
                return psiMethod;
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getExpressionRootClass(@Nullable Module module, @NotNull String rootContextClass) {
        if (rootContextClass == null) {
            SecurityExpressionRootMethodsUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            return null;
        }
        PsiClass securityExpressionRoot = SpringCommonUtils.findLibraryClass((Module)module, (String)rootContextClass);
        if (securityExpressionRoot != null) {
            return securityExpressionRoot;
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)SecurityExpressionRootMethodsUtil.getDefaultRootClassName());
    }

    @NotNull
    public static String getDefaultRootClassName() {
        if ("org.springframework.security.access.expression.SecurityExpressionRoot" == null) {
            SecurityExpressionRootMethodsUtil.$$$reportNull$$$0(1);
        }
        return "org.springframework.security.access.expression.SecurityExpressionRoot";
    }

    @NotNull
    public static Set<PsiMethod> getExpressionRootMethods(@Nullable Module module, @NotNull String rootContextClass) {
        if (rootContextClass == null) {
            SecurityExpressionRootMethodsUtil.$$$reportNull$$$0(2);
        }
        Set<PsiMethod> set = SecurityExpressionRootMethodsUtil.getExpressionRootMethods(SecurityExpressionRootMethodsUtil.getExpressionRootClass(module, rootContextClass));
        if (set == null) {
            SecurityExpressionRootMethodsUtil.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Set<PsiMethod> getExpressionRootMethods(@Nullable PsiClass psiClass) {
        HashSet methods = ContainerUtil.newHashSet();
        if (psiClass != null) {
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (psiMethod.isConstructor() || psiMethod.hasModifierProperty("private") || containingClass == null || containingClass.isInterface() || "java.lang.Object".equals(containingClass.getQualifiedName()) || !PsiType.BOOLEAN.equals((Object)psiMethod.getReturnType())) continue;
                methods.add(psiMethod);
            }
        }
        HashSet hashSet = methods;
        if (hashSet == null) {
            SecurityExpressionRootMethodsUtil.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContextClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRootClassName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionRootMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionRootClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionRootMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

