/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.application.options.editor.AutoImportOptionsConfigurable;
import com.intellij.application.options.editor.JavaAutoImportOptions;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportAction
implements QuestionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.actions.AddImportAction");
    private final Project myProject;
    private final PsiReference myReference;
    private final PsiClass[] myTargetClasses;
    private final Editor myEditor;

    public AddImportAction(@NotNull Project project, @NotNull PsiReference ref, @NotNull Editor editor, PsiClass ... targetClasses) {
        if (project == null) {
            AddImportAction.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            AddImportAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            AddImportAction.$$$reportNull$$$0(2);
        }
        if (targetClasses == null) {
            AddImportAction.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myReference = ref;
        this.myTargetClasses = targetClasses;
        this.myEditor = editor;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (!this.myReference.getElement().isValid()) {
            return false;
        }
        for (PsiClass myTargetClass : this.myTargetClasses) {
            if (myTargetClass.isValid()) continue;
            return false;
        }
        if (this.myTargetClasses.length == 1) {
            this.addImport(this.myReference, this.myTargetClasses[0]);
        } else {
            this.chooseClassAndImport();
        }
        return true;
    }

    private void chooseClassAndImport() {
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])this.myTargetClasses, (PsiReference)this.myReference);
        BaseListPopupStep<PsiClass> step2 = new BaseListPopupStep<PsiClass>(QuickFixBundle.message("class.to.import.chooser.title", new Object[0]), this.myTargetClasses){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(PsiClass selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    return this.doFinalStep(() -> {
                        PsiDocumentManager.getInstance((Project)AddImportAction.this.myProject).commitAllDocuments();
                        AddImportAction.this.addImport(AddImportAction.this.myReference, selectedValue);
                    });
                }
                return AddImportAction.getExcludesStep(selectedValue.getQualifiedName(), AddImportAction.this.myProject);
            }

            public boolean hasSubstep(PsiClass selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(PsiClass value2) {
                String string = (String)ObjectUtils.assertNotNull((Object)value2.getQualifiedName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(PsiClass aValue) {
                return aValue.getIcon(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction$1", "getTextFor"));
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step2){

            protected ListCellRenderer getListElementRenderer() {
                final PopupListElementRenderer baseRenderer = (PopupListElementRenderer)super.getListElementRenderer();
                final DefaultPsiElementCellRenderer psiRenderer = new DefaultPsiElementCellRenderer();
                return new ListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                        JPanel panel = new JPanel(new BorderLayout());
                        baseRenderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
                        panel.add((Component)baseRenderer.getNextStepLabel(), "East");
                        panel.add(psiRenderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus));
                        return panel;
                    }
                };
            }
        };
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)this.myProject);
        popup.showInBestPositionFor(this.myEditor);
    }

    @Nullable
    public static PopupStep getExcludesStep(String qname, final Project project) {
        if (qname == null) {
            return PopupStep.FINAL_CHOICE;
        }
        List<String> toExclude = AddImportAction.getAllExcludableStrings(qname);
        return new BaseListPopupStep<String>(null, toExclude){

            @NotNull
            public String getTextFor(String value2) {
                String string = "Exclude '" + value2 + "' from auto-import";
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (finalChoice) {
                    AddImportAction.excludeFromImport(project, selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction$3", "getTextFor"));
            }
        };
    }

    public static void excludeFromImport(Project project, String prefix) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            AutoImportOptionsConfigurable configurable = new AutoImportOptionsConfigurable(project);
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
                JavaAutoImportOptions options = (JavaAutoImportOptions)ContainerUtil.findInstance((Iterable)configurable.getConfigurables(), JavaAutoImportOptions.class);
                options.addExcludePackage(prefix);
            });
        });
    }

    public static List<String> getAllExcludableStrings(@NotNull String qname) {
        if (qname == null) {
            AddImportAction.$$$reportNull$$$0(4);
        }
        ArrayList<String> toExclude = new ArrayList<String>();
        while (true) {
            toExclude.add(qname);
            int i = qname.lastIndexOf(46);
            if (i < 0 || i == qname.indexOf(46)) break;
            qname = qname.substring(0, i);
        }
        return toExclude;
    }

    private void addImport(PsiReference ref, PsiClass targetClass) {
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> {
            if (!ref.getElement().isValid() || !targetClass.isValid() || ref.resolve() == targetClass) {
                return;
            }
            StatisticsManager.getInstance().incUseCount(JavaStatisticsManager.createInfo(null, (PsiMember)targetClass));
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)QuickFixBundle.message("add.import", new Object[0]), null, () -> this._addImport(ref, targetClass), (PsiFile[])new PsiFile[]{ref.getElement().getContainingFile()});
        });
    }

    private void _addImport(PsiReference ref, PsiClass targetClass) {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        RangeMarker caretMarker = this.myEditor.getDocument().createRangeMarker(caretOffset, caretOffset);
        int col = this.myEditor.getCaretModel().getLogicalPosition().column;
        int colByOffset = this.myEditor.offsetToLogicalPosition((int)caretOffset).column;
        int virtualSpace = col == colByOffset ? 0 : col - colByOffset;
        int line = this.myEditor.getCaretModel().getLogicalPosition().line;
        LogicalPosition pos = new LogicalPosition(line, 0);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        try {
            this.bindReference(ref, targetClass);
            if (CodeInsightWorkspaceSettings.getInstance((Project)this.myProject).optimizeImportsOnTheFly) {
                Document document = this.myEditor.getDocument();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                new OptimizeImportsProcessor(this.myProject, psiFile).runWithoutProgress();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        line = this.myEditor.getCaretModel().getLogicalPosition().line;
        LogicalPosition pos1 = new LogicalPosition(line, col);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos1);
        if (caretMarker.isValid()) {
            LogicalPosition pos2 = this.myEditor.offsetToLogicalPosition(caretMarker.getStartOffset());
            int newCol = pos2.column + virtualSpace;
            this.myEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(pos2.line, newCol));
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    protected void bindReference(PsiReference ref, PsiClass targetClass) {
        ref.bindToElement((PsiElement)targetClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClasses";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/AddImportAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllExcludableStrings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

