/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ConvertToStringLiteralAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("convert.to.string.text", new Object[0]);
        if (string == null) {
            ConvertToStringLiteralAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("convert.to.string.family", new Object[0]);
        if (string == null) {
            ConvertToStringLiteralAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertToStringLiteralAction.$$$reportNull$$$0(2);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.CHARACTER_LITERAL);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String text2;
        int length;
        PsiElement element;
        if (project == null) {
            ConvertToStringLiteralAction.$$$reportNull$$$0(3);
        }
        if ((element = file.findElementAt(editor.getCaretModel().getOffset())) != null && PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.CHARACTER_LITERAL) && (length = (text2 = StringUtil.unescapeStringCharacters((String)element.getText())).length()) > 1 && text2.charAt(0) == '\'' && text2.charAt(length - 1) == '\'') {
            String value2 = StringUtil.escapeStringCharacters((String)text2.substring(1, length - 1));
            PsiExpression expression2 = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText('\"' + value2 + '\"', null);
            PsiElement literal = expression2.getFirstChild();
            if (literal != null && PsiUtil.isJavaToken((PsiElement)literal, (IElementType)JavaTokenType.STRING_LITERAL)) {
                element.replace(literal);
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertToStringLiteralAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertToStringLiteralAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

