/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyStaticMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QualifyStaticConstantFix
extends StaticImportConstantFix {
    public QualifyStaticConstantFix(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        if (referenceElement == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(0);
        }
        super(referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        if ("Qualify static constant access" == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(1);
        }
        return "Qualify static constant access";
    }

    @Override
    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(List<PsiField> fieldsToImport, final @NotNull Project project, Editor editor) {
        if (project == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(2);
        }
        StaticImportMethodQuestionAction<PsiField> staticImportMethodQuestionAction = new StaticImportMethodQuestionAction<PsiField>(project, editor, fieldsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                String string = QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected void doImport(PsiField toImport) {
                PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)QualifyStaticConstantFix.this.myRef.getElement();
                if (!(element instanceof PsiReferenceExpression)) {
                    return;
                }
                QualifyStaticMethodCallFix.qualifyStatically((PsiMember)toImport, project, (PsiReferenceExpression)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticConstantFix$1", "getPopupTitle"));
            }
        };
        if (staticImportMethodQuestionAction == null) {
            QualifyStaticConstantFix.$$$reportNull$$$0(3);
        }
        return staticImportMethodQuestionAction;
    }

    @Override
    protected boolean toAddStaticImports() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticConstantFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticConstantFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuestionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createQuestionAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

