/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiVariable;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SideEffectWarningDialog
extends DialogWrapper {
    private final PsiVariable myVariable;
    private final String myBeforeText;
    private final String myAfterText;
    private final boolean myCanCopeWithSideEffects;
    private AbstractAction myRemoveAllAction;
    private AbstractAction myCancelAllAction;

    public SideEffectWarningDialog(Project project, boolean canBeParent, PsiVariable variable, String beforeText, String afterText, boolean canCopeWithSideEffects) {
        super(project, canBeParent);
        this.myVariable = variable;
        this.myBeforeText = beforeText;
        this.myAfterText = afterText;
        this.myCanCopeWithSideEffects = canCopeWithSideEffects;
        this.setTitle(QuickFixBundle.message("side.effects.warning.dialog.title", new Object[0]));
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        this.myRemoveAllAction = new AbstractAction(){
            {
                UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.remove", new Object[0]), (Action)this);
                this.putValue("DefaultAction", this);
            }

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                SideEffectWarningDialog.this.close(RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL.ordinal());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog$1", "actionPerformed"));
            }
        };
        actions.add(this.myRemoveAllAction);
        if (this.myCanCopeWithSideEffects) {
            AbstractAction makeStmtAction = new AbstractAction(){
                {
                    UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.transform", new Object[0]), (Action)this);
                    if (SystemInfo.isMac) {
                        this.putValue("FocusedAction", this);
                    }
                }

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    SideEffectWarningDialog.this.close(RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT.ordinal());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog$2", "actionPerformed"));
                }
            };
            actions.add(makeStmtAction);
        }
        this.myCancelAllAction = new AbstractAction(){
            {
                UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.cancel", new Object[0]), (Action)this);
            }

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                SideEffectWarningDialog.this.doCancelAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog$3", "actionPerformed"));
            }
        };
        actions.add(this.myCancelAllAction);
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            SideEffectWarningDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @NotNull
    protected Action getCancelAction() {
        AbstractAction abstractAction = this.myCancelAllAction;
        if (abstractAction == null) {
            SideEffectWarningDialog.$$$reportNull$$$0(1);
        }
        return abstractAction;
    }

    @NotNull
    protected Action getOKAction() {
        AbstractAction abstractAction = this.myRemoveAllAction;
        if (abstractAction == null) {
            SideEffectWarningDialog.$$$reportNull$$$0(2);
        }
        return abstractAction;
    }

    public void doCancelAction() {
        this.close(RemoveUnusedVariableUtil.RemoveMode.CANCEL.ordinal());
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String text2 = this.sideEffectsDescription();
        JBLabel label = new JBLabel(text2);
        label.setIcon(Messages.getWarningIcon());
        panel.add((Component)label, "North");
        return panel;
    }

    protected String getFormatString() {
        return "<html>\n<body>\nThere are possible side effects found in {0}<br>\nYou can:\n<br>\n-&nbsp;<b>Remove</b> variable usages along with all expressions involved, or<br>\n-&nbsp;<b>Transform</b> expressions assigned to variable into the statements on their own.<br>\n<div style=\"padding-left: 0.6cm;\">\n  That is,<br>\n  <table border=\"0\">\n    <tr>\n      <td><code>{1};</code></td>\n    </tr>\n  </table>\n  becomes: <br>\n  <table border=\"0\">\n    <tr>\n      <td><code>{2};</code></td>\n    </tr>\n  </table>\n</div>\n</body>\n</html>";
    }

    protected String sideEffectsDescription() {
        if (this.myCanCopeWithSideEffects) {
            return MessageFormat.format(this.getFormatString(), "expressions assigned to the variable '" + this.myVariable.getName() + "'", this.myVariable.getType().getPresentableText() + " " + this.myVariable.getName() + " = " + this.myBeforeText, this.myAfterText);
        }
        return QuickFixBundle.message("side.effect.message1", this.myVariable.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

