/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.HighlightExceptionsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightExceptionsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        if (editor == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            HighlightExceptionsHandlerFactory.$$$reportNull$$$0(2);
        }
        if (target instanceof PsiKeyword) {
            PsiElement parent = target.getParent();
            if ("try".equals(target.getText()) && parent instanceof PsiTryStatement) {
                return HighlightExceptionsHandlerFactory.createHighlightTryHandler(editor, file, target, parent);
            }
            if ("catch".equals(target.getText()) && parent instanceof PsiCatchSection) {
                return HighlightExceptionsHandlerFactory.createHighlightCatchHandler(editor, file, target, parent);
            }
            if ("throws".equals(target.getText())) {
                return HighlightExceptionsHandlerFactory.createThrowsHandler(editor, file, target);
            }
        }
        return null;
    }

    @Nullable
    private static HighlightUsagesHandlerBase createHighlightTryHandler(Editor editor, PsiFile file, PsiElement target, PsiElement parent) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiCodeBlock tryBlock = ((PsiTryStatement)parent).getTryBlock();
        if (tryBlock == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
        PsiClassType[] types = unhandled.toArray(PsiClassType.EMPTY_ARRAY);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)tryBlock, null, (Condition<PsiType>)Conditions.alwaysTrue());
    }

    @Nullable
    private static HighlightUsagesHandlerBase createHighlightCatchHandler(Editor editor, PsiFile file, PsiElement target, PsiElement parent) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiTryStatement tryStatement = ((PsiCatchSection)parent).getTryStatement();
        PsiParameter parameter2 = ((PsiCatchSection)parent).getParameter();
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (parameter2 == null || tryBlock == null) {
            return null;
        }
        PsiParameter[] parameters2 = tryStatement.getCatchBlockParameters();
        Condition filter = type2 -> {
            for (PsiParameter p : parameters2) {
                boolean isAssignable = p.getType().isAssignableFrom(type2);
                if (p == parameter2) {
                    return isAssignable;
                }
                if (!isAssignable) continue;
                return false;
            }
            return false;
        };
        Stream<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock).stream();
        if (resourceList != null) {
            unhandled = Stream.concat(unhandled, ExceptionUtil.collectUnhandledExceptions((PsiElement)resourceList, (PsiElement)resourceList).stream());
        }
        PsiClassType[] types = (PsiClassType[])unhandled.filter(arg_0 -> ((Condition)filter).value(arg_0)).toArray(PsiClassType[]::new);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)tryBlock, (PsiElement)resourceList, (Condition<PsiType>)filter);
    }

    @Nullable
    private static HighlightUsagesHandlerBase createThrowsHandler(Editor editor, PsiFile file, PsiElement target) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiElement grand = target.getParent().getParent();
        if (!(grand instanceof PsiMethod)) {
            return null;
        }
        PsiCodeBlock body2 = ((PsiMethod)grand).getBody();
        if (body2 == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)body2, (PsiElement)body2);
        PsiClassType[] types = unhandled.toArray(PsiClassType.EMPTY_ARRAY);
        return new HighlightExceptionsHandler(editor, file, target, types, (PsiElement)body2, null, (Condition<PsiType>)Conditions.alwaysTrue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/highlighting/HighlightExceptionsHandlerFactory";
        objectArray[2] = "createHighlightUsagesHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

