/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.AnnotationHintsPass;
import com.intellij.codeInsight.hints.AnnotationHintsPassFactory;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.DocumentUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass;", "Lcom/intellij/codeHighlighting/EditorBoundHighlightingPass;", "rootElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "hints", "Lgnu/trove/TIntObjectHashMap;", "", "Lcom/intellij/codeInsight/hints/AnnotationHintsPass$HintData;", "traverser", "Lcom/intellij/psi/SyntaxTraverser;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "process", "element", "AnnotationHintRenderer", "Companion", "HintData", "ToggleExternalAnnotationsHintsAction", "ToggleInferredAnnotationsHintsAction", "intellij.java.impl"})
public final class AnnotationHintsPass
extends EditorBoundHighlightingPass {
    private final TIntObjectHashMap<List<HintData>> hints;
    private final SyntaxTraverser<PsiElement> traverser;
    private final PsiElement rootElement;
    private static final Key<Boolean> ANNOTATION_INLAY_KEY;
    public static final Companion Companion;

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        VirtualFile virtualFile;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        boolean bl2 = bl = this.myDocument != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.hints.clear();
        PsiFile psiFile = this.rootElement.getContainingFile();
        VirtualFile virtualFile2 = psiFile != null && (psiFile = psiFile.getOriginalFile()) != null ? psiFile.getVirtualFile() : (virtualFile = null);
        if (CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE && virtualFile != null && ExternalAnnotationsManager.getInstance((Project)this.myProject).hasAnnotationRootsForFile(virtualFile) || CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE) {
            Iterable $receiver$iv = (Iterable)this.traverser;
            for (Object element$iv : $receiver$iv) {
                PsiElement it;
                PsiElement psiElement = it = (PsiElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                this.process(psiElement);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void process(PsiElement element) {
        if (element instanceof PsiModifierListOwner) {
            Sequence annotations2 = SequencesKt.emptySequence();
            if (CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE) {
                void $receiver$iv;
                Object[] objectArray = ExternalAnnotationsManager.getInstance((Project)this.myProject).findExternalAnnotations((PsiModifierListOwner)element);
                Sequence sequence = annotations2;
                PsiAnnotation[] psiAnnotationArray = $receiver$iv;
                if (psiAnnotationArray == null) {
                    psiAnnotationArray = new PsiAnnotation[]{};
                }
                void var14_5 = psiAnnotationArray;
                annotations2 = SequencesKt.plus((Sequence)sequence, (Object[])var14_5);
            }
            if (CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE) {
                PsiAnnotation[] psiAnnotationArray = InferredAnnotationsManager.getInstance((Project)this.myProject).findInferredAnnotations((PsiModifierListOwner)element);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"InferredAnnotationsManag\u2026erredAnnotations(element)");
                annotations2 = SequencesKt.plus((Sequence)annotations2, (Object[])psiAnnotationArray);
            }
            Set shownAnnotations = new LinkedHashSet();
            Sequence $receiver$iv = annotations2;
            for (Object element$iv : $receiver$iv) {
                PsiAnnotation it = (PsiAnnotation)element$iv;
                PsiJavaCodeReferenceElement nameReferenceElement = it.getNameReferenceElement();
                if (nameReferenceElement == null || ((PsiModifierListOwner)element).getModifierList() == null) continue;
                String string = nameReferenceElement.getQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameReferenceElement.qualifiedName");
                if (!shownAnnotations.add(string) && !JavaDocInfoGenerator.isRepeatableAnnotationType((PsiElement)it)) continue;
                PsiModifierList psiModifierList = ((PsiModifierListOwner)element).getModifierList();
                if (psiModifierList == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"element.modifierList!!");
                TextRange textRange = psiModifierList.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.modifierList!!.textRange");
                int offset = textRange.getStartOffset();
                List hintList = (List)this.hints.get(offset);
                if (hintList == null) {
                    hintList = new ArrayList();
                    this.hints.put(offset, (Object)hintList);
                }
                StringBuilder stringBuilder = new StringBuilder().append("@").append(nameReferenceElement.getReferenceName());
                PsiAnnotationParameterList psiAnnotationParameterList = it.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationParameterList, (String)"it.parameterList");
                hintList.add(new HintData(stringBuilder.append(psiAnnotationParameterList.getText()).toString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void var8_12;
        Object[] $receiver$iv$iv;
        Object[] $receiver$iv;
        CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
        Editor editor = this.myEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myEditor");
        InlayModel inlayModel = editor.getInlayModel();
        TextRange textRange = this.rootElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"rootElement.textRange");
        int n = textRange.getStartOffset() + 1;
        TextRange textRange2 = this.rootElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"rootElement.textRange");
        List list = inlayModel.getInlineElementsInRange(n, textRange2.getEndOffset() - 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"inlayModel.getInlineElem\u2026.textRange.endOffset - 1)");
        Iterable iterable = list;
        void var5_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object t : $receiver$iv$iv) {
            Inlay it = (Inlay)t;
            if (!AnnotationHintsPass.Companion.getANNOTATION_INLAY_KEY().isIn((UserDataHolder)it)) continue;
            destination$iv$iv.add(t);
        }
        $receiver$iv = (Object[])((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object t : $receiver$iv$iv) {
            Inlay inlay = (Inlay)t;
            List hintsList = (List)this.hints.get(inlay.getOffset());
            boolean bl = hintsList == null || !CollectionsKt.removeAll((List)hintsList, (Function1)((Function1)new Function1<HintData, Boolean>(inlay){
                final /* synthetic */ Inlay $inlay;

                public final boolean invoke(@NotNull HintData it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    EditorCustomElementRenderer editorCustomElementRenderer = this.$inlay.getRenderer();
                    if (editorCustomElementRenderer == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.hints.AnnotationHintsPass.AnnotationHintRenderer");
                    }
                    return Intrinsics.areEqual((Object)it.getPresentationText(), (Object)((AnnotationHintRenderer)editorCustomElementRenderer).getText());
                }
                {
                    this.$inlay = inlay;
                    super(1);
                }
            }));
            if (!bl) continue;
            destination$iv$iv.add(t);
        }
        List toRemove2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Editor editor2 = this.myEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"myEditor");
        Document document = editor2.getDocument();
        int n2 = toRemove2.size();
        Object[] objectArray = this.hints.getValues();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"hints.values");
        $receiver$iv = objectArray;
        int n3 = n2;
        Document document2 = document;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        int n4 = $receiver$iv$iv.length;
        boolean bl = false;
        while (var8_12 < n4) {
            Object element$iv$iv;
            Object it;
            Object object = it = (element$iv$iv = $receiver$iv$iv[var8_12]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<*>");
            }
            Iterable list$iv$iv = TypeIntrinsics.asMutableList((Object)object);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            ++var8_12;
        }
        List list2 = (List)destination$iv$iv;
        iterable = list2;
        int n5 = iterable.size();
        DocumentUtil.executeInBulk((Document)document2, (n3 + n5 > 1000 ? 1 : 0) != 0, (Runnable)new Runnable(this, toRemove2, inlayModel){
            final /* synthetic */ AnnotationHintsPass this$0;
            final /* synthetic */ List $toRemove;
            final /* synthetic */ InlayModel $inlayModel;

            public final void run() {
                Iterable $receiver$iv = this.$toRemove;
                for (T element$iv : $receiver$iv) {
                    Inlay it = (Inlay)element$iv;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
                AnnotationHintsPass.access$getHints$p(this.this$0).forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<List<HintData>>(this){
                    final /* synthetic */ doApplyInformationToEditor.2 this$0;

                    public final boolean execute(int offset, List<HintData> info) {
                        List<HintData> list = info;
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"info");
                        Iterable $receiver$iv = list;
                        for (T element$iv : $receiver$iv) {
                            Inlay inlay;
                            HintData it = (HintData)element$iv;
                            Inlay inlay2 = inlay = this.this$0.$inlayModel.addInlineElement(offset, (EditorCustomElementRenderer)new AnnotationHintRenderer(it.getPresentationText()));
                            if (inlay2 == null) continue;
                            inlay2.putUserData(com.intellij.codeInsight.hints.AnnotationHintsPass$Companion.access$getANNOTATION_INLAY_KEY$p(AnnotationHintsPass.Companion), (Object)true);
                        }
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = annotationHintsPass;
                this.$toRemove = list;
                this.$inlayModel = inlayModel;
            }
        });
        keeper.restoreOriginalLocation(false);
        if (this.rootElement == this.myFile) {
            Editor editor3 = this.myEditor;
            Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"myEditor");
            PsiFile psiFile = this.myFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"myFile");
            AnnotationHintsPassFactory.Companion.putCurrentModificationStamp(editor3, psiFile);
        }
    }

    public AnnotationHintsPass(@NotNull PsiElement rootElement, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        super(editor, rootElement.getContainingFile(), true);
        this.rootElement = rootElement;
        this.hints = new TIntObjectHashMap();
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)this.rootElement);
        Intrinsics.checkExpressionValueIsNotNull((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(rootElement)");
        this.traverser = syntaxTraverser;
    }

    static {
        Companion = new Companion(null);
        ANNOTATION_INLAY_KEY = Key.create((String)"ANNOTATION_INLAY_KEY");
    }

    @NotNull
    public static final /* synthetic */ TIntObjectHashMap access$getHints$p(AnnotationHintsPass $this) {
        return $this.hints;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$HintData;", "", "presentationText", "", "(Ljava/lang/String;)V", "getPresentationText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.java.impl"})
    public static final class HintData {
        @NotNull
        private final String presentationText;

        @NotNull
        public final String getPresentationText() {
            return this.presentationText;
        }

        public HintData(@NotNull String presentationText) {
            Intrinsics.checkParameterIsNotNull((Object)presentationText, (String)"presentationText");
            this.presentationText = presentationText;
        }

        @NotNull
        public final String component1() {
            return this.presentationText;
        }

        @NotNull
        public final HintData copy(@NotNull String presentationText) {
            Intrinsics.checkParameterIsNotNull((Object)presentationText, (String)"presentationText");
            return new HintData(presentationText);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ HintData copy$default(HintData hintData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = hintData.presentationText;
            }
            return hintData.copy(string);
        }

        public String toString() {
            return "HintData(presentationText=" + this.presentationText + ")";
        }

        public int hashCode() {
            String string = this.presentationText;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HintData)) break block3;
                    HintData hintData = (HintData)object;
                    if (!Intrinsics.areEqual((Object)this.presentationText, (Object)hintData.presentationText)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$AnnotationHintRenderer;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "text", "", "(Ljava/lang/String;)V", "getContextMenuGroupId", "intellij.java.impl"})
    private static final class AnnotationHintRenderer
    extends HintRenderer {
        @NotNull
        public String getContextMenuGroupId() {
            return "AnnotationHintsContextMenu";
        }

        public AnnotationHintRenderer(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            super(text2);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$ToggleExternalAnnotationsHintsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.impl"})
    public static final class ToggleExternalAnnotationsHintsAction
    extends ToggleAction {
        public boolean isSelected(@Nullable AnActionEvent e) {
            return CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE;
        }

        public void setSelected(@Nullable AnActionEvent e, boolean state) {
            CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE = state;
            AnnotationHintsPassFactory.Companion.forceHintsUpdateOnNextPass();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$ToggleInferredAnnotationsHintsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.impl"})
    public static final class ToggleInferredAnnotationsHintsAction
    extends ToggleAction {
        public boolean isSelected(@Nullable AnActionEvent e) {
            return CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE;
        }

        public void setSelected(@Nullable AnActionEvent e, boolean state) {
            CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE = state;
            AnnotationHintsPassFactory.Companion.forceHintsUpdateOnNextPass();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$Companion;", "", "()V", "ANNOTATION_INLAY_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "getANNOTATION_INLAY_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.java.impl"})
    public static final class Companion {
        private final Key<Boolean> getANNOTATION_INLAY_KEY() {
            return ANNOTATION_INLAY_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

