/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeannotateIntentionAction
implements IntentionAction,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(DeannotateIntentionAction.class);
    private String myAnnotationName;

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]) + (this.myAnnotationName != null ? " @" + this.myAnnotationName : "...");
        if (string == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]);
        if (string == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        ExternalAnnotationsManager externalAnnotationsManager;
        PsiAnnotation[] annotations2;
        if (project == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(2);
        }
        this.myAnnotationName = null;
        PsiModifierListOwner listOwner = DeannotateIntentionAction.getContainer(editor, file);
        if (listOwner != null && (annotations2 = (externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project)).findExternalAnnotations(listOwner)) != null && annotations2.length > 0) {
            List files;
            if (annotations2.length == 1) {
                this.myAnnotationName = annotations2[0].getQualifiedName();
            }
            if ((files = externalAnnotationsManager.findExternalAnnotationsFiles(listOwner)) == null || files.isEmpty()) {
                return false;
            }
            VirtualFile virtualFile = ((PsiFile)files.get(0)).getVirtualFile();
            return virtualFile != null && (virtualFile.isWritable() || virtualFile.isInLocalFileSystem());
        }
        return false;
    }

    @Nullable
    public static PsiModifierListOwner getContainer(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
        if (listOwner == null) {
            PsiIdentifier psiIdentifier = (PsiIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIdentifier.class, (boolean)false);
            if (psiIdentifier != null && psiIdentifier.getParent() instanceof PsiModifierListOwner) {
                listOwner = (PsiModifierListOwner)psiIdentifier.getParent();
            } else {
                PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
                if (expression2 != null) {
                    PsiMethod psiMethod;
                    while (expression2.getParent() instanceof PsiExpression && !((expression2 = (PsiExpression)expression2.getParent()) instanceof PsiAssignmentExpression)) {
                    }
                    if (expression2 instanceof PsiMethodCallExpression && (psiMethod = ((PsiMethodCallExpression)expression2).resolveMethod()) != null) {
                        return psiMethod;
                    }
                    PsiElement parent = expression2.getParent();
                    if (parent instanceof PsiExpressionList) {
                        PsiParameter[] parameters2;
                        PsiMethod method;
                        PsiElement grParent;
                        int idx = -1;
                        PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
                        for (int i = 0; i < args.length; ++i) {
                            PsiExpression arg = args[i];
                            if (!PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)expression2, (boolean)false)) continue;
                            idx = i;
                            break;
                        }
                        if (idx > -1 && (grParent = parent.getParent()) instanceof PsiCall && (method = ((PsiCall)grParent).resolveMethod()) != null && (parameters2 = method.getParameterList().getParameters()).length > idx) {
                            return parameters2[idx];
                        }
                    }
                }
            }
        }
        return listOwner;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        PsiModifierListOwner listOwner;
        if (project == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((listOwner = DeannotateIntentionAction.getContainer(editor, file)) != null);
        final ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiAnnotation[] externalAnnotations = annotationsManager.findExternalAnnotations(listOwner);
        LOG.assertTrue(externalAnnotations != null && externalAnnotations.length > 0);
        if (externalAnnotations.length == 1) {
            this.deannotate(externalAnnotations[0], project, file, annotationsManager, listOwner);
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiAnnotation>(CodeInsightBundle.message((String)"deannotate.intention.chooser.title", (Object[])new Object[0]), externalAnnotations){

            public PopupStep onChosen(PsiAnnotation selectedValue, boolean finalChoice) {
                DeannotateIntentionAction.this.deannotate(selectedValue, project, file, annotationsManager, listOwner);
                return PopupStep.FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiAnnotation value2) {
                String qualifiedName = value2.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                String string = qualifiedName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction$1", "getTextFor"));
            }
        }).showInBestPositionFor(editor);
    }

    private void deannotate(final PsiAnnotation annotation, Project project, final PsiFile file, final ExternalAnnotationsManager annotationsManager, final PsiModifierListOwner listOwner) {
        new WriteCommandAction(project, this.getText(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                VirtualFile virtualFile = file.getVirtualFile();
                String qualifiedName = annotation.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                if (annotationsManager.deannotate(listOwner, qualifiedName) && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                    UndoUtil.markPsiFileForUndo((PsiFile)file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction$2", "run"));
            }
        }.execute();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

