/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DelegationContract;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.KnownContract;
import com.intellij.codeInspection.dataFlow.MethodCallContract;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.SideEffectFilter;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContractInferenceInterpreter {
    private final LighterAST myTree;
    private final LighterASTNode myMethod;
    private final LighterASTNode myBody;

    public ContractInferenceInterpreter(LighterAST tree, LighterASTNode method, LighterASTNode body2) {
        this.myTree = tree;
        this.myMethod = method;
        this.myBody = body2;
    }

    @NotNull
    private List<LighterASTNode> getParameters() {
        LighterASTNode paramList = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)this.myMethod, (IElementType)JavaElementType.PARAMETER_LIST);
        List list = paramList != null ? LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)paramList, (IElementType)JavaElementType.PARAMETER) : Collections.emptyList();
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    List<PreContract> inferContracts(List<LighterASTNode> statements) {
        List<PreContract> result;
        if (statements.isEmpty()) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (statements.size() == 1 && (result = this.handleSingleStatement(statements.get(0))) != null) {
            List<PreContract> list = result;
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PreContract> list = this.visitStatements(Collections.singletonList(StandardMethodContract.createConstraintArray(this.getParameters().size())), statements);
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private List<PreContract> handleSingleStatement(LighterASTNode statement) {
        if (statement.getTokenType() == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode returned = JavaLightTreeUtil.findExpressionChild(this.myTree, statement);
            return this.getLiteralConstraint(returned) != null ? Collections.emptyList() : this.handleDelegation(returned, false);
        }
        if (statement.getTokenType() == JavaElementType.EXPRESSION_STATEMENT) {
            LighterASTNode expr = JavaLightTreeUtil.findExpressionChild(this.myTree, statement);
            return expr != null && expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION ? this.handleDelegation(expr, false) : null;
        }
        return null;
    }

    @Nullable
    private LighterASTNode getCodeBlock(@Nullable LighterASTNode parent) {
        return LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)parent, (IElementType)JavaElementType.CODE_BLOCK);
    }

    @NotNull
    static List<LighterASTNode> getStatements(@Nullable LighterASTNode codeBlock, LighterAST tree) {
        List list = codeBlock == null ? Collections.emptyList() : LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)codeBlock, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private List<PreContract> handleDelegation(@Nullable LighterASTNode expression2, boolean negated) {
        if (expression2 == null) {
            return null;
        }
        if (expression2.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression2), negated);
        }
        if (this.isNegationExpression(expression2)) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression2), !negated);
        }
        if (expression2.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION) {
            return Collections.singletonList(new DelegationContract(ExpressionRange.create(expression2, this.myBody.getStartOffset()), negated));
        }
        return null;
    }

    private boolean isNegationExpression(@Nullable LighterASTNode expression2) {
        return expression2 != null && expression2.getTokenType() == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expression2, (IElementType)JavaTokenType.EXCL) != null;
    }

    @NotNull
    private List<PreContract> visitExpression(List<MethodContract.ValueConstraint[]> states, @Nullable LighterASTNode expr) {
        int parameter2;
        if (expr == null) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (states.isEmpty()) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (states.size() > 300) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(7);
            }
            return list;
        }
        IElementType type2 = expr.getTokenType();
        if (type2 == JavaElementType.POLYADIC_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION) {
            List<PreContract> list = this.visitPolyadic(states, expr);
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> children = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
            if (children.size() != 3) {
                List<PreContract> list = Collections.emptyList();
                if (list == null) {
                    ContractInferenceInterpreter.$$$reportNull$$$0(9);
                }
                return list;
            }
            List<PreContract> conditionResults = this.visitExpression(states, children.get(0));
            List list = ContainerUtil.concat(this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), children.get(1)), this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), children.get(2)));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (type2 == JavaElementType.PARENTH_EXPRESSION) {
            List<PreContract> list = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (type2 == JavaElementType.TYPE_CAST_EXPRESSION) {
            List<PreContract> list = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (this.isNegationExpression(expr)) {
            List list = ContainerUtil.mapNotNull(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr)), PreContract::negate);
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (type2 == JavaElementType.INSTANCE_OF_EXPRESSION && (parameter2 = this.resolveParameter(JavaLightTreeUtil.findExpressionChild(this.myTree, expr))) >= 0) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContainerUtil.mapNotNull(states, state -> ContractInferenceInterpreter.contractWithConstraint(state, parameter2, MethodContract.ValueConstraint.NULL_VALUE, MethodContract.ValueConstraint.FALSE_VALUE)));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (type2 == JavaElementType.NEW_EXPRESSION || type2 == JavaElementType.THIS_EXPRESSION) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.NOT_NULL_VALUE));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            List<PreContract> list = Collections.singletonList(new MethodCallContract(ExpressionRange.create(expr, this.myBody.getStartOffset()), ContainerUtil.map(states, Arrays::asList)));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(16);
            }
            return list;
        }
        MethodContract.ValueConstraint constraint = this.getLiteralConstraint(expr);
        if (constraint != null) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, constraint));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(17);
            }
            return list;
        }
        int paramIndex = this.resolveParameter(expr);
        if (paramIndex >= 0) {
            ArrayList result = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state2 : states) {
                if (state2[paramIndex] != MethodContract.ValueConstraint.ANY_VALUE) {
                    result.add(new StandardMethodContract(state2, state2[paramIndex]));
                    continue;
                }
                if (JavaTokenType.BOOLEAN_KEYWORD != this.getPrimitiveParameterType(paramIndex)) continue;
                ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.TRUE_VALUE, MethodContract.ValueConstraint.TRUE_VALUE));
                ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.FALSE_VALUE, MethodContract.ValueConstraint.FALSE_VALUE));
            }
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(result);
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<PreContract> list = Collections.emptyList();
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private List<PreContract> visitPolyadic(List<MethodContract.ValueConstraint[]> states, @NotNull LighterASTNode expr) {
        boolean logicalAnd;
        if (expr == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(20);
        }
        if (LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.PLUS) != null) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContainerUtil.map(states, s -> new StandardMethodContract((MethodContract.ValueConstraint[])s, MethodContract.ValueConstraint.NOT_NULL_VALUE)));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<LighterASTNode> operands2 = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
        if (operands2.size() == 2) {
            boolean equality;
            boolean bl = equality = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.EQEQ) != null;
            if (equality || LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.NE) != null) {
                List<PreContract> list = ContractInferenceInterpreter.asPreContracts(this.visitEqualityComparison(states, operands2.get(0), operands2.get(1), equality));
                if (list == null) {
                    ContractInferenceInterpreter.$$$reportNull$$$0(22);
                }
                return list;
            }
        }
        boolean bl = logicalAnd = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.ANDAND) != null;
        if (logicalAnd || LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.OROR) != null) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(this.visitLogicalOperation(operands2, logicalAnd, states));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<PreContract> list = Collections.emptyList();
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static List<PreContract> asPreContracts(List<StandardMethodContract> contracts2) {
        List list = ContainerUtil.map(contracts2, KnownContract::new);
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    private static StandardMethodContract contractWithConstraint(MethodContract.ValueConstraint[] state, int parameter2, MethodContract.ValueConstraint paramConstraint, MethodContract.ValueConstraint returnValue) {
        MethodContract.ValueConstraint[] newState = ContractInferenceInterpreter.withConstraint(state, parameter2, paramConstraint);
        return newState == null ? null : new StandardMethodContract(newState, returnValue);
    }

    private List<StandardMethodContract> visitEqualityComparison(List<MethodContract.ValueConstraint[]> states, LighterASTNode op1, LighterASTNode op2, boolean equality) {
        int parameter2 = this.resolveParameter(op1);
        MethodContract.ValueConstraint constraint = this.getLiteralConstraint(op2);
        if (parameter2 < 0 || constraint == null) {
            parameter2 = this.resolveParameter(op2);
            constraint = this.getLiteralConstraint(op1);
        }
        if (parameter2 >= 0 && constraint != null) {
            ArrayList result = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state : states) {
                if (constraint == MethodContract.ValueConstraint.NOT_NULL_VALUE) {
                    if (this.getPrimitiveParameterType(parameter2) != null) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter2, MethodContract.ValueConstraint.NULL_VALUE, equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
                    continue;
                }
                ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter2, constraint, equality ? MethodContract.ValueConstraint.TRUE_VALUE : MethodContract.ValueConstraint.FALSE_VALUE));
                ContainerUtil.addIfNotNull((Collection)result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter2, constraint.negate(), equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    private IElementType getPrimitiveParameterType(int paramIndex) {
        LighterASTNode typeElement = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)this.getParameters().get(paramIndex), (IElementType)JavaElementType.TYPE);
        LighterASTNode primitive = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)typeElement, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET);
        return primitive == null ? null : primitive.getTokenType();
    }

    static List<StandardMethodContract> toContracts(List<MethodContract.ValueConstraint[]> states, MethodContract.ValueConstraint constraint) {
        return ContainerUtil.map(states, state -> new StandardMethodContract((MethodContract.ValueConstraint[])state, constraint));
    }

    private List<StandardMethodContract> visitLogicalOperation(List<LighterASTNode> operands2, boolean conjunction, List<MethodContract.ValueConstraint[]> states) {
        MethodContract.ValueConstraint breakValue = conjunction ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE;
        ArrayList finalStates = ContainerUtil.newArrayList();
        for (LighterASTNode operand2 : operands2) {
            List<PreContract> opResults = this.visitExpression(states, operand2);
            finalStates.addAll(ContainerUtil.filter(ContractInferenceInterpreter.knownContracts(opResults), contract -> contract.returnValue == breakValue));
            states = ContractInferenceInterpreter.antecedentsReturning(opResults, breakValue.negate());
        }
        finalStates.addAll(ContractInferenceInterpreter.toContracts(states, breakValue.negate()));
        return finalStates;
    }

    private static List<StandardMethodContract> knownContracts(List<PreContract> values) {
        return ContainerUtil.mapNotNull(values, pc -> pc instanceof KnownContract ? ((KnownContract)pc).getContract() : null);
    }

    private static List<MethodContract.ValueConstraint[]> antecedentsReturning(List<PreContract> values, MethodContract.ValueConstraint result) {
        return ContainerUtil.mapNotNull(ContractInferenceInterpreter.knownContracts(values), contract -> contract.returnValue == result ? contract.arguments : null);
    }

    @NotNull
    private List<PreContract> visitStatements(List<MethodContract.ValueConstraint[]> states, List<LighterASTNode> statements) {
        CodeBlockContracts result = new CodeBlockContracts();
        for (LighterASTNode statement : statements) {
            List<PreContract> conditionResults;
            IElementType type2 = statement.getTokenType();
            if (type2 == JavaElementType.BLOCK_STATEMENT) {
                result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(this.getCodeBlock(statement), this.myTree)));
                break;
            }
            if (type2 == JavaElementType.IF_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement));
                List<LighterASTNode> thenElse = ContractInferenceInterpreter.getStatements(statement, this.myTree);
                if (thenElse.size() > 0) {
                    result.addAll(this.visitStatements(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), Collections.singletonList(thenElse.get(0))));
                }
                List<MethodContract.ValueConstraint[]> falseStates = ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE);
                if (thenElse.size() > 1) {
                    result.addAll(this.visitStatements(falseStates, Collections.singletonList(thenElse.get(1))));
                    break;
                }
                states = falseStates;
                continue;
            }
            if (type2 == JavaElementType.WHILE_STATEMENT) {
                states = ContractInferenceInterpreter.antecedentsReturning(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement)), MethodContract.ValueConstraint.FALSE_VALUE);
                continue;
            }
            if (type2 == JavaElementType.THROW_STATEMENT) {
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.THROW_EXCEPTION)));
                break;
            }
            if (type2 == JavaElementType.RETURN_STATEMENT) {
                result.addAll(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement)));
                break;
            }
            if (type2 == JavaElementType.ASSERT_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement));
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.ValueConstraint.THROW_EXCEPTION)));
                break;
            }
            if (type2 == JavaElementType.DECLARATION_STATEMENT) {
                result.registerDeclaration(statement, this.myTree, this.myBody.getStartOffset());
                continue;
            }
            if (type2 != JavaElementType.DO_WHILE_STATEMENT) break;
            result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(statement, this.myTree)));
            break;
        }
        List<PreContract> list = result.accumulated;
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    private MethodContract.ValueConstraint getLiteralConstraint(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.LITERAL_EXPRESSION) {
            return ContractInferenceInterpreter.getLiteralConstraint(((LighterASTNode)this.myTree.getChildren(expr).get(0)).getTokenType());
        }
        return null;
    }

    @NotNull
    static MethodContract.ValueConstraint getLiteralConstraint(@NotNull IElementType literalTokenType) {
        if (literalTokenType == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(27);
        }
        if (literalTokenType.equals(JavaTokenType.TRUE_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.TRUE_VALUE;
            if (valueConstraint == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(28);
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.FALSE_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.FALSE_VALUE;
            if (valueConstraint == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(29);
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.NULL_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.NULL_VALUE;
            if (valueConstraint == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(30);
            }
            return valueConstraint;
        }
        MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.NOT_NULL_VALUE;
        if (valueConstraint == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(31);
        }
        return valueConstraint;
    }

    private int resolveParameter(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION && JavaLightTreeUtil.findExpressionChild(this.myTree, expr) == null) {
            String name = JavaLightTreeUtil.getNameIdentifierText(this.myTree, expr);
            if (name == null) {
                return -1;
            }
            List<LighterASTNode> parameters2 = this.getParameters();
            for (int i = 0; i < parameters2.size(); ++i) {
                if (!name.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, parameters2.get(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    static MethodContract.ValueConstraint[] withConstraint(MethodContract.ValueConstraint[] constraints, int index, MethodContract.ValueConstraint constraint) {
        if (constraints[index] == constraint) {
            return constraints;
        }
        MethodContract.ValueConstraint negated = constraint.negate();
        if (negated != constraint && constraints[index] == negated) {
            return null;
        }
        MethodContract.ValueConstraint[] copy = (MethodContract.ValueConstraint[])constraints.clone();
        copy[index] = constraint;
        return copy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 20: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 20: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalTokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inferContracts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "visitExpression";
                break;
            }
            case 20: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPolyadic";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "asPreContracts";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "visitStatements";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralConstraint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitPolyadic";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralConstraint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 20: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CodeBlockContracts {
        List<PreContract> accumulated = new ArrayList<PreContract>();
        List<ExpressionRange> varInitializers = new ArrayList<ExpressionRange>();

        private CodeBlockContracts() {
        }

        void addAll(List<PreContract> contracts2) {
            if (contracts2.isEmpty()) {
                return;
            }
            if (this.varInitializers.isEmpty()) {
                this.accumulated.addAll(contracts2);
            } else {
                this.accumulated.add(new SideEffectFilter(this.varInitializers, contracts2));
            }
        }

        void registerDeclaration(@NotNull LighterASTNode declStatement, @NotNull LighterAST tree, int scopeStart) {
            if (declStatement == null) {
                CodeBlockContracts.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                CodeBlockContracts.$$$reportNull$$$0(1);
            }
            for (LighterASTNode var : LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)declStatement, (IElementType)JavaElementType.LOCAL_VARIABLE)) {
                LighterASTNode initializer = JavaLightTreeUtil.findExpressionChild(tree, var);
                if (initializer == null) continue;
                this.varInitializers.add(ExpressionRange.create(initializer, scopeStart));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter$CodeBlockContracts";
            objectArray[2] = "registerDeclaration";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

