/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationSignature {
    public static final String ATTR_MUTATES = "mutates";
    private static final String CONTRACT_ANNOTATION = "org.jetbrains.annotations.Contract";
    private static final MutationSignature UNKNOWN = new MutationSignature(false, new boolean[0]);
    private static final MutationSignature PURE = new MutationSignature(false, new boolean[0]);
    public static final String INVALID_TOKEN_MESSAGE = "Invalid token: %s; supported are 'this', 'arg1', 'arg2', etc.";
    private final boolean myThis;
    private final boolean[] myArgs;

    private MutationSignature(boolean mutatesThis, boolean[] args) {
        this.myThis = mutatesThis;
        this.myArgs = args;
    }

    public boolean mutatesThis() {
        return this.myThis;
    }

    public boolean mutatesArg(int n) {
        return n < this.myArgs.length && this.myArgs[n];
    }

    public boolean preservesThis() {
        return this != UNKNOWN && !this.myThis;
    }

    public boolean preservesArg(int n) {
        return this != UNKNOWN && !this.mutatesArg(n);
    }

    public static MutationSignature parse(@NotNull String signature) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(0);
        }
        if (signature.trim().isEmpty()) {
            return UNKNOWN;
        }
        boolean mutatesThis = false;
        boolean[] args = new boolean[]{};
        for (String part : signature.split(",")) {
            if ((part = part.trim()).equals("this")) {
                mutatesThis = true;
                continue;
            }
            if (part.equals("arg")) {
                if (args.length == 0) {
                    args = new boolean[]{true};
                    continue;
                }
                args[0] = true;
                continue;
            }
            if (part.startsWith("arg")) {
                int argNum = Integer.parseInt(part.substring("arg".length()));
                if (argNum < 0 || argNum > 255) {
                    throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
                }
                if (args.length < argNum) {
                    args = Arrays.copyOf(args, argNum);
                }
                args[argNum - 1] = true;
                continue;
            }
            if (part.isEmpty()) continue;
            throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
        }
        return new MutationSignature(mutatesThis, args);
    }

    @Nullable
    public static String checkSignature(@NotNull String signature, @NotNull PsiMethod method) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(1);
        }
        if (method == null) {
            MutationSignature.$$$reportNull$$$0(2);
        }
        try {
            MutationSignature ms = MutationSignature.parse(signature);
            if (ms.myThis && method.hasModifierProperty("static")) {
                return "Static method cannot mutate 'this'";
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (ms.myArgs.length > parameters2.length) {
                return "Reference to parameter #" + ms.myArgs.length + " is invalid";
            }
            for (int i = 0; i < ms.myArgs.length; ++i) {
                PsiType type2;
                if (!ms.myArgs[i] || !ClassUtils.isImmutable(type2 = parameters2[i].getType())) continue;
                return "Parameter #" + (i + 1) + " has immutable type '" + type2.getPresentableText() + "'";
            }
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @NotNull
    public static MutationSignature fromMethod(@Nullable PsiMethod method) {
        Object text2;
        if (method == null) {
            MutationSignature mutationSignature = UNKNOWN;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(3);
            }
            return mutationSignature;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{CONTRACT_ANNOTATION});
        if (annotation == null) {
            MutationSignature mutationSignature = UNKNOWN;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(4);
            }
            return mutationSignature;
        }
        PsiAnnotationMemberValue value2 = annotation.findAttributeValue(ATTR_MUTATES);
        if (value2 instanceof PsiLiteralExpression && (text2 = ((PsiLiteralExpression)value2).getValue()) instanceof String) {
            MutationSignature mutationSignature;
            try {
                mutationSignature = MutationSignature.parse((String)text2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(5);
            }
            return mutationSignature;
        }
        if (ControlFlowAnalyzer.isPure(method)) {
            MutationSignature mutationSignature = PURE;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(6);
            }
            return mutationSignature;
        }
        MutationSignature mutationSignature = UNKNOWN;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(7);
        }
        return mutationSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

