/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaConstValue
extends DfaValue {
    private static final Throwable ourThrowable = new Throwable();
    private final Object myValue;
    @Nullable
    private final PsiVariable myConstant;

    private DfaConstValue(Object value2, DfaValueFactory factory, @Nullable PsiVariable constant) {
        super(factory);
        this.myValue = value2;
        this.myConstant = constant;
    }

    public String toString() {
        if (this.myValue == null) {
            return "null";
        }
        return this.myValue.toString();
    }

    public Object getValue() {
        return this.myValue;
    }

    @Nullable
    public PsiVariable getConstant() {
        return this.myConstant;
    }

    @Override
    public DfaValue createNegated() {
        if (this == this.myFactory.getConstFactory().getTrue()) {
            return this.myFactory.getConstFactory().getFalse();
        }
        if (this == this.myFactory.getConstFactory().getFalse()) {
            return this.myFactory.getConstFactory().getTrue();
        }
        return DfaUnknownValue.getInstance();
    }

    public static class Factory {
        private final DfaConstValue dfaNull;
        private final DfaConstValue dfaFalse;
        private final DfaConstValue dfaTrue;
        private final DfaConstValue dfaFail;
        private final DfaValueFactory myFactory;
        private final Map<Object, DfaConstValue> myValues = ContainerUtil.newHashMap();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.dfaNull = new DfaConstValue(null, factory, null);
            this.dfaFalse = new DfaConstValue(Boolean.FALSE, factory, null);
            this.dfaTrue = new DfaConstValue(Boolean.TRUE, factory, null);
            this.dfaFail = new DfaConstValue(ourThrowable, factory, null);
        }

        @Nullable
        public DfaValue create(PsiLiteralExpression expr) {
            PsiType type2 = expr.getType();
            if (PsiType.NULL.equals((Object)type2)) {
                return this.dfaNull;
            }
            Object value2 = expr.getValue();
            if (value2 == null) {
                return null;
            }
            return this.createFromValue(value2, type2, null);
        }

        @Nullable
        public DfaValue create(PsiVariable variable) {
            if (DfaUtil.ignoreInitializer(variable)) {
                return null;
            }
            Object value2 = variable.computeConstantValue();
            PsiType type2 = variable.getType();
            if (value2 == null) {
                Boolean boo = Factory.computeJavaLangBooleanFieldReference(variable);
                if (boo != null) {
                    DfaConstValue unboxed = this.createFromValue(boo, (PsiType)PsiType.BOOLEAN, variable);
                    return this.myFactory.getBoxedFactory().createBoxed(unboxed);
                }
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
                if (initializer instanceof PsiLiteralExpression && initializer.textMatches((CharSequence)"null")) {
                    return this.dfaNull;
                }
                if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNewObject(initializer)) {
                    return this.createFromValue(variable, type2, variable);
                }
                return null;
            }
            return this.createFromValue(value2, type2, variable);
        }

        @Nullable
        private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiClass psiClass = ((PsiField)variable).getContainingClass();
            if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
                return null;
            }
            String name = variable.getName();
            return "TRUE".equals(name) ? Boolean.TRUE : ("FALSE".equals(name) ? Boolean.FALSE : null);
        }

        @NotNull
        public DfaConstValue createFromValue(Object value2, PsiType type2, @Nullable PsiVariable constant) {
            DfaConstValue instance;
            if (value2 == Boolean.TRUE) {
                DfaConstValue dfaConstValue = this.dfaTrue;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(0);
                }
                return dfaConstValue;
            }
            if (value2 == Boolean.FALSE) {
                DfaConstValue dfaConstValue = this.dfaFalse;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(1);
                }
                return dfaConstValue;
            }
            if (value2 == null) {
                DfaConstValue dfaConstValue = this.dfaNull;
                if (dfaConstValue == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return dfaConstValue;
            }
            if (TypeConversionUtil.isNumericType((PsiType)type2) && !TypeConversionUtil.isFloatOrDoubleType((PsiType)type2)) {
                value2 = TypeConversionUtil.computeCastTo((Object)value2, (PsiType)PsiType.LONG);
            }
            if (value2 instanceof Double || value2 instanceof Float) {
                double doubleValue = ((Number)value2).doubleValue();
                if (doubleValue == -0.0) {
                    doubleValue = 0.0;
                }
                value2 = new Double(doubleValue);
            }
            if ((instance = this.myValues.get(value2)) == null) {
                instance = new DfaConstValue(value2, this.myFactory, constant);
                this.myValues.put(value2, instance);
            }
            DfaConstValue dfaConstValue = instance;
            if (dfaConstValue == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return dfaConstValue;
        }

        public DfaConstValue getContractFail() {
            return this.dfaFail;
        }

        public DfaConstValue getFalse() {
            return this.dfaFalse;
        }

        public DfaConstValue getTrue() {
            return this.dfaTrue;
        }

        public DfaConstValue getNull() {
            return this.dfaNull;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory", "createFromValue"));
        }
    }
}

