/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.emptyMethod;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyMethodInspection
extends GlobalJavaBatchInspectionTool {
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.empty.method.display.name", (Object[])new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "EmptyMethod";
    public final JDOMExternalizableStringList EXCLUDE_ANNOS = new JDOMExternalizableStringList();
    public boolean commentsAreContent = false;
    @NonNls
    private static final String QUICK_FIX_NAME = InspectionsBundle.message((String)"inspection.empty.method.delete.quickfix", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.emptyMethod.EmptyMethodInspection");

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            EmptyMethodInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            EmptyMethodInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            EmptyMethodInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            EmptyMethodInspection.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            EmptyMethodInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (!this.isBodyEmpty(refMethod)) {
            return null;
        }
        if (refMethod.isConstructor()) {
            return null;
        }
        if (refMethod.isSyntheticJSP()) {
            return null;
        }
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (this.checkElement((RefEntity)refSuper, scope, manager, globalContext, processor) == null) continue;
            return null;
        }
        String message2 = null;
        boolean needToDeleteHierarchy = false;
        RefMethod refSuper = EmptyMethodInspection.findSuperWithBody(refMethod);
        if (refMethod.isOnlyCallsSuper() && !refMethod.isFinal()) {
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (refSuper != null && Comparing.strEqual((String)refMethod.getAccessModifier(), (String)refSuper.getAccessModifier())) {
                PsiModifierListOwner supMethod;
                PsiModifierList list;
                if (Comparing.strEqual((String)refSuper.getAccessModifier(), (String)"protected") && !Comparing.strEqual((String)refUtil.getPackageName((RefEntity)refSuper), (String)refUtil.getPackageName((RefEntity)refMethod))) {
                    return null;
                }
                PsiModifierListOwner modifierListOwner = refMethod.getElement();
                if (modifierListOwner != null && (list = modifierListOwner.getModifierList()) != null && (supMethod = refSuper.getElement()) != null) {
                    PsiModifierList superModifiedList = supMethod.getModifierList();
                    LOG.assertTrue(superModifiedList != null);
                    if (list.hasModifierProperty("synchronized") && !superModifiedList.hasModifierProperty("synchronized")) {
                        return null;
                    }
                }
            }
            if (refSuper == null || refUtil.compareAccess(refMethod.getAccessModifier(), refSuper.getAccessModifier()) <= 0) {
                message2 = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor", (Object[])new Object[0]);
            }
        } else if (refMethod.hasBody() && this.hasEmptySuperImplementation(refMethod)) {
            message2 = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor1", (Object[])new Object[0]);
        } else if (this.areAllImplementationsEmpty(refMethod) && refSuper == null) {
            if (refMethod.hasBody()) {
                if (refMethod.getDerivedMethods().isEmpty()) {
                    if (refMethod.getSuperMethods().isEmpty()) {
                        message2 = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor2", (Object[])new Object[0]);
                    }
                } else {
                    needToDeleteHierarchy = true;
                    message2 = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor3", (Object[])new Object[0]);
                }
            } else if (!refMethod.getDerivedMethods().isEmpty()) {
                needToDeleteHierarchy = true;
                message2 = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor4", (Object[])new Object[0]);
            }
        }
        if (message2 != null) {
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            fixes.add(this.getFix(processor, needToDeleteHierarchy));
            if (globalContext instanceof GlobalInspectionContextBase && ((GlobalInspectionContextBase)globalContext).getCurrentProfile().getSingleTool() == null) {
                SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes(refMethod.getElement(), (Processor<String>)((Processor)qualifiedName -> {
                    fixes.add(SpecialAnnotationsUtilBase.createAddToSpecialAnnotationsListQuickFix(QuickFixBundle.message("fix.add.special.annotation.text", qualifiedName), QuickFixBundle.message("fix.add.special.annotation.family", new Object[0]), (List<String>)this.EXCLUDE_ANNOS, qualifiedName, (PsiElement)refMethod.getElement()));
                    return true;
                }));
            }
            ProblemDescriptor descriptor = manager.createProblemDescriptor(refMethod.getElement().getNavigationElement(), message2, false, fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private boolean isBodyEmpty(RefMethod refMethod) {
        if (!refMethod.isBodyEmpty()) {
            return false;
        }
        PsiModifierListOwner owner = refMethod.getElement();
        if (owner == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (Collection)this.EXCLUDE_ANNOS, (int)0)) {
            return false;
        }
        for (Object extension : Extensions.getExtensions((String)"com.intellij.canBeEmpty")) {
            if (!((Condition)extension).value((Object)refMethod)) continue;
            return false;
        }
        return !this.commentsAreContent || PsiTreeUtil.findChildOfType((PsiElement)owner, PsiComment.class) == null;
    }

    @Nullable
    private static RefMethod findSuperWithBody(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody()) continue;
            return refSuper;
        }
        return null;
    }

    private boolean areAllImplementationsEmpty(RefMethod refMethod) {
        if (refMethod.hasBody() && !this.isBodyEmpty(refMethod)) {
            return false;
        }
        for (RefMethod refDerived : refMethod.getDerivedMethods()) {
            if (this.areAllImplementationsEmpty(refDerived)) continue;
            return false;
        }
        return true;
    }

    private boolean hasEmptySuperImplementation(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody() || !this.isBodyEmpty(refSuper)) continue;
            return true;
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext context, final @NotNull ProblemDescriptionsProcessor descriptionsProcessor) {
        if (manager == null) {
            EmptyMethodInspection.$$$reportNull$$$0(5);
        }
        if (context == null) {
            EmptyMethodInspection.$$$reportNull$$$0(6);
        }
        if (descriptionsProcessor == null) {
            EmptyMethodInspection.$$$reportNull$$$0(7);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof RefElement && descriptionsProcessor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            context.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    PsiCodeBlock body2 = derivedMethod.getBody();
                                    if (body2 == null || body2.isEmpty()) {
                                        return true;
                                    }
                                    if (RefJavaUtil.getInstance().isMethodOnlyCallsSuper(derivedMethod)) {
                                        return true;
                                    }
                                    descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$1$1", "visitMethod"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$1", "visitElement"));
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            EmptyMethodInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            EmptyMethodInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            EmptyMethodInspection.$$$reportNull$$$0(10);
        }
        return SHORT_NAME;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            EmptyMethodInspection.$$$reportNull$$$0(11);
        }
        if (!this.EXCLUDE_ANNOS.isEmpty() || this.commentsAreContent) {
            super.writeSettings(node);
        }
    }

    private LocalQuickFix getFix(ProblemDescriptionsProcessor processor, boolean needToDeleteHierarchy) {
        return new DeleteMethodQuickFix(processor, needToDeleteHierarchy);
    }

    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            EmptyMethodInspection.$$$reportNull$$$0(12);
        }
        if (fix instanceof DeleteMethodQuickFix) {
            return String.valueOf(((DeleteMethodQuickFix)fix).myNeedToDeleteHierarchy);
        }
        return null;
    }

    @Nullable
    public LocalQuickFix getQuickFix(String hint) {
        return new DeleteMethodIntention(hint);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel listPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)this.EXCLUDE_ANNOS, InspectionsBundle.message((String)"special.annotations.annotations.list", (Object[])new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)new SingleCheckboxOptionsPanel("Comments and javadoc count as content", (InspectionProfileEntry)this, "commentsAreContent"), "North");
        panel.add((Component)listPanel, "Center");
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionsProcessor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DeleteMethodQuickFix
    implements LocalQuickFix,
    BatchQuickFix<CommonProblemDescriptor> {
        private final ProblemDescriptionsProcessor myProcessor;
        private final boolean myNeedToDeleteHierarchy;

        public DeleteMethodQuickFix(ProblemDescriptionsProcessor processor, boolean needToDeleteHierarchy) {
            this.myProcessor = processor;
            this.myNeedToDeleteHierarchy = needToDeleteHierarchy;
        }

        @NotNull
        public String getFamilyName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(2);
            }
            this.applyFix(project, (CommonProblemDescriptor[])new ProblemDescriptor[]{descriptor}, new ArrayList<PsiElement>(), null);
        }

        private void deleteHierarchy(RefMethod refMethod, List<PsiElement> result) {
            RefMethod[] refMethods;
            Collection derivedMethods = refMethod.getDerivedMethods();
            for (RefMethod refDerived : refMethods = derivedMethods.toArray(new RefMethod[0])) {
                this.deleteMethod(refDerived, result);
            }
            this.deleteMethod(refMethod, result);
        }

        private void deleteMethod(RefMethod refMethod, List<PsiElement> result) {
            PsiModifierListOwner psiElement = refMethod.getElement();
            if (psiElement == null) {
                return;
            }
            if (!result.contains(psiElement)) {
                result.add((PsiElement)psiElement);
            }
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptors == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(4);
            }
            if (psiElementsToIgnore == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(5);
            }
            for (CommonProblemDescriptor descriptor : descriptors) {
                RefElement refElement = (RefElement)this.myProcessor.getElement(descriptor);
                if (!(refElement instanceof RefMethod) || !refElement.isValid()) continue;
                RefMethod refMethod = (RefMethod)refElement;
                if (this.myNeedToDeleteHierarchy) {
                    this.deleteHierarchy(refMethod, psiElementsToIgnore);
                    continue;
                }
                this.deleteMethod(refMethod, psiElementsToIgnore);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    DeleteMethodQuickFix.$$$reportNull$$$0(6);
                }
                if (psiElementsToIgnore == null) {
                    DeleteMethodQuickFix.$$$reportNull$$$0(7);
                }
                SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray((Collection)psiElementsToIgnore), (boolean)false, (Runnable)refreshViews);
            }, project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElementsToIgnore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DeleteMethodIntention
    implements LocalQuickFix {
        private final String myHint;

        public DeleteMethodIntention(String hint) {
            this.myHint = hint;
        }

        @NotNull
        public String getFamilyName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                DeleteMethodIntention.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod psiMethod;
            if (project == null) {
                DeleteMethodIntention.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DeleteMethodIntention.$$$reportNull$$$0(2);
            }
            if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class, (boolean)false)) != null) {
                ArrayList<PsiMethod> psiElements = new ArrayList<PsiMethod>();
                psiElements.add(psiMethod);
                if (Boolean.valueOf(this.myHint).booleanValue()) {
                    Query query = AllOverridingMethodsSearch.search((PsiClass)psiMethod.getContainingClass());
                    query.forEach(pair -> {
                        if (pair.first == psiMethod) {
                            psiElements.add((PsiMethod)pair.second);
                        }
                        return true;
                    });
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        DeleteMethodIntention.$$$reportNull$$$0(3);
                    }
                    SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray((Collection)psiElements), (boolean)false);
                }, project.getDisposed());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

