/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindPackageUsagesDialog;
import com.intellij.find.findUsages.FindThrowUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindVariableUsagesDialog;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.JavaNonCodeSearchElementDescriptionProvider;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHandler
extends FindUsagesHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findUsages.JavaFindUsagesHandler");
    protected static final String ACTION_STRING = FindBundle.message((String)"find.super.method.warning.action.verb", (Object[])new Object[0]);
    private final PsiElement[] myElementsToSearch;
    private final JavaFindUsagesHandlerFactory myFactory;

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(1);
        }
        this(psiElement, PsiElement.EMPTY_ARRAY, factory);
    }

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull PsiElement[] elementsToSearch, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(2);
        }
        if (elementsToSearch == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(4);
        }
        super(psiElement);
        this.myElementsToSearch = elementsToSearch;
        this.myFactory = factory;
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            FindPackageUsagesDialog findPackageUsagesDialog = new FindPackageUsagesDialog(element, this.getProject(), this.myFactory.getFindPackageOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findPackageUsagesDialog == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(5);
            }
            return findPackageUsagesDialog;
        }
        if (element instanceof PsiClass) {
            FindClassUsagesDialog findClassUsagesDialog = new FindClassUsagesDialog(element, this.getProject(), this.myFactory.getFindClassOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findClassUsagesDialog == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(6);
            }
            return findClassUsagesDialog;
        }
        if (element instanceof PsiMethod) {
            FindMethodUsagesDialog findMethodUsagesDialog = new FindMethodUsagesDialog(element, this.getProject(), this.myFactory.getFindMethodOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findMethodUsagesDialog == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(7);
            }
            return findMethodUsagesDialog;
        }
        if (element instanceof PsiVariable) {
            FindVariableUsagesDialog findVariableUsagesDialog = new FindVariableUsagesDialog(element, this.getProject(), this.myFactory.getFindVariableOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findVariableUsagesDialog == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(8);
            }
            return findVariableUsagesDialog;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            FindThrowUsagesDialog findThrowUsagesDialog = new FindThrowUsagesDialog(element, this.getProject(), this.myFactory.getFindThrowOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, (FindUsagesHandler)this);
            if (findThrowUsagesDialog == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(9);
            }
            return findThrowUsagesDialog;
        }
        AbstractFindUsagesDialog abstractFindUsagesDialog = super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
        if (abstractFindUsagesDialog == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(10);
        }
        return abstractFindUsagesDialog;
    }

    private static boolean askWhetherShouldSearchForParameterInOverridingMethods(@NotNull PsiElement psiElement, @NotNull PsiParameter parameter2) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(11);
        }
        if (parameter2 == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(12);
        }
        JavaFindUsagesHandler.assertInTransaction();
        return Messages.showOkCancelDialog((Project)psiElement.getProject(), (String)FindBundle.message((String)"find.parameter.usages.in.overriding.methods.prompt", (Object[])new Object[]{parameter2.getName()}), (String)FindBundle.message((String)"find.parameter.usages.in.overriding.methods.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static PsiElement[] getParameterElementsToSearch(@NotNull PsiParameter parameter2, @NotNull PsiMethod method) {
        if (parameter2 == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(13);
        }
        if (method == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(14);
        }
        PsiMethod[] overrides = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        for (int i = 0; i < overrides.length; ++i) {
            PsiElement navigationElement = overrides[i].getNavigationElement();
            if (!(navigationElement instanceof PsiMethod)) continue;
            overrides[i] = (PsiMethod)navigationElement;
        }
        ArrayList<PsiParameter> elementsToSearch = new ArrayList<PsiParameter>(overrides.length + 1);
        elementsToSearch.add(parameter2);
        int idx = method.getParameterList().getParameterIndex(parameter2);
        for (PsiMethod override : overrides) {
            PsiParameter[] parameters2 = override.getParameterList().getParameters();
            if (idx >= parameters2.length) continue;
            elementsToSearch.add(parameters2[idx]);
        }
        PsiClass aClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
        if (aClass != null) {
            FunctionalExpressionSearch.search((PsiClass)aClass).forEach(element -> {
                PsiParameter[] parameters2;
                if (element instanceof PsiLambdaExpression && idx < (parameters2 = ((PsiLambdaExpression)element).getParameterList().getParameters()).length) {
                    elementsToSearch.add(parameters2[idx]);
                }
            });
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elementsToSearch);
        if (psiElementArray == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(15);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray;
        PsiMethod method;
        PsiParameter parameter2;
        PsiElement scope;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiParameter && (scope = (parameter2 = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PsiUtil.canBeOverridden((PsiMethod)(method = (PsiMethod)scope))) {
            boolean hasOverridden;
            PsiClass aClass = method.getContainingClass();
            LOG.assertTrue(aClass != null);
            boolean bl = hasOverridden = OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
            if (!hasOverridden) {
                boolean bl2 = hasOverridden = FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null;
            }
            if (hasOverridden && JavaFindUsagesHandler.askWhetherShouldSearchForParameterInOverridingMethods(element, parameter2)) {
                PsiElement[] psiElementArray2 = JavaFindUsagesHandler.getParameterElementsToSearch(parameter2, method);
                if (psiElementArray2 == null) {
                    JavaFindUsagesHandler.$$$reportNull$$$0(16);
                }
                return psiElementArray2;
            }
        }
        if (this.myElementsToSearch.length == 0) {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = element;
        } else {
            psiElementArray = this.myElementsToSearch;
        }
        if (psiElementArray == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        PsiField field;
        PsiClass containingClass;
        PsiElement element = this.getPsiElement();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(18);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null) {
            PsiMethod setter;
            String fieldName = field.getName();
            String propertyName = JavaCodeStyleManager.getInstance((Project)this.getProject()).variableNameToPropertyName(fieldName, VariableKind.FIELD);
            THashSet accessors = new THashSet();
            boolean isStatic = field.hasModifierProperty("static");
            PsiMethod getter = PropertyUtilBase.findPropertyGetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()));
            if (getter != null) {
                accessors.add(getter);
            }
            if ((setter = PropertyUtilBase.findPropertySetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()))) != null) {
                accessors.add(setter);
            }
            accessors.addAll(PropertyUtilBase.getAccessors((PsiClass)containingClass, (String)fieldName));
            if (!accessors.isEmpty()) {
                boolean doSearch;
                boolean containsPhysical = ContainerUtil.find((Iterable)accessors, psiMethod -> psiMethod.isPhysical()) != null;
                boolean bl = doSearch = !containsPhysical || JavaFindUsagesHandler.askShouldSearchAccessors(fieldName);
                if (doSearch) {
                    THashSet elements = new THashSet();
                    for (PsiMethod accessor : accessors) {
                        ContainerUtil.addAll((Collection)elements, (Object[])SuperMethodWarningUtil.checkSuperMethods(accessor, ACTION_STRING));
                    }
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)elements);
                    if (psiElementArray == null) {
                        JavaFindUsagesHandler.$$$reportNull$$$0(19);
                    }
                    return psiElementArray;
                }
            }
        }
        PsiElement[] psiElementArray = super.getSecondaryElements();
        if (psiElementArray == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(20);
        }
        return psiElementArray;
    }

    private static boolean askShouldSearchAccessors(String fieldName) {
        JavaFindUsagesHandler.assertInTransaction();
        return Messages.showOkCancelDialog((String)FindBundle.message((String)"find.field.accessors.prompt", (Object[])new Object[]{fieldName}), (String)FindBundle.message((String)"find.field.accessors.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static void assertInTransaction() {
        LOG.assertTrue(TransactionGuard.getInstance().getContextTransaction() != null, (Object)"Find Usages should be shown in a transaction, see AnAction#startInTransaction");
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            JavaPackageFindUsagesOptions javaPackageFindUsagesOptions = this.myFactory.getFindPackageOptions();
            if (javaPackageFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(21);
            }
            return javaPackageFindUsagesOptions;
        }
        if (element instanceof PsiClass) {
            JavaClassFindUsagesOptions javaClassFindUsagesOptions = this.myFactory.getFindClassOptions();
            if (javaClassFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(22);
            }
            return javaClassFindUsagesOptions;
        }
        if (element instanceof PsiMethod) {
            JavaMethodFindUsagesOptions javaMethodFindUsagesOptions = this.myFactory.getFindMethodOptions();
            if (javaMethodFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(23);
            }
            return javaMethodFindUsagesOptions;
        }
        if (element instanceof PsiVariable) {
            JavaVariableFindUsagesOptions javaVariableFindUsagesOptions = this.myFactory.getFindVariableOptions();
            if (javaVariableFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(24);
            }
            return javaVariableFindUsagesOptions;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            JavaThrowFindUsagesOptions javaThrowFindUsagesOptions = this.myFactory.getFindThrowOptions();
            if (javaThrowFindUsagesOptions == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(25);
            }
            return javaThrowFindUsagesOptions;
        }
        FindUsagesOptions findUsagesOptions = super.getFindUsagesOptions(dataContext);
        if (findUsagesOptions == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(26);
        }
        return findUsagesOptions;
    }

    protected Set<String> getStringsToSearch(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(27);
        }
        return JavaFindUsagesHelper.getElementNames(element);
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(29);
        }
        if (options == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(30);
        }
        return JavaFindUsagesHelper.processElementUsages(element, options, processor);
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(31);
        }
        return !isSingleFile && new JavaNonCodeSearchElementDescriptionProvider().getElementDescription(psiElement, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA) != null;
    }

    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        if (target == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(32);
        }
        if (searchScope == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(33);
        }
        if (target instanceof PsiMethod) {
            PsiMethod[] superMethods = ((PsiMethod)target).findDeepestSuperMethods();
            if (superMethods.length == 0) {
                Collection collection = MethodReferencesSearch.search((PsiMethod)((PsiMethod)target), (SearchScope)searchScope, (boolean)true).findAll();
                if (collection == null) {
                    JavaFindUsagesHandler.$$$reportNull$$$0(34);
                }
                return collection;
            }
            ArrayList<PsiReference> result = new ArrayList<PsiReference>();
            GlobalSearchScope resolveScope = null;
            if (searchScope instanceof LocalSearchScope) {
                Object[] scopeElements = ((LocalSearchScope)searchScope).getScope();
                resolveScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])ContainerUtil.map2Array((Object[])scopeElements, GlobalSearchScope.class, PsiElement::getResolveScope)));
            }
            for (PsiMethod superMethod : superMethods) {
                if (resolveScope != null) {
                    superMethod = PsiSuperMethodUtil.correctMethodByScope((PsiMethod)superMethod, (GlobalSearchScope)resolveScope).orElse(superMethod);
                }
                result.addAll(MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)searchScope, (boolean)true).findAll());
            }
            ArrayList<PsiReference> arrayList = result;
            if (arrayList == null) {
                JavaFindUsagesHandler.$$$reportNull$$$0(35);
            }
            return arrayList;
        }
        Collection collection = super.findReferencesToHighlight(target, searchScope);
        if (collection == null) {
            JavaFindUsagesHandler.$$$reportNull$$$0(36);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSearch";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/JavaFindUsagesHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/JavaFindUsagesHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesDialog";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterElementsToSearch";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "askWhetherShouldSearchForParameterInOverridingMethods";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getParameterElementsToSearch";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getStringsToSearch";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurrencesAvailable";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findReferencesToHighlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

