/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.PsiClassChildrenSource;
import com.intellij.ide.scopeView.ScopeTreeStructureExpander;
import com.intellij.ide.scopeView.nodes.ClassNode;
import com.intellij.ide.scopeView.nodes.FieldNode;
import com.intellij.ide.scopeView.nodes.MethodNode;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassesScopeTreeStructureExpander
implements ScopeTreeStructureExpander {
    private final Project myProject;

    public ClassesScopeTreeStructureExpander(Project project) {
        this.myProject = project;
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (this.myProject.isDisposed()) {
            return;
        }
        ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
        TreePath path = event.getPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node instanceof DirectoryNode) {
            HashSet<ClassNode> classNodes = null;
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                FileNode fileNode;
                PsiElement file;
                TreeNode childNode = node.getChildAt(i);
                if (!(childNode instanceof FileNode) || !((file = (fileNode = (FileNode)childNode).getPsiElement()) instanceof PsiJavaFile)) continue;
                VirtualFile virtualFile = ((PsiJavaFile)file).getVirtualFile();
                if (virtualFile == null || virtualFile.getFileType() != StdFileTypes.JAVA && virtualFile.getFileType() != StdFileTypes.CLASS) {
                    return;
                }
                PsiClass[] psiClasses = ((PsiJavaFile)file).getClasses();
                if (psiClasses.length <= 0) continue;
                if (classNodes == null) {
                    classNodes = new HashSet<ClassNode>();
                }
                for (PsiClass psiClass : psiClasses) {
                    if (psiClass == null || !psiClass.isValid()) continue;
                    final ClassNode classNode = new ClassNode(psiClass);
                    classNodes.add(classNode);
                    if (!projectView.isShowMembers("Scope")) continue;
                    ArrayList<PsiElement> result = new ArrayList<PsiElement>();
                    PsiClassChildrenSource.DEFAULT_CHILDREN.addChildren(psiClass, result);
                    for (PsiElement psiElement : result) {
                        psiElement.accept((PsiElementVisitor)new JavaElementVisitor(){

                            public void visitClass(PsiClass aClass) {
                                classNode.add((MutableTreeNode)((Object)new ClassNode(aClass)));
                            }

                            public void visitMethod(PsiMethod method) {
                                classNode.add((MutableTreeNode)((Object)new MethodNode(method)));
                            }

                            public void visitField(PsiField field) {
                                classNode.add((MutableTreeNode)((Object)new FieldNode(field)));
                            }
                        });
                    }
                }
                node.remove((MutableTreeNode)fileNode);
            }
            if (classNodes != null) {
                for (ClassNode classNode : classNodes) {
                    node.add((MutableTreeNode)((Object)classNode));
                }
            }
            TreeUtil.sort((DefaultMutableTreeNode)node, (Comparator)this.getNodeComparator());
            Object source = event.getSource();
            if (source instanceof JTree) {
                ((DefaultTreeModel)((JTree)source).getModel()).reload(node);
            }
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath path = event.getPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node instanceof DirectoryNode) {
            HashSet<FileNode> fileNodes = null;
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                TreeNode childNode = node.getChildAt(i);
                if (!(childNode instanceof ClassNode)) continue;
                ClassNode classNode = (ClassNode)((Object)childNode);
                PsiFile containingFile = classNode.getContainingFile();
                if (containingFile != null && containingFile.isValid()) {
                    if (fileNodes == null) {
                        fileNodes = new HashSet<FileNode>();
                    }
                    fileNodes.add(new FileNode(containingFile.getVirtualFile(), this.myProject, true));
                }
                node.remove((MutableTreeNode)((Object)classNode));
            }
            if (fileNodes != null) {
                for (FileNode fileNode : fileNodes) {
                    node.add((MutableTreeNode)fileNode);
                }
            }
            TreeUtil.sort((DefaultMutableTreeNode)node, (Comparator)this.getNodeComparator());
            Object source = event.getSource();
            if (source instanceof JTree) {
                ((DefaultTreeModel)((JTree)source).getModel()).reload(node);
            }
        }
    }

    private DependencyNodeComparator getNodeComparator() {
        return new DependencyNodeComparator(ProjectView.getInstance((Project)this.myProject).isSortByType("Scope"));
    }
}

