/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LightPackageReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final String myPackageName;
    private final PsiPackage myRefPackage;

    public LightPackageReference(PsiManager manager, PsiPackage refPackage) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myPackageName = null;
        this.myRefPackage = refPackage;
    }

    public LightPackageReference(PsiManager manager, String packageName) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myPackageName = packageName;
        this.myRefPackage = null;
    }

    public PsiElement resolve() {
        if (this.myPackageName != null) {
            return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(this.myPackageName);
        }
        return this.myRefPackage;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolve = this.resolve();
        Object object = resolve == null ? JavaResolveResult.EMPTY : new CandidateInfo(resolve, PsiSubstitutor.EMPTY);
        if (object == null) {
            LightPackageReference.$$$reportNull$$$0(0);
        }
        return object;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) {
                LightPackageReference.$$$reportNull$$$0(1);
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            LightPackageReference.$$$reportNull$$$0(2);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public String getText() {
        if (this.myPackageName != null) {
            return this.myPackageName;
        }
        return this.myRefPackage.getQualifiedName();
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            LightPackageReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement copy() {
        if (this.myPackageName != null) {
            return new LightPackageReference(this.myManager, this.myPackageName);
        }
        return new LightPackageReference(this.myManager, this.myRefPackage);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightPackageReference.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LightPackageReference.$$$reportNull$$$0(5);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiPackage)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    public boolean isSoft() {
        return false;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            LightPackageReference.$$$reportNull$$$0(6);
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    public String getQualifiedName() {
        return this.getText();
    }

    public String getReferenceName() {
        if (this.myPackageName != null) {
            return PsiNameHelper.getShortClassName((String)this.myPackageName);
        }
        return this.myRefPackage.getName();
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getElement() {
        return this;
    }

    public boolean isValid() {
        return this.myRefPackage == null || this.myRefPackage.isValid();
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            LightPackageReference.$$$reportNull$$$0(7);
        }
        return PsiType.EMPTY_ARRAY;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public boolean isQualified() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightPackageReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightPackageReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

