/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.JavaNullMethodArgumentIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNullMethodArgumentUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.JavaNullMethodArgumentUtil");

    public static boolean hasNullArgument(@NotNull PsiMethod method, int argumentIdx) {
        if (method == null) {
            JavaNullMethodArgumentUtil.$$$reportNull$$$0(0);
        }
        boolean[] result = new boolean[]{false};
        JavaNullMethodArgumentUtil.searchNullArgument(method, argumentIdx, (Processor<PsiExpression>)((Processor)expression2 -> {
            result[0] = true;
            return false;
        }));
        return result[0];
    }

    public static void searchNullArgument(@NotNull PsiMethod method, int argumentIdx, @NotNull Processor<PsiExpression> nullArgumentProcessor) {
        PsiParameter parameter2;
        if (method == null) {
            JavaNullMethodArgumentUtil.$$$reportNull$$$0(1);
        }
        if (nullArgumentProcessor == null) {
            JavaNullMethodArgumentUtil.$$$reportNull$$$0(2);
        }
        if ((parameter2 = method.getParameterList().getParameters()[argumentIdx]).getType() instanceof PsiEllipsisType) {
            return;
        }
        Collection<VirtualFile> candidateFiles = JavaNullMethodArgumentUtil.getFilesWithPotentialNullPassingCalls(method, argumentIdx);
        long start = System.currentTimeMillis();
        JavaNullMethodArgumentUtil.processCallsWithNullArguments(method, argumentIdx, nullArgumentProcessor, candidateFiles);
        long duration = System.currentTimeMillis() - start;
        if (duration > 200L) {
            LOG.trace("Long nullable argument search for " + method.getName() + "(" + PsiUtil.getMemberQualifiedName((PsiMember)method) + "): " + duration + "ms, " + candidateFiles.size() + " files");
        }
    }

    private static void processCallsWithNullArguments(@NotNull PsiMethod method, int argumentIdx, @NotNull Processor<PsiExpression> nullArgumentProcessor, Collection<VirtualFile> candidateFiles) {
        if (method == null) {
            JavaNullMethodArgumentUtil.$$$reportNull$$$0(3);
        }
        if (nullArgumentProcessor == null) {
            JavaNullMethodArgumentUtil.$$$reportNull$$$0(4);
        }
        if (candidateFiles.isEmpty()) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)method.getProject(), candidateFiles);
        MethodReferencesSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).forEach(ref -> {
            PsiExpression argument;
            if (nullArgumentProcessor == null) {
                JavaNullMethodArgumentUtil.$$$reportNull$$$0(7);
            }
            if ((argument = JavaNullMethodArgumentUtil.getCallArgument(ref, argumentIdx)) instanceof PsiLiteralExpression && argument.textMatches((CharSequence)"null")) {
                return nullArgumentProcessor.process((Object)argument);
            }
            return true;
        });
    }

    @Nullable
    private static PsiExpression getCallArgument(PsiReference ref, int argumentIdx) {
        PsiExpressionList argumentList = JavaNullMethodArgumentUtil.getCallArgumentList(ref.getElement());
        PsiExpression[] arguments = argumentList == null ? PsiExpression.EMPTY_ARRAY : argumentList.getExpressions();
        return argumentIdx < arguments.length ? arguments[argumentIdx] : null;
    }

    @Nullable
    private static PsiExpressionList getCallArgumentList(@Nullable PsiElement psi) {
        PsiElement parent;
        PsiElement psiElement = parent = psi == null ? null : psi.getParent();
        if (parent instanceof PsiCallExpression) {
            return ((PsiCallExpression)parent).getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)parent).getArgumentList();
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getFilesWithPotentialNullPassingCalls(@NotNull PsiMethod method, int parameterIndex) {
        if (method == null) {
            JavaNullMethodArgumentUtil.$$$reportNull$$$0(5);
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor(new ArrayList());
        GlobalSearchScope searchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)method.getUseScope(), (Project)method.getProject());
        searchScope = searchScope.intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)method.getProject()));
        fileBasedIndex.getFilesWithKey(JavaNullMethodArgumentIndex.INDEX_ID, Collections.singleton(new JavaNullMethodArgumentIndex.MethodCallData(method.getName(), parameterIndex)), (Processor)collector, searchScope);
        Collection collection = collector.getResults();
        if (collection == null) {
            JavaNullMethodArgumentUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullArgumentProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithPotentialNullPassingCalls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasNullArgument";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "searchNullArgument";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCallsWithNullArguments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithPotentialNullPassingCalls";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCallsWithNullArguments$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

