/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParser;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentFormatter {
    private static final Logger LOG = Logger.getInstance(CommentFormatter.class);
    private final CodeStyleSettings mySettings;
    private final JDParser myParser;
    private final Project myProject;

    @Deprecated
    public CommentFormatter(@NotNull Project project) {
        if (project == null) {
            CommentFormatter.$$$reportNull$$$0(0);
        }
        this.mySettings = CodeStyle.getSettings((Project)project);
        this.myParser = new JDParser(this.mySettings);
        this.myProject = project;
    }

    public CommentFormatter(@NotNull PsiFile file) {
        if (file == null) {
            CommentFormatter.$$$reportNull$$$0(1);
        }
        this.mySettings = CodeStyle.getSettings((PsiFile)file);
        this.myParser = new JDParser(this.mySettings);
        this.myProject = file.getProject();
    }

    public JavaCodeStyleSettings getSettings() {
        return (JavaCodeStyleSettings)this.mySettings.getCustomSettings(JavaCodeStyleSettings.class);
    }

    public JDParser getParser() {
        return this.myParser;
    }

    public void processComment(@Nullable ASTNode element) {
        if (!this.getSettings().ENABLE_JAVADOC_FORMATTING) {
            return;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)element);
        if (psiElement != null) {
            this.getParser().formatCommentText(psiElement, this);
        }
    }

    public void replaceCommentText(@Nullable String newCommentText, @Nullable PsiDocComment oldComment) {
        if (newCommentText != null) {
            newCommentText = CommentFormatter.stripSpaces(newCommentText);
        }
        if (newCommentText == null || oldComment == null || newCommentText.equals(oldComment.getText())) {
            return;
        }
        try {
            PsiComment newComment = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createCommentFromText(newCommentText, null);
            ASTNode oldNode = oldComment.getNode();
            ASTNode newNode = newComment.getNode();
            assert (oldNode != null && newNode != null);
            ASTNode parent = oldNode.getTreeParent();
            parent.replaceChild(oldNode, newNode);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String stripSpaces(String text2) {
        String[] lines = LineTokenizer.tokenize((char[])text2.toCharArray(), (boolean)false);
        StringBuilder buf = new StringBuilder(text2.length());
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(CommentFormatter.rTrim(lines[i]));
        }
        return buf.toString();
    }

    private static String rTrim(String text2) {
        int idx;
        for (idx = text2.length(); idx > 0 && Character.isWhitespace(text2.charAt(idx - 1)); --idx) {
        }
        return text2.substring(0, idx);
    }

    private int getIndentSpecial(@NotNull PsiElement element) {
        if (element == null) {
            CommentFormatter.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiMember)) {
            return 0;
        }
        int indentSize = this.mySettings.getIndentSize((FileType)JavaFileType.INSTANCE);
        boolean doNotIndentTopLevelClassMembers = this.mySettings.getCommonSettings((Language)JavaLanguage.INSTANCE).DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS;
        int indent = 0;
        PsiClass top = PsiUtil.getTopLevelClass((PsiElement)element);
        while (!(top == null || element.isEquivalentTo((PsiElement)top) || doNotIndentTopLevelClassMembers && element.getParent().isEquivalentTo((PsiElement)top))) {
            element = element.getParent();
            indent += indentSize;
        }
        return indent;
    }

    @NotNull
    public String getIndent(@NotNull PsiElement element) {
        if (element == null) {
            CommentFormatter.$$$reportNull$$$0(3);
        }
        String string = StringUtil.repeatSymbol((char)' ', (int)this.getIndentSpecial(element));
        if (string == null) {
            CommentFormatter.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSpecial";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

