/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.daemon.impl.quickfix.DefineParamsDefaultValueAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetectedJavaChangeInfo
extends JavaChangeInfoImpl {
    private PsiMethod mySuperMethod;
    private final String[] myModifiers;

    DetectedJavaChangeInfo(@PsiModifier.ModifierConstant String newVisibility, PsiMethod method, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] newParms, ThrownExceptionInfo[] newExceptions, String newName, String oldName, boolean delegate) {
        if (newParms == null) {
            DetectedJavaChangeInfo.$$$reportNull$$$0(0);
        }
        super(newVisibility, method, newName, newType, newParms, newExceptions, delegate, new HashSet<PsiMethod>(), new HashSet<PsiMethod>(), oldName);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        this.myModifiers = new String[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            String text2;
            PsiParameter parameter2 = parameters2[i];
            PsiModifierList modifierList = parameter2.getModifierList();
            if (modifierList == null) continue;
            this.myModifiers[i] = text2 = modifierList.getText();
        }
    }

    @Nullable
    static DetectedJavaChangeInfo createFromMethod(PsiMethod method, boolean delegate) {
        ParameterInfoImpl[] parameterInfos;
        String newVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
        PsiType returnType = method.getReturnType();
        CanonicalTypes.Type newReturnType = returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null;
        for (ParameterInfoImpl parameterInfo : parameterInfos = ParameterInfoImpl.fromMethod(method)) {
            if (parameterInfo.getTypeWrapper().isValid()) continue;
            return null;
        }
        DetectedJavaChangeInfo fromMethod = new DetectedJavaChangeInfo(newVisibility, method, newReturnType, parameterInfos, null, method.getName(), method.getName(), delegate);
        PsiMethod deepestSuperMethod = method.findDeepestSuperMethod();
        if (deepestSuperMethod != null && !deepestSuperMethod.getManager().isInProject((PsiElement)deepestSuperMethod)) {
            return null;
        }
        fromMethod.setSuperMethod(deepestSuperMethod);
        return fromMethod;
    }

    @Override
    protected void setupPropagationEnabled(PsiParameter[] parameters2, ParameterInfoImpl[] newParams) {
        this.isPropagationEnabled = false;
    }

    public PsiMethod getSuperMethod() {
        if (this.mySuperMethod == null) {
            return this.getMethod();
        }
        return this.mySuperMethod;
    }

    public void setSuperMethod(PsiMethod superMethod) {
        this.mySuperMethod = superMethod;
    }

    public String[] getModifiers() {
        return this.myModifiers;
    }

    @Override
    protected boolean checkMethodEquality() {
        return false;
    }

    @Nullable
    DetectedJavaChangeInfo createNextInfo(PsiMethod method, boolean delegate) {
        DetectedJavaChangeInfo fromMethod = DetectedJavaChangeInfo.createFromMethod(method, delegate);
        if (fromMethod == null) {
            return null;
        }
        if (!this.equals(fromMethod)) {
            String visibility;
            if (!this.createParametersInfo(fromMethod.newParms)) {
                return null;
            }
            if (!(!(fromMethod.newReturnType != null && this.getNewReturnType() == null || fromMethod.newReturnType == null && this.getNewReturnType() != null) && (fromMethod.newReturnType == null || this.getNewReturnType() == null || Comparing.strEqual((String)this.getNewReturnType().getTypeText(), (String)fromMethod.newReturnType.getTypeText())) || !Comparing.strEqual((String)(visibility = this.getNewVisibility()), (String)"private") || this.isArrayToVarargs() || this.isExceptionSetOrOrderChanged() || this.isExceptionSetChanged() || this.isNameChanged() || this.isParameterSetOrOrderChanged() || this.isParameterNamesChanged() || this.isParameterTypesChanged())) {
                return null;
            }
            try {
                DetectedJavaChangeInfo javaChangeInfo = new DetectedJavaChangeInfo(fromMethod.getNewVisibility(), this.getMethod(), fromMethod.newReturnType, fromMethod.newParms, this.getNewExceptions(), method.getName(), this.getOldName(), delegate){

                    @Override
                    protected void fillOldParams(PsiMethod method) {
                        this.oldParameterNames = DetectedJavaChangeInfo.this.getOldParameterNames();
                        this.oldParameterTypes = DetectedJavaChangeInfo.this.getOldParameterTypes();
                        if (!method.isConstructor()) {
                            try {
                                this.isReturnTypeChanged = this.isReturnTypeChanged || (DetectedJavaChangeInfo.this.getNewReturnType() != null ? !Comparing.strEqual((String)DetectedJavaChangeInfo.this.getNewReturnType().getTypeText(), (String)this.newReturnType.getTypeText()) : this.newReturnType != null);
                            }
                            catch (IncorrectOperationException e) {
                                this.isReturnTypeChanged = true;
                            }
                        }
                        int length = Math.min(this.newParms.length, this.oldParameterNames.length);
                        for (int i = 0; i < length; ++i) {
                            ParameterInfoImpl parm = this.newParms[i];
                            if (!parm.getName().equals(this.oldParameterNames[i]) || !parm.getTypeText().equals(this.oldParameterTypes[i])) continue;
                            parm.oldParameterIndex = i;
                        }
                    }
                };
                javaChangeInfo.setSuperMethod(this.getSuperMethod());
                return javaChangeInfo;
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        return this;
    }

    ChangeSignatureProcessor createChangeSignatureProcessor(final PsiMethod method) {
        return new ChangeSignatureProcessor(method.getProject(), new DetectedJavaChangeInfo(this.getNewVisibility(), this.getSuperMethod(), this.getNewReturnType(), (ParameterInfoImpl[])this.getNewParameters(), this.getNewExceptions(), this.getNewName(), method.getName(), this.isGenerateDelegate()){

            @Override
            protected void fillOldParams(PsiMethod method) {
                super.fillOldParams(method);
                this.oldParameterNames = DetectedJavaChangeInfo.this.getOldParameterNames();
                this.oldParameterTypes = DetectedJavaChangeInfo.this.getOldParameterTypes();
            }
        }){

            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.performRefactoring(usages);
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                for (int i = 0; i < DetectedJavaChangeInfo.this.getModifiers().length; ++i) {
                    PsiModifierList newModifierList;
                    String modifier = DetectedJavaChangeInfo.this.getModifiers()[i];
                    PsiModifierList modifierList = parameters2[i].getModifierList();
                    if (modifierList == null || Comparing.strEqual((String)modifier, (String)modifierList.getText()) || (newModifierList = elementFactory.createParameterFromText((modifier.isEmpty() ? "" : modifier + " ") + "type name", (PsiElement)method).getModifierList()) == null) continue;
                    modifierList.replace((PsiElement)newModifierList);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/DetectedJavaChangeInfo$3", "performRefactoring"));
            }
        };
    }

    private boolean createParametersInfo(ParameterInfoImpl[] parameterInfos) {
        JavaParameterInfo oldParameter;
        ParameterInfoImpl parameterInfo;
        int i;
        JavaParameterInfo[] oldParameters = this.getNewParameters();
        String[] oldParameterNames = this.getOldParameterNames();
        String[] oldParameterTypes = this.getOldParameterTypes();
        HashMap<ParameterInfoImpl, Integer> untouchedParams = new HashMap<ParameterInfoImpl, Integer>();
        for (i = 0; i < parameterInfos.length; ++i) {
            parameterInfo = parameterInfos[i];
            oldParameter = null;
            for (JavaParameterInfo parameter2 : oldParameters) {
                if (!Comparing.strEqual((String)parameter2.getName(), (String)parameterInfo.getName()) || !Comparing.strEqual((String)parameter2.getTypeText(), (String)parameterInfo.getTypeText())) continue;
                oldParameter = parameter2;
                break;
            }
            if (oldParameter == null) continue;
            parameterInfos[i] = new ParameterInfoImpl(oldParameter.getOldIndex(), oldParameter.getName(), oldParameter.getTypeWrapper(), null);
            untouchedParams.put(parameterInfos[i], oldParameter.getOldIndex());
        }
        for (i = 0; i < parameterInfos.length; ++i) {
            CanonicalTypes.Type typeWrapper;
            parameterInfo = parameterInfos[i];
            if (untouchedParams.containsKey(parameterInfo)) continue;
            oldParameter = null;
            if (oldParameters.length > i && oldParameterNames.length > i && (Comparing.strEqual((String)oldParameterNames[i], (String)parameterInfo.getName()) || Comparing.strEqual((String)oldParameterTypes[i], (String)parameterInfo.getTypeText())) && !untouchedParams.containsValue(oldParameters[i].getOldIndex())) {
                oldParameter = oldParameters[i];
            }
            if (!(typeWrapper = parameterInfo.getTypeWrapper()).isValid()) {
                return false;
            }
            parameterInfos[i] = new ParameterInfoImpl(oldParameter != null ? oldParameter.getOldIndex() : -1, parameterInfo.getName(), typeWrapper, null);
        }
        return true;
    }

    void perform(final String oldText, Editor editor, boolean silently) {
        final PsiMethod method = this.getSuperMethod();
        final Project project = this.getMethod().getProject();
        final PsiMethod currentMethod = this.getMethod();
        TextRange signatureRange = JavaChangeSignatureDetector.getSignatureRange(currentMethod);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        final Document document = documentManager.getDocument(currentMethod.getContainingFile());
        if (silently || ApplicationManager.getApplication().isUnitTestMode()) {
            PsiMethod prototype;
            String currentSignature = currentMethod.getContainingFile().getText().substring(signatureRange.getStartOffset(), signatureRange.getEndOffset());
            InplaceChangeSignature.temporallyRevertChanges((TextRange)JavaChangeSignatureDetector.getSignatureRange(currentMethod), (Document)document, (String)oldText, (Project)project);
            if (this.isGenerateDelegate()) {
                for (JavaParameterInfo info : this.getNewParameters()) {
                    if (info.getOldIndex() != -1) continue;
                    ((ParameterInfoImpl)info).setDefaultValue("null");
                }
                prototype = JavaChangeSignatureUsageProcessor.generateDelegatePrototype(this);
            } else {
                prototype = null;
            }
            this.createChangeSignatureProcessor(method).run();
            InplaceChangeSignature.temporallyRevertChanges((TextRange)JavaChangeSignatureDetector.getSignatureRange(currentMethod), (Document)document, (String)currentSignature, (Project)project);
            if (prototype != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)"Delegate", null, () -> {
                    PsiExpression expression2;
                    PsiMethod delegate = currentMethod.getContainingClass().findMethodBySignature(prototype, false);
                    PsiExpression psiExpression = expression2 = delegate != null ? LambdaUtil.extractSingleExpressionFromBody((PsiElement)delegate.getBody()) : null;
                    if (expression2 instanceof PsiMethodCallExpression) {
                        PsiExpression[] expressions2 = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions();
                        JavaParameterInfo[] parameters2 = this.getNewParameters();
                        PsiExpression[] toBeDefault = (PsiExpression[])Arrays.stream(parameters2).filter(param -> param.getOldIndex() == -1).map(info -> {
                            int i = ArrayUtil.find((Object[])parameters2, (Object)info);
                            return expressions2[i];
                        }).toArray(PsiExpression[]::new);
                        DefineParamsDefaultValueAction.startTemplate(project, editor, toBeDefault, delegate);
                    }
                }, (PsiFile[])new PsiFile[0]);
            }
            return;
        }
        JavaMethodDescriptor descriptor = new JavaMethodDescriptor(currentMethod){

            @Override
            public String getReturnTypeText() {
                return DetectedJavaChangeInfo.this.getNewReturnType().getTypeText();
            }
        };
        JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(method.getProject(), descriptor, true, (PsiElement)method){

            @Override
            protected BaseRefactoringProcessor createRefactoringProcessor() {
                return DetectedJavaChangeInfo.this.createChangeSignatureProcessor(method);
            }

            @Override
            protected void invokeRefactoring(BaseRefactoringProcessor processor) {
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    InplaceChangeSignature.temporallyRevertChanges((TextRange)JavaChangeSignatureDetector.getSignatureRange(currentMethod), (Document)document, (String)oldText, (Project)project);
                    this.doRefactor(processor);
                }, RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)currentMethod)}), null);
            }

            private void doRefactor(BaseRefactoringProcessor processor) {
                super.invokeRefactoring(processor);
            }
        };
        dialog.showAndGet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParms", "com/intellij/refactoring/changeSignature/DetectedJavaChangeInfo", "<init>"));
    }
}

