/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineLocalDialog;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineLocalHandler
extends JavaInlineActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineLocalHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.variable.title");

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiLocalVariable;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        PsiReferenceExpression refExpr = psiReference instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiReference : null;
        InlineLocalHandler.invoke(project, editor, (PsiLocalVariable)element, refExpr);
    }

    public static void invoke(@NotNull Project project, Editor editor, PsiLocalVariable local, PsiReferenceExpression refExpr) {
        PsiExpression defToInline;
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(0);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String localName = local.getName();
        List innerClassesWithUsages = Collections.synchronizedList(new ArrayList());
        List<PsiElement> innerClassUsages = Collections.synchronizedList(new ArrayList());
        PsiElement containingClass = PsiTreeUtil.getParentOfType((PsiElement)local, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        Query query = ReferencesSearch.search((PsiElement)local);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (project == null) {
                InlineLocalHandler.$$$reportNull$$$0(5);
            }
            if (query.findFirst() == null) {
                LOG.assertTrue(refExpr == null);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        InlineLocalHandler.$$$reportNull$$$0(6);
                    }
                    String message2 = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName});
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
                }, ModalityState.NON_MODAL);
                return;
            }
            query.forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                PsiElement innerClass = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                while (innerClass != containingClass && innerClass != null) {
                    PsiElement parentPsiClass = PsiTreeUtil.getParentOfType((PsiElement)innerClass.getParent(), (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                    if (parentPsiClass == containingClass) {
                        if (innerClass instanceof PsiLambdaExpression && PsiTreeUtil.isAncestor((PsiElement)innerClass, (PsiElement)local, (boolean)false)) {
                            innerClassesWithUsages.add(element);
                            innerClass = parentPsiClass;
                            continue;
                        }
                        innerClassesWithUsages.add(innerClass);
                        innerClassUsages.add(element);
                    }
                    innerClass = parentPsiClass;
                }
                return true;
            });
        }, "Find Usages", true, project)) {
            return;
        }
        PsiCodeBlock containerBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)local, PsiCodeBlock.class);
        if (containerBlock == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)"Variable is declared outside a code block");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        try {
            defToInline = InlineLocalHandler.getDefToInline((PsiVariable)local, (PsiElement)(innerClassesWithUsages.isEmpty() ? refExpr : (PsiElement)innerClassesWithUsages.get(0)), containerBlock, true);
            if (defToInline == null) {
                String key2 = refExpr == null ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
                String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key2, (Object[])new Object[]{localName}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
                return;
            }
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AnalysisCanceledException) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"extract.method.control.flow.analysis.failed")), (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
                return;
            }
            throw e;
        }
        List<Object> refsToInlineList = new ArrayList<PsiElement>();
        Collections.addAll(refsToInlineList, DefUseUtil.getRefs(containerBlock, (PsiVariable)local, (PsiElement)defToInline));
        for (PsiElement innerClassUsage : innerClassUsages) {
            if (refsToInlineList.contains(innerClassUsage)) continue;
            refsToInlineList.add(innerClassUsage);
        }
        if (refsToInlineList.size() == 0) {
            String message4 = RefactoringBundle.message((String)"variable.is.never.used.before.modification", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        Ref inlineAll = new Ref((Object)true);
        if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            int occurrencesCount = refsToInlineList.size();
            if (refExpr != null && occurrencesCount > 1 || EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog()) {
                InlineLocalDialog inlineLocalDialog = new InlineLocalDialog(project, (PsiVariable)local, (PsiJavaCodeReferenceElement)refExpr, occurrencesCount);
                if (!inlineLocalDialog.showAndGet()) {
                    WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                    return;
                }
                if (refExpr != null && inlineLocalDialog.isInlineThis()) {
                    refsToInlineList = Collections.singletonList(refExpr);
                    inlineAll.set((Object)false);
                }
            }
        }
        Object[] refsToInline = PsiUtilCore.toPsiElementArray(refsToInlineList);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])refsToInline, attributes, true, null);
        }
        if (refExpr != null && PsiUtil.isAccessedForReading((PsiExpression)refExpr) && ArrayUtil.find((Object[])refsToInline, (Object)refExpr) < 0) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)refExpr);
            LOG.assertTrue(defs.length > 0);
            highlightManager.addOccurrenceHighlights(editor, defs, attributes, true, null);
            String message5 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)defToInline, PsiTryStatement.class);
        if (tryStatement != null && ExceptionUtil.getThrownExceptions((PsiElement)defToInline).isEmpty()) {
            tryStatement = null;
        }
        PsiFile workingFile = local.getContainingFile();
        for (Object ref2 : refsToInline) {
            PsiFile otherFile = ref2.getContainingFile();
            if (!otherFile.equals(workingFile)) {
                String message6 = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message6, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
                return;
            }
            if (tryStatement == null || PsiTreeUtil.isAncestor((PsiElement)tryStatement, (PsiElement)ref2, (boolean)false)) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Unable to inline outside try/catch statement", (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        for (Object ref2 : refsToInline) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)ref2);
            boolean isSameDefinition = true;
            for (PsiElement def : defs) {
                isSameDefinition &= InlineLocalHandler.isSameDefinition(def, defToInline);
            }
            if (isSameDefinition) continue;
            highlightManager.addOccurrenceHighlights(editor, defs, writeAttributes, true, null);
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{ref2}, attributes, true, null);
            String message7 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message7, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        PsiElement writeAccess = InlineLocalHandler.checkRefsInAugmentedAssignmentOrUnaryModified((PsiElement[])refsToInline, (PsiElement)defToInline);
        if (writeAccess != null) {
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{writeAccess}, writeAttributes, true, null);
            String message8 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message8, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        if (Arrays.stream(refsToInline).anyMatch(ref -> ref.getParent() instanceof PsiResourceExpression)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)"Variable is used as resource reference"), (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        Runnable runnable = () -> InlineLocalHandler.lambda$invoke$7((PsiElement[])refsToInline, project, local, defToInline, inlineAll, editor, highlightManager, attributes, containingClass);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                InlineLocalHandler.$$$reportNull$$$0(2);
            }
            PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(runnable);
        }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{localName}), null);
    }

    private static void deleteInitializer(@NotNull PsiExpression defToInline) {
        PsiElement gParent;
        PsiElement parent;
        if (defToInline == null) {
            InlineLocalHandler.$$$reportNull$$$0(1);
        }
        if ((parent = defToInline.getParent()) instanceof PsiAssignmentExpression && !((gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent())) instanceof PsiExpressionStatement)) {
            parent.replace((PsiElement)defToInline);
            return;
        }
        parent.delete();
    }

    @Nullable
    public static PsiElement checkRefsInAugmentedAssignmentOrUnaryModified(PsiElement[] refsToInline, PsiElement defToInline) {
        for (PsiElement element : refsToInline) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                if (((PsiArrayAccessExpression)parent).getIndexExpression() == element || defToInline instanceof PsiExpression && !(defToInline instanceof PsiNewExpression)) continue;
                element = parent;
            }
            if (!RefactoringUtil.isAssignmentLHS(element)) continue;
            return element;
        }
        return null;
    }

    private static boolean isSameDefinition(PsiElement def, PsiExpression defToInline) {
        if (def instanceof PsiLocalVariable) {
            return defToInline.equals(((PsiLocalVariable)def).getInitializer());
        }
        PsiElement parent = def.getParent();
        return parent instanceof PsiAssignmentExpression && defToInline.equals(((PsiAssignmentExpression)parent).getRExpression());
    }

    private static boolean isInliningVariableInitializer(PsiExpression defToInline) {
        return defToInline.getParent() instanceof PsiVariable;
    }

    @Nullable
    static PsiExpression getDefToInline(PsiVariable local, PsiElement refExpr, PsiCodeBlock block, boolean rethrow) {
        if (refExpr != null) {
            PsiElement def;
            if (refExpr instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refExpr))) {
                def = refExpr;
            } else {
                PsiElement[] defs = DefUseUtil.getDefs(block, local, refExpr, rethrow);
                if (defs.length == 1) {
                    def = defs[0];
                } else {
                    return null;
                }
            }
            if (def instanceof PsiReferenceExpression && def.getParent() instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)def.getParent();
                if (assignmentExpression.getOperationTokenType() != JavaTokenType.EQ) {
                    return null;
                }
                PsiExpression rExpr = assignmentExpression.getRExpression();
                if (rExpr != null) {
                    return rExpr;
                }
            }
        }
        return local.getInitializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$invoke$7(PsiElement[] refsToInline, @NotNull Project project, PsiLocalVariable local, PsiExpression defToInline, Ref inlineAll, Editor editor, HighlightManager highlightManager, TextAttributes attributes, PsiElement containingClass) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(3);
        }
        String refactoringId = "refactoring.inline.local.variable";
        try {
            Object[] exprs = new SmartPsiElementPointer[refsToInline.length];
            RefactoringEventData beforeData = new RefactoringEventData();
            beforeData.addElements(refsToInline);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.inline.local.variable", beforeData);
            WriteAction.run(() -> InlineLocalHandler.lambda$null$4(project, refsToInline, (SmartPsiElementPointer[])exprs, local, defToInline, inlineAll));
            if (((Boolean)inlineAll.get()).booleanValue() && ReferencesSearch.search((PsiElement)local).findFirst() == null && editor != null) {
                QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)local).invoke(project, editor, local.getContainingFile());
            }
            if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                highlightManager.addOccurrenceHighlights(editor, (PsiElement[])ContainerUtil.convert((Object[])exprs, (Object[])new PsiExpression[refsToInline.length], pointer -> (PsiExpression)pointer.getElement()), attributes, true, null);
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            WriteAction.run(() -> InlineLocalHandler.lambda$null$6((SmartPsiElementPointer[])exprs));
        }
        finally {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement(containingClass);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.inline.local.variable", afterData);
        }
    }

    private static /* synthetic */ void lambda$null$6(SmartPsiElementPointer[] exprs) throws RuntimeException {
        for (SmartPsiElementPointer expr : exprs) {
            InlineUtil.tryToInlineArrayCreationForVarargs((PsiExpression)expr.getElement());
        }
    }

    private static /* synthetic */ void lambda$null$4(@NotNull Project project, PsiElement[] refsToInline, SmartPsiElementPointer[] exprs, PsiLocalVariable local, PsiExpression defToInline, Ref inlineAll) throws RuntimeException {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(4);
        }
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        for (int idx = 0; idx < refsToInline.length; ++idx) {
            PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)refsToInline[idx];
            exprs[idx] = pointerManager.createSmartPsiElementPointer((PsiElement)InlineUtil.inlineVariable((PsiVariable)local, defToInline, refElement));
        }
        if (((Boolean)inlineAll.get()).booleanValue()) {
            if (!InlineLocalHandler.isInliningVariableInitializer(defToInline)) {
                InlineLocalHandler.deleteInitializer(defToInline);
            } else {
                defToInline.delete();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defToInline";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/inline/InlineLocalHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$8";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$7";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$4";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$2";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

