/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.AutomaticVariableRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;

public class AutomaticVariableRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(PsiElement element) {
        return element instanceof PsiClass && !(element instanceof PsiAnonymousClass);
    }

    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.variables");
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isToRenameVariables();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameVariables(enabled);
    }

    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new AutomaticVariableRenamer((PsiClass)element, newName, usages);
    }
}

