/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMayBeWeakenedInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean useRighthandTypeAsWeakestTypeInAssignments = true;
    public boolean useParameterizedTypeForCollectionMethods = true;
    public boolean doNotWeakenToJavaLangObject = true;
    public boolean onlyWeakentoInterface = true;
    public boolean doNotWeakenReturnType = true;
    public OrderedSet<String> myStopClassSet = new OrderedSet();
    private final ListWrappingTableModel myStopClassesModel = new ListWrappingTableModel(this.myStopClassSet, InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.selection.table", new Object[0]));

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(0);
        }
        List options = node.getChildren("option");
        HashMap<String, String> values = new HashMap<String, String>();
        for (Element option : options) {
            Attribute valueAttribute;
            Attribute nameAttribute = option.getAttribute("name");
            if (nameAttribute == null || (valueAttribute = option.getAttribute("value")) == null) continue;
            values.put(nameAttribute.getValue(), valueAttribute.getValue());
        }
        this.useRighthandTypeAsWeakestTypeInAssignments = TypeMayBeWeakenedInspection.readOrDefault(values, "useRighthandTypeAsWeakestTypeInAssignments");
        this.useParameterizedTypeForCollectionMethods = TypeMayBeWeakenedInspection.readOrDefault(values, "useParameterizedTypeForCollectionMethods");
        this.doNotWeakenToJavaLangObject = TypeMayBeWeakenedInspection.readOrDefault(values, "doNotWeakenToJavaLangObject");
        this.onlyWeakentoInterface = TypeMayBeWeakenedInspection.readOrDefault(values, "onlyWeakentoInterface");
        this.doNotWeakenReturnType = TypeMayBeWeakenedInspection.readOrDefault(values, "doNotWeakenReturnType");
        this.readStopClasses(node);
    }

    private static boolean readOrDefault(Map<String, String> options, String name) {
        String value2 = options.get(name);
        return value2 == null || Boolean.parseBoolean(value2);
    }

    private void readStopClasses(@NotNull Element node) {
        List classes2;
        if (node == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(1);
        }
        if ((classes2 = node.getChildren("stopClasses")).isEmpty()) {
            return;
        }
        Element element = (Element)classes2.get(0);
        List contentList = element.getContent();
        if (contentList.isEmpty()) {
            return;
        }
        String text2 = ((Content)contentList.get(0)).getValue();
        this.myStopClassSet.addAll(Arrays.asList(text2.split(",")));
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(2);
        }
        TypeMayBeWeakenedInspection.writeBool(node, this.useRighthandTypeAsWeakestTypeInAssignments, "useRighthandTypeAsWeakestTypeInAssignments");
        TypeMayBeWeakenedInspection.writeBool(node, this.useParameterizedTypeForCollectionMethods, "useParameterizedTypeForCollectionMethods");
        TypeMayBeWeakenedInspection.writeBool(node, this.doNotWeakenToJavaLangObject, "doNotWeakenToJavaLangObject");
        TypeMayBeWeakenedInspection.writeBool(node, this.onlyWeakentoInterface, "onlyWeakentoInterface");
        if (!this.doNotWeakenReturnType) {
            TypeMayBeWeakenedInspection.writeBool(node, true, "doNotWeakenReturnType");
        }
        if (!this.myStopClassSet.isEmpty()) {
            Element stopClasses = new Element("stopClasses");
            stopClasses.addContent(this.myStopClassSet.stream().collect(Collectors.joining(",")));
            node.addContent(stopClasses);
        }
    }

    private static void writeBool(@NotNull Element node, boolean value2, String name) {
        if (node == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(3);
        }
        Element optionElement = new Element("option");
        optionElement.setAttribute("name", name);
        optionElement.setAttribute("value", String.valueOf(value2));
        node.addContent(optionElement);
    }

    void addClass(final @NotNull String stopClass, @NotNull PsiElement context) {
        if (stopClass == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(5);
        }
        if (this.myStopClassSet.add((Object)stopClass)) {
            final Project project = context.getProject();
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)context);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

                public void undo() {
                    TypeMayBeWeakenedInspection.this.myStopClassSet.remove((Object)stopClass);
                    ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
                }

                public void redo() {
                    TypeMayBeWeakenedInspection.this.myStopClassSet.add((Object)stopClass);
                    ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
                }

                public boolean isGlobal() {
                    return true;
                }
            });
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.display.name", new Object[0]);
        if (string == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    static String getClassName(PsiClass aClass) {
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName == null ? aClass.getName() : qualifiedName;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        VerticalBox verticalBox = new VerticalBox();
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.ignore.option", new Object[0]), "useRighthandTypeAsWeakestTypeInAssignments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.collection.method.option", new Object[0]), "useParameterizedTypeForCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.do.not.weaken.to.object.option", new Object[0]), "doNotWeakenToJavaLangObject");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.only.weaken.to.an.interface", new Object[0]), "onlyWeakentoInterface");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.type.may.be.weakened.do.not.weaken.return.type", new Object[0]), "doNotWeakenReturnType");
        verticalBox.add((Component)optionsPanel);
        ListTable stopClassesTable = new ListTable(this.myStopClassesModel);
        JPanel stopClassesPanel = UiUtils.createAddRemoveTreeClassChooserPanel(stopClassesTable, InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.selection.table", new Object[0]), "java.lang.Object");
        verticalBox.add((Component)stopClassesPanel);
        return verticalBox;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(7);
        }
        if (session == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(8);
        }
        TypeMayBeWeakenedVisitor typeMayBeWeakenedVisitor = new TypeMayBeWeakenedVisitor(holder, isOnTheFly);
        if (typeMayBeWeakenedVisitor == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(9);
        }
        return typeMayBeWeakenedVisitor;
    }

    static PsiClass tryReplaceWithParentStopper(@NotNull PsiClass fromIncl, @NotNull PsiClass toIncl, Collection<String> stopClasses) {
        if (fromIncl == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(10);
        }
        if (toIncl == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(11);
        }
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)fromIncl)) {
            if (!superClass.isInheritor(toIncl, true) || !stopClasses.contains(TypeMayBeWeakenedInspection.getClassName(superClass))) continue;
            return superClass;
        }
        return toIncl;
    }

    @NotNull
    static List<String> getInheritors(PsiClass from, PsiClass to) {
        ArrayList<String> candidates = new ArrayList<String>();
        String fromName = TypeMayBeWeakenedInspection.getClassName(from);
        if (fromName != null) {
            candidates.add(fromName);
        }
        for (PsiClass cls : InheritanceUtil.getSuperClasses((PsiClass)from)) {
            String name;
            if (!cls.isInheritor(to, true) || (name = TypeMayBeWeakenedInspection.getClassName(cls)) == null) continue;
            candidates.add(name);
        }
        ArrayList<String> arrayList = candidates;
        if (arrayList == null) {
            TypeMayBeWeakenedInspection.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromIncl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIncl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readStopClasses";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeBool";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addClass";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryReplaceWithParentStopper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TypeMayBeWeakenedVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        TypeMayBeWeakenedVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitVariable(PsiVariable variable) {
            PsiExpression initializer;
            PsiForeachStatement foreachStatement;
            PsiExpression iteratedValue2;
            PsiElement parent;
            super.visitVariable(variable);
            if (variable instanceof PsiParameter) {
                PsiParameter parameter2 = (PsiParameter)variable;
                PsiElement declarationScope = parameter2.getDeclarationScope();
                if (declarationScope instanceof PsiCatchSection) {
                    return;
                }
                if (declarationScope instanceof PsiLambdaExpression && parameter2.getTypeElement() == null) {
                    return;
                }
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null || containingClass.isInterface()) {
                        return;
                    }
                    if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
                        return;
                    }
                    if (MethodUtils.hasSuper(method)) {
                        return;
                    }
                    Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method);
                    if (overridingSearch.findFirst() != null) {
                        return;
                    }
                }
            }
            if (this.myIsOnTheFly && variable instanceof PsiField && !variable.hasModifierProperty("private")) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments && (variable instanceof PsiParameter ? (parent = variable.getParent()) instanceof PsiForeachStatement && !((iteratedValue2 = (foreachStatement = (PsiForeachStatement)parent).getIteratedValue()) instanceof PsiNewExpression) && !(iteratedValue2 instanceof PsiTypeCastExpression) : !((initializer = variable.getInitializer()) instanceof PsiNewExpression) && !(initializer instanceof PsiTypeCastExpression))) {
                return;
            }
            if (UnusedSymbolUtil.isImplicitWrite(variable) || UnusedSymbolUtil.isImplicitRead(variable)) {
                return;
            }
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)variable.getType(), PsiClassType.class);
            if (classType == null) {
                return;
            }
            PsiClass originClass = classType.resolve();
            if (originClass == null) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.myStopClassSet.contains((Object)TypeMayBeWeakenedInspection.getClassName(originClass))) {
                return;
            }
            Collection<PsiClass> weakestClasses = this.computeWeakestClasses((PsiElement)variable, originClass);
            if (weakestClasses.isEmpty()) {
                return;
            }
            PsiIdentifier nameIdentifier = variable.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            this.registerProblem((PsiElement)nameIdentifier, (PsiElement)variable, originClass, weakestClasses);
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenReturnType) {
                return;
            }
            if (this.myIsOnTheFly && !method.hasModifierProperty("private") && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method);
            if (overridingSearch.findFirst() != null) {
                return;
            }
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)method.getReturnType(), PsiClassType.class);
            if (classType == null) {
                return;
            }
            PsiClass originClass = classType.resolve();
            if (originClass == null) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.myStopClassSet.contains((Object)TypeMayBeWeakenedInspection.getClassName(originClass))) {
                return;
            }
            Collection<PsiClass> weakestClasses = this.computeWeakestClasses((PsiElement)method, originClass);
            if (weakestClasses.isEmpty()) {
                return;
            }
            PsiIdentifier identifier = method.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            this.registerProblem((PsiElement)identifier, (PsiElement)method, originClass, weakestClasses);
        }

        private Collection<PsiClass> computeWeakestClasses(PsiElement element, PsiClass originClass) {
            Collection weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary(element, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                weakestClasses.remove(ClassUtils.findObjectClass(element));
            }
            if (TypeMayBeWeakenedInspection.this.onlyWeakentoInterface) {
                Iterator<PsiClass> iterator = weakestClasses.iterator();
                while (iterator.hasNext()) {
                    PsiClass weakestClass = iterator.next();
                    if (weakestClass.isInterface()) continue;
                    iterator.remove();
                }
            }
            weakestClasses = weakestClasses.stream().map(psiClass -> TypeMayBeWeakenedInspection.tryReplaceWithParentStopper(originClass, psiClass, TypeMayBeWeakenedInspection.this.myStopClassSet)).collect(Collectors.toList());
            return weakestClasses;
        }

        private void registerProblem(@NotNull PsiElement psiElement, @NotNull PsiElement element, @NotNull PsiClass originalClass, @NotNull Collection<PsiClass> weakerClasses) {
            if (psiElement == null) {
                TypeMayBeWeakenedVisitor.$$$reportNull$$$0(0);
            }
            if (element == null) {
                TypeMayBeWeakenedVisitor.$$$reportNull$$$0(1);
            }
            if (originalClass == null) {
                TypeMayBeWeakenedVisitor.$$$reportNull$$$0(2);
            }
            if (weakerClasses == null) {
                TypeMayBeWeakenedVisitor.$$$reportNull$$$0(3);
            }
            ArrayList<Object> fixes = new ArrayList<Object>();
            for (PsiClass weakestClass : weakerClasses) {
                String className = TypeMayBeWeakenedInspection.getClassName(weakestClass);
                if (className == null) continue;
                fixes.add(new TypeMayBeWeakenedFix(className));
                List<String> candidates = TypeMayBeWeakenedInspection.getInheritors(originalClass, weakestClass);
                candidates.removeAll((Collection<?>)TypeMayBeWeakenedInspection.this.myStopClassSet);
                if (candidates.isEmpty() || !this.myIsOnTheFly && candidates.size() != 1) continue;
                fixes.add(new AddStopWordQuickfix(candidates));
            }
            this.myHolder.registerProblem(psiElement, this.getDescription(element, weakerClasses), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        @NotNull
        private String getDescription(@NotNull PsiElement element, @NotNull Collection<PsiClass> weakerClasses) {
            if (element == null) {
                TypeMayBeWeakenedVisitor.$$$reportNull$$$0(4);
            }
            if (weakerClasses == null) {
                TypeMayBeWeakenedVisitor.$$$reportNull$$$0(5);
            }
            StringBuilder builder = new StringBuilder();
            Iterator<PsiClass> iterator = weakerClasses.iterator();
            if (iterator.hasNext()) {
                builder.append('\'').append(TypeMayBeWeakenedInspection.getClassName(iterator.next())).append('\'');
                while (iterator.hasNext()) {
                    builder.append(", '").append(TypeMayBeWeakenedInspection.getClassName(iterator.next())).append('\'');
                }
            }
            if (element instanceof PsiField) {
                String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.field.problem.descriptor", builder.toString());
                if (string == null) {
                    TypeMayBeWeakenedVisitor.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (element instanceof PsiParameter) {
                String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.parameter.problem.descriptor", builder.toString());
                if (string == null) {
                    TypeMayBeWeakenedVisitor.$$$reportNull$$$0(7);
                }
                return string;
            }
            if (element instanceof PsiMethod) {
                String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.method.problem.descriptor", builder.toString());
                if (string == null) {
                    TypeMayBeWeakenedVisitor.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.problem.descriptor", builder.toString());
            if (string == null) {
                TypeMayBeWeakenedVisitor.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalClass";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "weakerClasses";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedVisitor";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "registerProblem";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TypeMayBeWeakenedFix
    implements LocalQuickFix {
        private final String fqClassName;

        TypeMayBeWeakenedFix(@NotNull String fqClassName) {
            if (fqClassName == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(0);
            }
            this.fqClassName = fqClassName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.quickfix", this.fqClassName);
            if (string == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.weaken.type.family", new Object[0]);
            if (string == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiTypeParameter[] typeParameters;
            PsiTypeElement typeElement;
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                TypeMayBeWeakenedFix.$$$reportNull$$$0(4);
            }
            if ((parent = (element = descriptor.getPsiElement()).getParent()) instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                typeElement = variable.getTypeElement();
            } else if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                typeElement = method.getReturnTypeElement();
            } else {
                return;
            }
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement componentReferenceElement = typeElement.getInnermostComponentReferenceElement();
            if (componentReferenceElement == null) {
                return;
            }
            PsiType oldType = typeElement.getType();
            if (!(oldType instanceof PsiClassType)) {
                return;
            }
            PsiClassType oldClassType = (PsiClassType)oldType;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiType type2 = factory.createTypeFromText(this.fqClassName, element);
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass != null && (typeParameters = aClass.getTypeParameters()).length != 0) {
                HashMap<PsiTypeParameter, PsiType> typeParameterMap = new HashMap<PsiTypeParameter, PsiType>();
                PsiClass newClass = classType.resolve();
                if (newClass == null) {
                    return;
                }
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiTypeParameter typeParameter = typeParameters[i];
                    PsiType parameterType = PsiUtil.substituteTypeParameter((PsiType)oldClassType, (PsiClass)newClass, (int)i, (boolean)false);
                    typeParameterMap.put(typeParameter, parameterType);
                }
                PsiSubstitutor substitutor = factory.createSubstitutor(typeParameterMap);
                classType = factory.createType(aClass, substitutor);
            }
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
            PsiElement replacement = componentReferenceElement.replace((PsiElement)referenceElement);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            javaCodeStyleManager.shortenClassReferences(replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqClassName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class AddStopWordQuickfix
    implements LowPriorityAction,
    LocalQuickFix {
        private final List<String> myCandidates;

        AddStopWordQuickfix(List<String> candidates) {
            this.myCandidates = candidates;
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myCandidates.size() == 1) {
                InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stopper.single", this.myCandidates.get(0));
            }
            String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stopper", new Object[0]);
            if (string == null) {
                AddStopWordQuickfix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.family", new Object[0]);
            if (string == null) {
                AddStopWordQuickfix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddStopWordQuickfix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddStopWordQuickfix.$$$reportNull$$$0(3);
            }
            if (this.myCandidates.size() == 1) {
                TypeMayBeWeakenedInspection.this.addClass(this.myCandidates.get(0), descriptor.getPsiElement());
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            String hint = InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stop.class.selection.popup", new Object[0]);
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(hint, this.myCandidates){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (descriptor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        TypeMayBeWeakenedInspection.this.addClass(selectedValue, descriptor.getPsiElement());
                    }, InspectionGadgetsBundle.message("inspection.type.may.be.weakened.add.stopper", new Object[0]), null);
                    return super.onChosen((Object)selectedValue, finalChoice);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$AddStopWordQuickfix$1", "lambda$onChosen$0"));
                }
            });
            popup.showInBestPositionFor(editor);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$AddStopWordQuickfix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$AddStopWordQuickfix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

