/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class TransientFieldInNonSerializableClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.display.name", new Object[0]);
        if (string == null) {
            TransientFieldInNonSerializableClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        String string = InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.problem.descriptor", field.getName());
        if (string == null) {
            TransientFieldInNonSerializableClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new TransientFieldInNonSerializableClassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TransientFieldInNonSerializableClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TransientFieldInNonSerializableClassVisitor
    extends BaseInspectionVisitor {
        private TransientFieldInNonSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                TransientFieldInNonSerializableClassVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerModifierError("transient", (PsiModifierListOwner)field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection$TransientFieldInNonSerializableClassVisitor", "visitField"));
        }
    }

    private static class TransientFieldInNonSerializableClassFix
    extends InspectionGadgetsFix {
        private TransientFieldInNonSerializableClassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.remove.quickfix", new Object[0]);
            if (string == null) {
                TransientFieldInNonSerializableClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement transientModifier = descriptor.getPsiElement();
            TransientFieldInNonSerializableClassFix.deleteElement(transientModifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection$TransientFieldInNonSerializableClassFix", "getFamilyName"));
        }
    }
}

