/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.shift;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.shift.ShiftByLiteralPredicate;
import com.siyeh.ipp.shift.ShiftUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceShiftWithMultiplyIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof PsiBinaryExpression) {
            PsiBinaryExpression exp = (PsiBinaryExpression)element;
            PsiJavaToken sign = exp.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            String operatorString = tokenType.equals(JavaTokenType.LTLT) ? "*" : "/";
            return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", sign.getText(), operatorString);
        }
        PsiAssignmentExpression exp = (PsiAssignmentExpression)element;
        PsiJavaToken sign = exp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        String assignString = JavaTokenType.LTLTEQ.equals(tokenType) ? "*=" : "/=";
        return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", sign.getText(), assignString);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ShiftByLiteralPredicate shiftByLiteralPredicate = new ShiftByLiteralPredicate();
        if (shiftByLiteralPredicate == null) {
            ReplaceShiftWithMultiplyIntention.$$$reportNull$$$0(0);
        }
        return shiftByLiteralPredicate;
    }

    @Override
    public void processIntention(PsiElement element) {
        if (element instanceof PsiBinaryExpression) {
            ReplaceShiftWithMultiplyIntention.replaceShiftWithMultiplyOrDivide(element);
        } else {
            ReplaceShiftWithMultiplyIntention.replaceShiftAssignWithMultiplyOrDivideAssign(element);
        }
    }

    private static void replaceShiftAssignWithMultiplyOrDivideAssign(PsiElement element) {
        PsiAssignmentExpression exp = (PsiAssignmentExpression)element;
        PsiExpression lhs = exp.getLExpression();
        PsiExpression rhs = exp.getRExpression();
        IElementType tokenType = exp.getOperationTokenType();
        String assignString = tokenType.equals(JavaTokenType.LTLTEQ) ? "*=" : "/=";
        CommentTracker commentTracker = new CommentTracker();
        String expString = commentTracker.text((PsiElement)lhs) + assignString + ShiftUtils.getExpBase2(rhs);
        PsiReplacementUtil.replaceExpression((PsiExpression)exp, expString, commentTracker);
    }

    private static void replaceShiftWithMultiplyOrDivide(PsiElement element) {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationTokenType();
        String operatorString = tokenType.equals(JavaTokenType.LTLT) ? "*" : "/";
        CommentTracker commentTracker = new CommentTracker();
        String lhsText = commentTracker.text(lhs, 5);
        String expString = lhsText + operatorString + ShiftUtils.getExpBase2(rhs);
        PsiElement parent = exp.getParent();
        if (parent instanceof PsiExpression && !(parent instanceof PsiParenthesizedExpression) && ParenthesesUtils.getPrecedence((PsiExpression)parent) < 5) {
            expString = '(' + expString + ')';
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)exp, expString, commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/shift/ReplaceShiftWithMultiplyIntention", "getElementPredicate"));
    }
}

