/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent;

import com.intellij.javaee.oss.admin.DeploymentStatusWrapper;
import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.AgentDeploymentCallback;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.SimpleAgentBase;
import com.intellij.javaee.oss.agent.SimpleAgentException;
import com.intellij.javaee.util.ILogger;
import com.intellij.javaee.weblogic.agent.WebLogicAgent9Extension;
import com.intellij.javaee.weblogic.agent.WebLogicAgent9ExtensionImpl;
import com.intellij.javaee.weblogic.agent.WebLogicAgentUtil;
import com.intellij.javaee.weblogic.agent.WebLogicTarget;
import com.intellij.javaee.weblogic.agent.WebLogicTargetType;
import com.intellij.javaee.weblogic.agent.version9.NewDeployerHelperWL9;
import com.intellij.javaee.weblogic.agent.version9.WeblogicJMXConnector;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.ClusterWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.ServerWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.ApplicationRuntimeWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.ComponentRuntimeWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.DeployerRuntimeWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.DeploymentTaskRuntimeWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.DomainRuntimeServiceWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.ServerRuntimeWL9MBean;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.JMException;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicAgent9
extends SimpleAgentBase {
    private static final String DEPLOY_SUCCESSFUL = "deploy Successful";
    private static final String REMOVE_SUCCESSFUL = "remove Successful";
    private static final String PROTOCOL = "t3";
    private static final String STAGING_MODE = "stage";
    private static final List<ModuleType> MODULE_TYPES = Arrays.asList(ModuleType.WAR, ModuleType.EAR, ModuleType.RAR, ModuleType.EJB, ModuleType.CAR);
    private static final List<DeploymentStatusWrapper> STATUS_BY_PRIORITY = Arrays.asList(DeploymentStatusWrapper.STATUS_DEPLOYED, DeploymentStatusWrapper.STATUS_NOT_DEPLOYED, DeploymentStatusWrapper.STATUS_FAILED);
    private boolean myDomainJmxConnected = false;
    private boolean myTypeBehaviorConnected = false;
    private WeblogicJMXConnector<DomainRuntimeServiceWL9MBean> myDomainServiceConnector = WeblogicJMXConnector.createDomainRuntimeConnector();
    private WebLogicTargetType myTargetType;
    private TargetTypeBehavior myTypeBehavior;
    private boolean myTestDomainOnly;
    private DomainRuntimeServiceWL9MBean myDomainRuntimeService;
    private NewDeployerHelperWL9 myDeployerHelperWL9;
    private WebLogicDeploymentManager myDeployManager = null;
    private boolean myConnectionInitialized = false;
    private final WebLogicAgent9ExtensionImpl myExtension = new WebLogicAgent9ExtensionImpl();

    public void init(String host, int port, String username, String password, ParametersMap initParameters, AgentCallback callback) {
        super.init(host, port, username, password, initParameters, callback);
        this.myTargetType = WebLogicTargetType.valueOf((String)((String)this.getInitParameters().get((Object)"target.type")));
        this.myTestDomainOnly = Boolean.valueOf((String)this.getInitParameters().get((Object)"test.domain.only"));
        this.myTypeBehavior = this.myTargetType == WebLogicTargetType.TYPE_SERVER ? new ServerTypeBehavior() : new ClusterTypeBehavior();
        this.myDomainServiceConnector = WeblogicJMXConnector.createDomainRuntimeConnector();
        this.myExtension.init(this);
    }

    protected boolean doConnect() throws IOException, SimpleAgentException, JMException {
        if (!this.initConnection()) {
            return false;
        }
        return this.myTestDomainOnly || this.getState() != null;
    }

    public void connectBean(WeblogicJMXConnector<?> connector) throws IOException {
        connector.connect(this.getHost(), this.getPort(), this.getUsername(), this.getPassword());
    }

    public DomainRuntimeServiceWL9MBean getDomainRuntimeService() {
        return this.myDomainRuntimeService;
    }

    public ILogger getAgentLog() {
        return super.getLog();
    }

    private boolean initConnection() throws SimpleAgentException, IOException, JMException {
        try {
            if (this.myConnectionInitialized) {
                return true;
            }
            if (!this.myDomainJmxConnected) {
                this.connectBean(this.myDomainServiceConnector);
                this.myDomainJmxConnected = true;
            }
            if (this.myDomainRuntimeService == null) {
                this.myDomainRuntimeService = this.myDomainServiceConnector.createRootMBean();
            }
            if (this.myTestDomainOnly) {
                return true;
            }
            if (!this.myTypeBehaviorConnected) {
                if (!this.myTypeBehavior.connect()) {
                    return false;
                }
                this.myTypeBehaviorConnected = true;
            }
            if (this.isRemote() && this.myDeployerHelperWL9 == null) {
                this.myDeployerHelperWL9 = new NewDeployerHelperWL9();
            }
            this.myConnectionInitialized = true;
            return true;
        }
        catch (SecurityException e) {
            throw new SimpleAgentException((Exception)e);
        }
    }

    private String getState() throws IOException, JMException {
        return this.myTypeBehavior.getState();
    }

    private boolean isRemote() {
        return !Boolean.parseBoolean((String)this.getInitParameters().get((Object)"is.local"));
    }

    public void destroy() {
        try {
            this.myDomainServiceConnector.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startDeploy(final String deploymentName, final File source, ParametersMap deployParameters, AgentDeploymentCallback callback) {
        new SimpleAgentBase.DeploymentJob(deploymentName, callback){

            protected Void doJob() throws IOException, JMException, SimpleAgentException {
                String sourcePath = source.getPath();
                if (WebLogicAgent9.this.isRemote()) {
                    sourcePath = WebLogicAgent9.this.myDeployerHelperWL9.uploadSource(WebLogicAgent9.this.getAdminUrl(), WebLogicAgent9.this.getUsername(), WebLogicAgent9.this.getPassword(), sourcePath, deploymentName);
                }
                DeploymentTaskRuntimeWL9MBean task = WebLogicAgent9.this.getDeployerRuntime().deploy(sourcePath, deploymentName, WebLogicAgent9.this.getTarget());
                task.waitFor();
                this.setDeploymentStatus(WebLogicAgent9.DEPLOY_SUCCESSFUL.equals(task.getStatus()) ? DeploymentStatusWrapper.STATUS_DEPLOYED : this.getFailStatus());
                return null;
            }

            protected DeploymentStatusWrapper getFailStatus() {
                return DeploymentStatusWrapper.STATUS_FAILED;
            }
        }.perform();
    }

    public String getAdminUrl() {
        return WebLogicAgentUtil.createAdminUrl((String)this.getHost(), (int)this.getPort());
    }

    public String getStagingDir() throws IOException, JMException {
        ServerWL9MBean server = this.myDomainRuntimeService.getDomainConfiguration().findServerByName((String)this.getInitParameters().get((Object)"server.name"));
        if (server != null && server.getStagingMode().equals(STAGING_MODE)) {
            return server.getStagingDir();
        }
        return null;
    }

    private WebLogicDeploymentManager getDeployManager() throws DeploymentManagerCreationException {
        if (this.myDeployManager == null) {
            this.myDeployManager = SessionHelper.getRemoteDeploymentManager((String)PROTOCOL, (String)this.getHost(), (String)Integer.toString(this.getPort()), (String)this.getUsername(), (String)this.getPassword());
        }
        return this.myDeployManager;
    }

    public void startUndeploy(final String deploymentName, AgentDeploymentCallback callback) {
        new SimpleAgentBase.DeploymentJob(deploymentName, callback){

            protected Void doJob() throws IOException, JMException, SimpleAgentException {
                if (!WebLogicAgent9.this.myTypeBehavior.isExist(deploymentName)) {
                    this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_NOT_DEPLOYED);
                    return null;
                }
                DeploymentTaskRuntimeWL9MBean task = WebLogicAgent9.this.getDeployerRuntime().remove(deploymentName, WebLogicAgent9.this.getTarget());
                task.waitFor();
                if (!WebLogicAgent9.REMOVE_SUCCESSFUL.equals(task.getStatus())) {
                    this.setDeploymentStatus(this.getFailStatus());
                    return null;
                }
                try {
                    WebLogicDeploymentManager myDeployManager = WebLogicAgent9.this.getDeployManager();
                    final HashSet<TargetModuleID> modulesToUndeploy = new HashSet<TargetModuleID>();
                    for (ModuleType moduleType : MODULE_TYPES) {
                        TargetModuleID[] ids = myDeployManager.getAvailableModules(moduleType, myDeployManager.getTargets());
                        if (ids == null) continue;
                        for (TargetModuleID nextTarget : ids) {
                            if (!deploymentName.equalsIgnoreCase(nextTarget.getModuleID())) continue;
                            modulesToUndeploy.add(nextTarget);
                        }
                    }
                    if (modulesToUndeploy.isEmpty()) {
                        this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_NOT_DEPLOYED);
                        return null;
                    }
                    for (TargetModuleID module : modulesToUndeploy.toArray(new TargetModuleID[0])) {
                        ProgressObject progress = myDeployManager.undeploy(new TargetModuleID[]{module});
                        progress.addProgressListener(new ProgressListener(){

                            public void handleProgressEvent(ProgressEvent event) {
                                TargetModuleID targetModuleID = event.getTargetModuleID();
                                if (modulesToUndeploy.contains(targetModuleID)) {
                                    if (event.getDeploymentStatus().isCompleted()) {
                                        modulesToUndeploy.remove(targetModuleID);
                                        if (modulesToUndeploy.isEmpty()) {
                                            this.setDeploymentStatus(DeploymentStatusWrapper.STATUS_NOT_DEPLOYED);
                                        }
                                    } else if (event.getDeploymentStatus().isFailed()) {
                                        this.setDeploymentStatus(this.getFailStatus());
                                    }
                                    this.getLog().debug(event.getDeploymentStatus().getMessage());
                                }
                            }
                        });
                    }
                }
                catch (TargetException e) {
                    throw new SimpleAgentException((Exception)((Object)e));
                }
                catch (DeploymentManagerCreationException e) {
                    throw new SimpleAgentException((Exception)((Object)e));
                }
                catch (IllegalStateException e) {
                    throw new SimpleAgentException((Exception)e);
                }
                return null;
            }

            protected DeploymentStatusWrapper getFailStatus() {
                return DeploymentStatusWrapper.STATUS_UNKNOWN;
            }
        }.perform();
    }

    public void updateDeploymentStatus(final String deploymentName, AgentDeploymentCallback callback) {
        new SimpleAgentBase.DeploymentJob(deploymentName, callback){

            protected Void doJob() throws IOException, JMException, SimpleAgentException {
                this.setDeploymentStatus(WebLogicAgent9.this.myTypeBehavior.getDeploymentStatus(deploymentName));
                return null;
            }

            protected DeploymentStatusWrapper getFailStatus() {
                return DeploymentStatusWrapper.STATUS_UNKNOWN;
            }
        }.perform();
    }

    private DeployerRuntimeWL9MBean getDeployerRuntime() throws IOException, JMException {
        return this.myDomainRuntimeService.getDomainRuntime().getDeployerRuntime();
    }

    private WebLogicTarget getTarget() {
        ParametersMap initParams = this.getInitParameters();
        return new WebLogicTarget(this.myTargetType, (String)initParams.get((Object)(this.myTargetType == WebLogicTargetType.TYPE_SERVER ? "server.name" : "cluster.name")));
    }

    private static DeploymentStatusWrapper doGetDeploymentStatusOnServer(String deploymentName, ServerRuntimeWL9MBean serverRuntime) throws IOException, JMException {
        ApplicationRuntimeWL9MBean applicationRuntime = serverRuntime.findApplicationRuntimeByName(deploymentName);
        if (applicationRuntime == null) {
            return DeploymentStatusWrapper.STATUS_NOT_DEPLOYED;
        }
        ComponentRuntimeWL9MBean[] componentRuntimes = applicationRuntime.getComponentRuntimes();
        if (componentRuntimes.length == 0) {
            return DeploymentStatusWrapper.STATUS_FAILED;
        }
        for (ComponentRuntimeWL9MBean componentRuntime : componentRuntimes) {
            if (componentRuntime.isWebAppComponent()) {
                String string = componentRuntime.getContextRoot();
            }
            if (componentRuntime.getDeploymentState() == 2) continue;
            return DeploymentStatusWrapper.STATUS_FAILED;
        }
        return DeploymentStatusWrapper.STATUS_DEPLOYED;
    }

    protected void doDeploy(String deploymentName, File source, ParametersMap deployParameters) throws IOException, JMException, SimpleAgentException {
        throw new UnsupportedOperationException();
    }

    protected void doUndeploy(String deploymentName) throws IOException, JMException, SimpleAgentException {
        throw new UnsupportedOperationException();
    }

    protected boolean doIsDeployed(String deploymentName) throws IOException, JMException, SimpleAgentException {
        throw new UnsupportedOperationException();
    }

    public WebLogicAgent9Extension getExtension() {
        return this.myExtension;
    }

    private class ClusterTypeBehavior
    implements TargetTypeBehavior {
        private static final String CLUSTER_STATE = "CONNECTED";
        private final List<ServerRuntimeWL9MBean> myServerRuntimes = new ArrayList<ServerRuntimeWL9MBean>();
        private ClusterWL9MBean myCluster;

        private ClusterTypeBehavior() {
        }

        public boolean connect() throws IOException, JMException {
            boolean hasRuntimes;
            if (this.myCluster == null) {
                this.myCluster = this.findCluster();
                if (this.myCluster == null) {
                    return false;
                }
            }
            for (ServerWL9MBean server : this.myCluster.getServers()) {
                ServerRuntimeWL9MBean serverRuntime = WebLogicAgent9.this.myDomainRuntimeService.findServerRuntimeByName(server.getName());
                if (serverRuntime == null) continue;
                this.myServerRuntimes.add(serverRuntime);
            }
            boolean bl = hasRuntimes = !this.myServerRuntimes.isEmpty();
            if (!hasRuntimes) {
                WebLogicAgent9.this.getLog().debug("No server runtimes found at the cluster");
            }
            return hasRuntimes;
        }

        private ClusterWL9MBean findCluster() throws IOException, JMException {
            String clusterName = (String)WebLogicAgent9.this.getInitParameters().get((Object)"cluster.name");
            for (ClusterWL9MBean cluster : WebLogicAgent9.this.myDomainRuntimeService.getDomainConfiguration().getClusters()) {
                if (!clusterName.equals(cluster.getName())) continue;
                return cluster;
            }
            WebLogicAgent9.this.getLog().debug("Cluster not found: " + clusterName);
            return null;
        }

        public boolean isExist(String deploymentName) throws IOException, JMException {
            for (ServerRuntimeWL9MBean serverRuntime : this.myServerRuntimes) {
                if (serverRuntime.findApplicationRuntimeByName(deploymentName) == null) continue;
                return true;
            }
            return false;
        }

        public String getState() {
            return CLUSTER_STATE;
        }

        public DeploymentStatusWrapper getDeploymentStatus(String deploymentName) throws IOException, JMException {
            DeploymentStatusWrapper result = DeploymentStatusWrapper.STATUS_DEPLOYED;
            for (ServerRuntimeWL9MBean serverRuntime : this.myServerRuntimes) {
                DeploymentStatusWrapper statusOnServer = WebLogicAgent9.doGetDeploymentStatusOnServer(deploymentName, serverRuntime);
                if (STATUS_BY_PRIORITY.indexOf(statusOnServer) <= STATUS_BY_PRIORITY.indexOf(result)) continue;
                result = statusOnServer;
            }
            return result;
        }
    }

    private class ServerTypeBehavior
    implements TargetTypeBehavior {
        private ServerRuntimeWL9MBean myServerRuntime;

        private ServerTypeBehavior() {
        }

        public boolean connect() throws IOException, JMException {
            boolean result;
            String serverName = (String)WebLogicAgent9.this.getInitParameters().get((Object)"server.name");
            this.myServerRuntime = WebLogicAgent9.this.myDomainRuntimeService.findServerRuntimeByName(serverName);
            boolean bl = result = this.myServerRuntime != null;
            if (!result) {
                WebLogicAgent9.this.getLog().debug("Server not found: " + serverName);
            }
            return result;
        }

        public boolean isExist(String deploymentName) throws IOException, JMException {
            return this.myServerRuntime.findApplicationRuntimeByName(deploymentName) != null;
        }

        public String getState() throws IOException, JMException {
            return this.myServerRuntime.getState();
        }

        public DeploymentStatusWrapper getDeploymentStatus(String deploymentName) throws IOException, JMException {
            return WebLogicAgent9.doGetDeploymentStatusOnServer(deploymentName, this.myServerRuntime);
        }
    }

    private static interface TargetTypeBehavior {
        public boolean isExist(String var1) throws IOException, JMException;

        public String getState() throws IOException, JMException;

        public boolean connect() throws IOException, JMException;

        public DeploymentStatusWrapper getDeploymentStatus(String var1) throws IOException, JMException;
    }
}

