/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringLocalModelDependencyEdge
extends DiagramEdgeBase<LocalModelGraphElementWrapper> {
    @NotNull
    private final LocalModelDependency myDependency;
    private boolean myError;

    public boolean isError() {
        return this.myError;
    }

    public void setError(boolean isError) {
        this.myError = isError;
    }

    public SpringLocalModelDependencyEdge(DiagramNode<LocalModelGraphElementWrapper> source, DiagramNode<LocalModelGraphElementWrapper> target, @NotNull LocalModelDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/spring/contexts/model/diagram/beans/SpringLocalModelDependencyEdge", "<init>"));
        }
        this(source, target, dependency, null);
    }

    public SpringLocalModelDependencyEdge(DiagramNode<LocalModelGraphElementWrapper> source, DiagramNode<LocalModelGraphElementWrapper> target, @NotNull LocalModelDependency dependency, @Nullable String label) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/spring/contexts/model/diagram/beans/SpringLocalModelDependencyEdge", "<init>"));
        }
        super(source, target, SpringLocalModelDependencyEdge.getInfo(dependency, label));
        this.myDependency = dependency;
    }

    @NotNull
    public LocalModelDependency getDependency() {
        LocalModelDependency localModelDependency = this.myDependency;
        if (localModelDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/beans/SpringLocalModelDependencyEdge", "getDependency"));
        }
        return localModelDependency;
    }

    private static DiagramRelationshipInfo getInfo(LocalModelDependency type, @Nullable String label) {
        String name = SpringLocalModelDependencyEdge.getRelationshipName(type.getType());
        return new DiagramRelationshipInfoAdapter(name, SpringLocalModelDependencyEdge.getLineType(type.getType()), label == null ? name : label){

            public Shape getStartArrow() {
                return STANDARD;
            }
        };
    }

    private static DiagramLineType getLineType(LocalModelDependencyType type) {
        switch (type) {
            case COMPONENT_SCAN: 
            case ENABLE_ANNO: {
                return DiagramLineType.SOLID;
            }
            case IMPORT: {
                return DiagramLineType.DASHED;
            }
        }
        return DiagramLineType.DOTTED;
    }

    private static String getRelationshipName(LocalModelDependencyType type) {
        return "";
    }

    public String getName() {
        return StringUtil.escapeXml((String)this.myDependency.getLabel());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringLocalModelDependencyEdge)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpringLocalModelDependencyEdge that = (SpringLocalModelDependencyEdge)((Object)o);
        return this.myDependency == that.myDependency;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myDependency.hashCode();
        return result;
    }
}

