/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.extensions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.el.extensions.SpringELAliasedAttributeInjectionContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringELEventListenerContextVariables
extends SpringElContextsExtension {
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getContextVariables"));
        }
        PsiElement element = context.getContext();
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getContextVariables"));
            }
            return list;
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
        if (annotation == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getContextVariables"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
        if (!SpringLibraryUtil.hasSpringLibrary((Module)module)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getContextVariables"));
            }
            return list;
        }
        String annoFqn = annotation.getQualifiedName();
        if (annoFqn == null || !"org.springframework.context.event.EventListener".equals(annoFqn) && !SpringELAliasedAttributeInjectionContext.isCustomAnnotation(module, annoFqn, "org.springframework.context.event.EventListener")) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getContextVariables"));
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
        if (method != null) {
            ContainerUtil.addIfNotNull((Collection)variables, (Object)SpringELEventListenerContextVariables.getEventExpressionRootObject(method));
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length == 1) {
                variables.add(parameters[0]);
            }
        }
        List list = variables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getContextVariables"));
        }
        return list;
    }

    private static PsiVariable getEventExpressionRootObject(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getEventExpressionRootObject"));
        }
        Project project = method.getProject();
        return (PsiVariable)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "lambda$getEventExpressionRootObject$0"));
            }
            PsiClass rootObjectClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.context.event.EventExpressionRootObject", GlobalSearchScope.allScope((Project)project));
            if (rootObjectClass == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiClassType type = PsiTypesUtil.getClassType((PsiClass)(parameters.length != 1 ? rootObjectClass : SpringELEventListenerContextVariables.getRootObjectDelegateClass(rootObjectClass, parameters[0])));
            return CachedValueProvider.Result.create((Object)new LightVariableBuilder("root", (PsiType)type, (PsiElement)rootObjectClass), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    @NotNull
    private static PsiClass getRootObjectDelegateClass(final @NotNull PsiClass rootObjectClass, final @NotNull PsiParameter parameter) {
        if (rootObjectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootObjectClass", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getRootObjectDelegateClass"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getRootObjectDelegateClass"));
        }
        LightClass lightClass = new LightClass(rootObjectClass){

            @NotNull
            public PsiMethod[] getMethods() {
                HashSet methods = ContainerUtil.newHashSet();
                for (PsiMethod method : super.getMethods()) {
                    if (method.getName().equals("getEvent")) {
                        methods.add(new LightMethod(this.getManager(), method, rootObjectClass){

                            public PsiType getReturnType() {
                                return parameter.getType();
                            }
                        });
                        continue;
                    }
                    methods.add(method);
                }
                PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
                if (psiMethodArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables$1", "getMethods"));
                }
                return psiMethodArray;
            }
        };
        if (lightClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/extensions/SpringELEventListenerContextVariables", "getRootObjectDelegateClass"));
        }
        return lightClass;
    }
}

