/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFileSetServiceImpl
extends SpringFileSetService {
    @NonNls
    private static final String ID_PREFIX = "fileset";
    @NonNls
    private static final String DEPENDENCY_DELIMITER = "==";
    private static final Function<SpringFileSet, String> FILESET_ID = SpringFileSet::getId;

    public String getUniqueId(Set<SpringFileSet> existing) {
        return UniqueNameGenerator.generateUniqueName((String)ID_PREFIX, (Collection)ContainerUtil.map(existing, FILESET_ID));
    }

    public String getUniqueName(String prefix, Set<SpringFileSet> existing) {
        UniqueNameGenerator generator = new UniqueNameGenerator(existing, SpringFileSet::getName);
        return generator.generateUniqueName(prefix, "", "", " (", ")");
    }

    @NotNull
    public Set<SpringFileSet> getAllSets(@NotNull SpringFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/facet/SpringFileSetServiceImpl", "getAllSets"));
        }
        Set<SpringFileSet> fileSets = SpringFileSetServiceImpl.getFileSets(facet);
        Set existing = ContainerUtil.map2Set(fileSets, FILESET_ID);
        for (SpringFileSet provided : this.getModelProviderSets(facet)) {
            if (existing.contains(provided.getId())) continue;
            fileSets.add(provided);
        }
        Set<SpringFileSet> set = fileSets;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSetServiceImpl", "getAllSets"));
        }
        return set;
    }

    @NotNull
    public List<SpringFileSet> getModelProviderSets(@NotNull SpringFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/facet/SpringFileSetServiceImpl", "getModelProviderSets"));
        }
        if (facet.getModule().isDisposed() || DumbService.isDumb((Project)facet.getModule().getProject())) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSetServiceImpl", "getModelProviderSets"));
            }
            return list;
        }
        SmartList result = new SmartList();
        for (SpringModelProvider modelProvider : (SpringModelProvider[])Extensions.getExtensions((ExtensionPointName)SpringModelProvider.EP_NAME)) {
            List modelProviderFilesets = modelProvider.getFilesets(facet);
            result.addAll(modelProviderFilesets);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSetServiceImpl", "getModelProviderSets"));
        }
        return smartList;
    }

    @Nullable
    public SpringFileSet findFileSet(Module module, PsiFile psiFile) {
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        for (SpringFileSet fileSet : this.getAllSets(springFacet)) {
            if (!fileSet.hasFile(virtualFile)) continue;
            return fileSet;
        }
        for (SpringModel model : SpringManager.getInstance((Project)module.getProject()).getAllModels(module)) {
            if (model.getFileSet() == null) {
                return null;
            }
            if (!model.hasConfigFile(psiFile)) continue;
            return model.getFileSet();
        }
        return null;
    }

    String getQualifiedName(@NotNull SpringFileSet fileset) {
        if (fileset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_PREFIX, "com/intellij/spring/facet/SpringFileSetServiceImpl", "getQualifiedName"));
        }
        return fileset.getId() + DEPENDENCY_DELIMITER + fileset.getFacet().getModule().getName();
    }

    String getDependencyIdFor(SpringFileSet current, SpringFileSet otherFileSet) {
        boolean isCurrentModule = current.getFacet().getModule().equals(otherFileSet.getFacet().getModule());
        if (isCurrentModule) {
            return otherFileSet.getId();
        }
        return this.getQualifiedName(otherFileSet);
    }

    @Nullable
    SpringFileSet findDependencyFileSet(SpringFileSet current, @NotNull String dependencyId) {
        if (dependencyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyId", "com/intellij/spring/facet/SpringFileSetServiceImpl", "findDependencyFileSet"));
        }
        SpringFacet facetToSearch = SpringFileSetServiceImpl.getSpringFacetFor(current, dependencyId);
        if (facetToSearch == null) {
            return null;
        }
        Condition fileSetCondition = springFileSet -> {
            if (dependencyId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyId", "com/intellij/spring/facet/SpringFileSetServiceImpl", "lambda$findDependencyFileSet$0"));
            }
            return this.getDependencyIdFor(current, (SpringFileSet)springFileSet).equals(dependencyId);
        };
        SpringFileSet fileSet = (SpringFileSet)ContainerUtil.find(SpringFileSetServiceImpl.getFileSets(facetToSearch), (Condition)fileSetCondition);
        if (fileSet != null) {
            return fileSet;
        }
        return (SpringFileSet)ContainerUtil.find(this.getModelProviderSets(facetToSearch), (Condition)fileSetCondition);
    }

    private static Set<SpringFileSet> getFileSets(SpringFacet facet) {
        return new LinkedHashSet<SpringFileSet>(facet.getFileSets());
    }

    @Nullable
    private static SpringFacet getSpringFacetFor(SpringFileSet current, @NotNull String dependencyId) {
        if (dependencyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyId", "com/intellij/spring/facet/SpringFileSetServiceImpl", "getSpringFacetFor"));
        }
        if (!dependencyId.contains(DEPENDENCY_DELIMITER)) {
            return current.getFacet();
        }
        String moduleName = StringUtil.substringAfter((String)dependencyId, (String)DEPENDENCY_DELIMITER);
        assert (moduleName != null) : dependencyId;
        Module moduleByName = ModuleManager.getInstance((Project)current.getFacet().getModule().getProject()).findModuleByName(moduleName);
        return moduleByName == null ? null : SpringFacet.getInstance((Module)moduleByName);
    }
}

