/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.facet.Facet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.gutter.SpringClassAnnotator;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/gutter/SpringClassFilesetLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "createNavigationHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "facet", "Lcom/intellij/spring/facet/SpringFacet;", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getLineMarkerInfo", "element", "getName", "spring-core"})
public final class SpringClassFilesetLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getId() {
        return "SpringClassFilesetLineMarkerProvider";
    }

    @Nullable
    public String getName() {
        return "Fileset Configuration";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.FileSet;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<LineMarkerInfo<?>> result) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringCommonUtils.hasSpringFacets((Project)psiElement.getProject())) {
            return;
        }
        for (PsiElement psiElement2 : elements) {
            UClass uClass;
            if ((UClass)UastContextKt.toUElement((PsiElement)psiElement2, UClass.class) == null) {
                continue;
            }
            if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)((PsiClass)uClass))) continue;
            PsiFile psiFile = psiElement2.getContainingFile();
            if (psiFile == null) {
                return;
            }
            PsiFile psiFile2 = psiFile;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
            if (module == null) {
                return;
            }
            Module module2 = module;
            SpringFileSet springFileSet = SpringClassAnnotator.getFileset(psiFile2, module2);
            if (springFileSet == null) {
                return;
            }
            SpringFileSet filesetResult = springFileSet;
            PsiIdentifier psiIdentifier = uClass.getNameIdentifier();
            if (psiIdentifier == null) {
                return;
            }
            PsiIdentifier nameIdentifier = psiIdentifier;
            PsiElement psiElement3 = (PsiElement)nameIdentifier;
            TextRange textRange = nameIdentifier.getTextRange();
            Function function = (Function)new ConstantFunction((Object)SpringBundle.message("navigate.to.fileset.configuration", new Object[0]));
            SpringFacet springFacet = filesetResult.getFacet();
            Intrinsics.checkExpressionValueIsNotNull((Object)springFacet, (String)"filesetResult.facet");
            result.add(new LineMarkerInfo(psiElement3, textRange, SpringApiIcons.SpringJavaConfig, 11, function, this.createNavigationHandler(springFacet), GutterIconRenderer.Alignment.CENTER));
            return;
        }
    }

    private final GutterIconNavigationHandler<PsiElement> createNavigationHandler(SpringFacet facet) {
        return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(facet){
            final /* synthetic */ SpringFacet $facet;

            public final void navigate(MouseEvent e, PsiElement elt) {
                ModulesConfigurator.showFacetSettingsDialog((Facet)((Facet)this.$facet), null);
            }
            {
                this.$facet = springFacet;
            }
        };
    }
}

