/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.index;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringCustomNamespaces;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.factories.SpringFactoryBeansManagerImpl;
import com.intellij.spring.index.SpringBeanIndexType;
import com.intellij.spring.index.SpringIndexUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SpringXmlBeansIndex
extends FileBasedIndexExtension<Pair<SpringBeanIndexType, String>, TIntArrayList>
implements PsiDependentIndex {
    private static final int INDEX_VERSION = 27;
    public static final ID<Pair<SpringBeanIndexType, String>, TIntArrayList> NAME = ID.create((String)"SpringXmlBeansIndex");
    private final DataIndexer<Pair<SpringBeanIndexType, String>, TIntArrayList, FileContent> myIndexer = SpringIndexUtil::indexFile;
    private final DataExternalizer<TIntArrayList> myValueExternalizer = new DataExternalizer<TIntArrayList>(){

        public void save(@NotNull DataOutput out, TIntArrayList values) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/spring/index/SpringXmlBeansIndex$1", "save"));
            }
            int size = values.size();
            if (size == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-values.getQuick(0)));
                return;
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
            for (int i = 0; i < size; ++i) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)values.getQuick(i));
            }
        }

        public TIntArrayList read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/spring/index/SpringXmlBeansIndex$1", "read"));
            }
            int countOrSingleValue = DataInputOutputUtil.readINT((DataInput)in);
            if (countOrSingleValue < 0) {
                TIntArrayList result = new TIntArrayList(1);
                result.add(-countOrSingleValue);
                return result;
            }
            TIntArrayList result = new TIntArrayList(countOrSingleValue);
            for (int i = 0; i < countOrSingleValue; ++i) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }
    };

    @NotNull
    public ID<Pair<SpringBeanIndexType, String>, TIntArrayList> getName() {
        ID<Pair<SpringBeanIndexType, String>, TIntArrayList> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/index/SpringXmlBeansIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Pair<SpringBeanIndexType, String>, TIntArrayList, FileContent> getIndexer() {
        DataIndexer<Pair<SpringBeanIndexType, String>, TIntArrayList, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/index/SpringXmlBeansIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Pair<SpringBeanIndexType, String>> getKeyDescriptor() {
        KeyDescriptor<Pair<SpringBeanIndexType, String>> keyDescriptor = new KeyDescriptor<Pair<SpringBeanIndexType, String>>(){

            public void save(@NotNull DataOutput out, Pair<SpringBeanIndexType, String> pair) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/spring/index/SpringXmlBeansIndex$2", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((SpringBeanIndexType)((Object)pair.first)).ordinal());
                if (((SpringBeanIndexType)((Object)pair.first)).key() == null) {
                    IOUtil.writeUTF((DataOutput)out, (String)((String)pair.second));
                }
            }

            public Pair<SpringBeanIndexType, String> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/spring/index/SpringXmlBeansIndex$2", "read"));
                }
                SpringBeanIndexType type = SpringBeanIndexType.values()[DataInputOutputUtil.readINT((DataInput)in)];
                if (type.key() != null) {
                    return type.key();
                }
                String value = IOUtil.readUTF((DataInput)in);
                return Pair.create((Object)((Object)type), (Object)value);
            }

            public int getHashCode(Pair<SpringBeanIndexType, String> value) {
                SpringBeanIndexType indexType = (SpringBeanIndexType)((Object)value.first);
                String fqn = (String)value.second;
                return 31 * indexType.ordinal() + (fqn != null ? fqn.hashCode() : 0);
            }

            public boolean isEqual(Pair<SpringBeanIndexType, String> val1, Pair<SpringBeanIndexType, String> val2) {
                if (((SpringBeanIndexType)((Object)val1.first)).ordinal() != ((SpringBeanIndexType)((Object)val2.first)).ordinal()) {
                    return false;
                }
                if (((SpringBeanIndexType)((Object)val1.first)).key() != null) {
                    return true;
                }
                return Comparing.equal((String)((String)val1.second), (String)((String)val2.second));
            }
        };
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/index/SpringXmlBeansIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        DataExternalizer<TIntArrayList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/index/SpringXmlBeansIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/index/SpringXmlBeansIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        int customNamespacesVersion = 0;
        for (SpringCustomNamespaces customNamespaces : (SpringCustomNamespaces[])Extensions.getExtensions((ExtensionPointName)SpringCustomNamespaces.EP_NAME)) {
            customNamespacesVersion += customNamespaces.getModelVersion();
            customNamespacesVersion += customNamespaces.getClass().getName().length();
        }
        int factoryBeansManagerVersion = ((SpringFactoryBeansManagerImpl)SpringFactoryBeansManager.getInstance()).getIndexingVersion();
        return 27 + customNamespacesVersion + factoryBeansManagerVersion;
    }

    public static boolean processBeansByClass(SpringBeanSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)params.getPsiType());
        if (psiClass == null) {
            return true;
        }
        String psiClassFqn = (String)ObjectUtils.assertNotNull((Object)psiClass.getQualifiedName());
        boolean byBeanClass = SpringXmlBeansIndex.processSpringBeanPointer((Pair<SpringBeanIndexType, String>)Pair.create((Object)((Object)SpringBeanIndexType.BEAN_CLASS), (Object)psiClassFqn), params, processor);
        if (!byBeanClass) {
            return false;
        }
        SmartList beanTypeProviderBeans = new SmartList();
        SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.BEAN_TYPE_PROVIDER.key(), params, (Processor<SpringBeanPointer>)new CommonProcessors.CollectProcessor((Collection)beanTypeProviderBeans));
        if (beanTypeProviderBeans.isEmpty()) {
            return true;
        }
        return ContainerUtil.process((List)beanTypeProviderBeans, pointer -> {
            if (!Comparing.equal((Object)psiClass, (Object)pointer.getBeanClass())) {
                return true;
            }
            return processor.process(pointer);
        });
    }

    public static boolean processBeansByName(SpringBeanSearchParameters.BeanName params, Processor<SpringBeanPointer> processor) {
        String beanName = params.getBeanName();
        boolean processByName = SpringXmlBeansIndex.processSpringBeanPointer((Pair<SpringBeanIndexType, String>)Pair.create((Object)((Object)SpringBeanIndexType.BEAN_NAME), (Object)beanName), params, processor);
        if (!processByName) {
            return false;
        }
        SmartList beanNameProviderBeans = new SmartList();
        SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.BEAN_NAME_PROVIDER.key(), params, (Processor<SpringBeanPointer>)new CommonProcessors.CollectProcessor((Collection)beanNameProviderBeans));
        if (beanNameProviderBeans.isEmpty()) {
            return true;
        }
        return ContainerUtil.process((List)beanNameProviderBeans, pointer -> {
            if (!Comparing.equal((String)beanName, (String)pointer.getName())) {
                return true;
            }
            return processor.process(pointer);
        });
    }

    public static boolean processComponentScans(SpringBeanSearchParameters.BeanName params, Processor<SpringBeanPointer> processor) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.COMPONENT_SCAN.key(), params, processor);
    }

    public static boolean processFactoryBeans(SpringBeanSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.FACTORY_BEAN.key(), params, processor);
    }

    public static boolean processFactoryBeanClasses(SpringBeanSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.FACTORY_BEAN_CLASS.key(), params, processor);
    }

    public static boolean processFactoryMethods(SpringBeanSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.FACTORY_METHOD.key(), params, processor);
    }

    public static boolean processAbstractBeans(SpringBeanSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor) {
        SmartList abstractBeans = new SmartList();
        SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.ABSTRACT_BEAN.key(), params, (Processor<SpringBeanPointer>)new CommonProcessors.CollectProcessor((Collection)abstractBeans));
        return ContainerUtil.process((List)abstractBeans, processor);
    }

    public static boolean processAliases(SpringBeanSearchParameters.BeanName params, final Processor<Alias> processor) {
        Pair key = Pair.create((Object)((Object)SpringBeanIndexType.ALIAS), (Object)params.getBeanName());
        MultiMap<VirtualFile, TIntArrayList> results = SpringXmlBeansIndex.getResults((Pair<SpringBeanIndexType, String>)key, params);
        if (results.isEmpty()) {
            return true;
        }
        DomElementProcessor domElementProcessor = new DomElementProcessor(){

            @Override
            protected boolean processDomElement(@NotNull DomElement domElement) {
                if (domElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/index/SpringXmlBeansIndex$3", "processDomElement"));
                }
                return !(domElement instanceof Alias) || processor.process((Object)((Alias)domElement));
            }
        };
        return SpringXmlBeansIndex.processDomElements(params.getProject(), results, domElementProcessor);
    }

    public static boolean processCustomBeans(SpringBeanSearchParameters params, final Processor<CustomBeanWrapper> processor) {
        Pair<SpringBeanIndexType, String> key = SpringBeanIndexType.CUSTOM_BEAN_WRAPPER.key();
        MultiMap<VirtualFile, TIntArrayList> results = SpringXmlBeansIndex.getResults(key, params);
        if (results.isEmpty()) {
            return true;
        }
        DomElementProcessor domElementProcessor = new DomElementProcessor(){

            @Override
            protected boolean processDomElement(@NotNull DomElement domElement) {
                if (domElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/index/SpringXmlBeansIndex$4", "processDomElement"));
                }
                return !(domElement instanceof CustomBeanWrapper) || processor.process((Object)((CustomBeanWrapper)domElement));
            }
        };
        return SpringXmlBeansIndex.processDomElements(params.getProject(), results, domElementProcessor);
    }

    private static boolean processSpringBeanPointer(@NotNull Pair<SpringBeanIndexType, String> key, @NotNull SpringBeanSearchParameters params, final @NotNull Processor<SpringBeanPointer> processor) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/index/SpringXmlBeansIndex", "processSpringBeanPointer"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/index/SpringXmlBeansIndex", "processSpringBeanPointer"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/index/SpringXmlBeansIndex", "processSpringBeanPointer"));
        }
        MultiMap<VirtualFile, TIntArrayList> results = SpringXmlBeansIndex.getResults(key, params);
        if (results.isEmpty()) {
            return true;
        }
        DomElementProcessor domElementProcessor = new DomElementProcessor(){

            @Override
            protected boolean processDomElement(@NotNull DomElement domElement) {
                SpringBeanPointer pointer;
                if (domElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/index/SpringXmlBeansIndex$5", "processDomElement"));
                }
                return !(domElement instanceof DomSpringBean) || processor.process((Object)(pointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)((DomSpringBean)domElement))));
            }
        };
        return SpringXmlBeansIndex.processDomElements(params.getProject(), results, domElementProcessor);
    }

    @NotNull
    private static MultiMap<VirtualFile, TIntArrayList> getResults(@NotNull Pair<SpringBeanIndexType, String> key, @NotNull SpringBeanSearchParameters params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/index/SpringXmlBeansIndex", "getResults"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/index/SpringXmlBeansIndex", "getResults"));
        }
        MultiMap results = new MultiMap();
        FileBasedIndex.getInstance().processValues(NAME, key, params.getVirtualFile(), (file, value) -> {
            results.putValue((Object)file, value);
            return true;
        }, params.getSearchScope());
        MultiMap multiMap = results;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/index/SpringXmlBeansIndex", "getResults"));
        }
        return multiMap;
    }

    private static boolean processDomElements(@NotNull Project project, @NotNull MultiMap<VirtualFile, TIntArrayList> indexMap, @NotNull DomElementProcessor processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/index/SpringXmlBeansIndex", "processDomElements"));
        }
        if (indexMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexMap", "com/intellij/spring/index/SpringXmlBeansIndex", "processDomElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/index/SpringXmlBeansIndex", "processDomElements"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        DomManager domManager = DomManager.getDomManager((Project)project);
        for (Map.Entry entry : indexMap.entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof XmlFile)) continue;
            TIntProcedure procedure = value -> {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/index/SpringXmlBeansIndex", "lambda$processDomElements$3"));
                }
                PsiElement psiElement = psiFile.findElementAt(value);
                XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
                DomElement domElement = domManager.getDomElement(xmlTag);
                if (domElement == null) {
                    return true;
                }
                return processor.processDomElement(domElement);
            };
            for (TIntArrayList values : (Collection)entry.getValue()) {
                if (values.forEach(procedure)) continue;
                return false;
            }
        }
        return true;
    }

    private static abstract class DomElementProcessor {
        private DomElementProcessor() {
        }

        protected abstract boolean processDomElement(@NotNull DomElement var1);
    }
}

