/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.annotator;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroups;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.SpringJamCustomCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheEvict;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePut;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheable;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheableAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<SpringJamCacheableElement, Collection<? extends PsiElement>> CACHEABLE_CONVERTOR = cacheableElement -> ContainerUtil.createMaybeSingletonList(cacheableElement.getPsiElement());

    public String getId() {
        return "SpringCacheableAnnotator";
    }

    public String getName() {
        return "Cacheable operations with the same names";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.ShowCacheable;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringCommonUtils.hasSpringFacets((Project)psiElement.getProject()) || !SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiMethod psiMethod;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "collectNavigationMarkers"));
        }
        if (!(psiElement instanceof PsiAnnotation)) {
            return;
        }
        PsiMember element = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class);
        if (!(element instanceof PsiMethod) && !(element instanceof PsiClass)) {
            return;
        }
        if (element instanceof PsiMethod && (!(psiMethod = (PsiMethod)element).hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (!SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_4_2)) {
            return;
        }
        List cacheableElements = SemService.getSemService((Project)psiElement.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)element);
        if (cacheableElements.size() == 0 || SpringCacheableAnnotator.hasCustomCacheResolver(module)) {
            return;
        }
        for (SpringJamCacheableElement cacheableElement : cacheableElements) {
            if (!psiElement.equals(cacheableElement.getAnnotation())) continue;
            SpringCacheableAnnotator.doAnnotateCacheable(result, cacheableElement);
        }
        if (element instanceof PsiClass) {
            SpringCacheableAnnotator.annotateCachingGroup((PsiElement)element, result);
        }
    }

    private static void annotateCachingGroup(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "annotateCachingGroup"));
        }
        SpringCachingGroups cachingGroups = (SpringCachingGroups)JamService.getJamService((Project)psiElement.getProject()).getJamElement(psiElement, new JamMemberMeta[]{SpringCachingGroups.META});
        if (cachingGroups != null) {
            for (SpringJamCacheable springJamCacheable : cachingGroups.getCacheables()) {
                SpringCacheableAnnotator.doAnnotateCacheable(result, springJamCacheable);
            }
            for (SpringJamCachePut springJamCachePut : cachingGroups.getCachePuts()) {
                SpringCacheableAnnotator.doAnnotateCacheable(result, springJamCachePut);
            }
            for (SpringJamCacheEvict springJamCacheEvict : cachingGroups.getCacheEvict()) {
                SpringCacheableAnnotator.doAnnotateCacheable(result, springJamCacheEvict);
            }
        }
    }

    private static void doAnnotateCacheable(Collection<? super RelatedItemLineMarkerInfo> result, SpringJamCacheableElement cacheableElement) {
        Set<SpringJamCacheableElement> cacheableElements;
        PsiAnnotation psiAnnotation = cacheableElement.getAnnotation();
        if (psiAnnotation != null && (cacheableElements = SpringCacheableAnnotator.findCacheableWithTheSameName(cacheableElement)).size() > 0) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.ShowCacheable, CACHEABLE_CONVERTOR).setTargets(cacheableElements).setPopupTitle(SpringBundle.message("spring.cacheable.element.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.cacheable.element.tooltip.text", new Object[0]));
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiAnnotation));
        }
    }

    private static boolean hasCustomCacheResolver(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "hasCustomCacheResolver"));
        }
        PsiClass cacheResolver = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.cache.interceptor.CacheResolver");
        if (cacheResolver == null) {
            return true;
        }
        SpringModel combinedModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        return SpringModelSearchers.doesBeanExist((CommonSpringModel)combinedModel, (PsiClass)cacheResolver);
    }

    private static Set<SpringJamCacheableElement> findCacheableWithTheSameName(@NotNull SpringJamCacheableElement cacheableElement) {
        if (cacheableElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheableElement", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "findCacheableWithTheSameName"));
        }
        Object psiElement = cacheableElement.getPsiElement();
        JamService service = JamService.getJamService((Project)psiElement.getProject());
        HashSet cacheableElements = ContainerUtil.newHashSet();
        Set<String> cacheNames = cacheableElement.getCacheNames();
        if (cacheNames.isEmpty()) {
            cacheNames = SpringCacheableAnnotator.getDefaultCacheNames(cacheableElement.getPsiElement());
        }
        if (!cacheNames.isEmpty()) {
            Set<SpringJamCacheableElement> allCacheable = SpringCacheableAnnotator.findAllCacheable(service, ModuleUtilCore.findModuleForPsiElement(psiElement));
            for (SpringJamCacheableElement element : allCacheable) {
                if (element.equals(cacheableElement)) continue;
                Set<String> names = element.getCacheNames();
                if (names.isEmpty()) {
                    names = SpringCacheableAnnotator.getDefaultCacheNames(element.getPsiElement());
                }
                if (!SpringCacheableAnnotator.hasSameNames(names, cacheNames)) continue;
                cacheableElements.add(element);
            }
        }
        return cacheableElements;
    }

    @NotNull
    private static Set<String> getDefaultCacheNames(@NotNull PsiMember psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "getDefaultCacheNames"));
        }
        if (!psiElement.isValid()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "getDefaultCacheNames"));
            }
            return set;
        }
        PsiClass aClass = psiElement.getContainingClass();
        if (aClass != null) {
            SemService service = SemService.getSemService((Project)aClass.getProject());
            SpringJamCacheConfig cacheConfig = (SpringJamCacheConfig)service.getSemElement(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, (PsiElement)aClass);
            if (cacheConfig != null) {
                Set<String> set = cacheConfig.getCacheNames();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "getDefaultCacheNames"));
                }
                return set;
            }
            SpringJamCustomCacheConfig customCacheConfig = (SpringJamCustomCacheConfig)service.getSemElement(SpringJamCustomCacheConfig.JAM_KEY, (PsiElement)aClass);
            if (customCacheConfig != null) {
                Set<String> set = customCacheConfig.getCacheNames();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "getDefaultCacheNames"));
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "getDefaultCacheNames"));
        }
        return set;
    }

    private static boolean hasSameNames(Set<String> names1, Set<String> names2) {
        for (String name1 : names1) {
            for (String name2 : names2) {
                if (!name1.equals(name2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Set<SpringJamCacheableElement> findAllCacheable(JamService service, @Nullable Module module) {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        if (module != null) {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            result.addAll(service.getJamMethodElements(SpringJamCacheable.CACHEABLE_JAM_KEY, "org.springframework.cache.annotation.Cacheable", scope));
            result.addAll(service.getJamMethodElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, "org.springframework.cache.annotation.CachePut", scope));
            result.addAll(service.getJamMethodElements(SpringJamCacheEvict.CACHE_EVICT_JAM_KEY, "org.springframework.cache.annotation.CacheEvict", scope));
            result.addAll(service.getJamClassElements(SpringJamCacheable.CACHEABLE_JAM_KEY, "org.springframework.cache.annotation.Cacheable", scope));
            result.addAll(service.getJamClassElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, "org.springframework.cache.annotation.CachePut", scope));
            result.addAll(service.getJamClassElements(SpringJamCacheEvict.CACHE_EVICT_JAM_KEY, "org.springframework.cache.annotation.CacheEvict", scope));
            result.addAll(service.getJamClassElements(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, "org.springframework.cache.annotation.CacheConfig", scope));
            result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(module, "org.springframework.cache.annotation.Cacheable"));
            result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(module, "org.springframework.cache.annotation.CachePut"));
            result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(module, "org.springframework.cache.annotation.CacheEvict"));
            for (SpringCachingGroups cachingGroups : service.getJamClassElements(SpringCachingGroups.META, "org.springframework.cache.annotation.Caching", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) {
                result.addAll(cachingGroups.getCacheables());
                result.addAll(cachingGroups.getCacheEvict());
                result.addAll(cachingGroups.getCachePuts());
            }
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "findAllCacheable"));
        }
        return linkedHashSet;
    }

    private static List<SpringJamCustomCacheableElement> getCustomCacheableElements(@NotNull Module module, @NotNull String definingAnno) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "getCustomCacheableElements"));
        }
        if (definingAnno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definingAnno", "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator", "getCustomCacheableElements"));
        }
        SmartList customCacheables = new SmartList();
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        List customAnnos = ContainerUtil.mapNotNull((Collection)JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationTypesWithChildren(definingAnno), PsiClass::getQualifiedName);
        JamService service = JamService.getJamService((Project)module.getProject());
        for (String customAnno : customAnnos) {
            customCacheables.addAll(service.getJamMethodElements(SpringJamCustomCacheableElement.CUSTOM_ROOT_JAM_KEY, customAnno, searchScope));
            customCacheables.addAll(service.getJamClassElements(SpringJamCustomCacheableElement.CUSTOM_ROOT_JAM_KEY, customAnno, searchScope));
        }
        return customCacheables;
    }
}

