/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.highlighting.SpringCacheableBaseInspection;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCachePut;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheable;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePut;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheableAndCachePutInspection
extends SpringCacheableBaseInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<SpringJamCacheableElement> cachePutElements;
        List<SpringJamCacheableElement> cacheableElements;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection", "checkMethod"));
        }
        if (SpringCacheableAndCachePutInspection.isPlainJavaFileInSpringModule((PsiElement)method) && (cacheableElements = SpringCacheableAndCachePutInspection.getCacheableElements(method)).size() > 0 && (cachePutElements = SpringCacheableAndCachePutInspection.getCachePutElements(method)).size() > 0) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            this.registerProblems(cacheableElements, holder);
            this.registerProblems(cachePutElements, holder);
            return holder.getResultsArray();
        }
        return null;
    }

    private void registerProblems(List<SpringJamCacheableElement> cacheableElements, ProblemsHolder holder) {
        for (SpringJamCacheableElement element : cacheableElements) {
            PsiAnnotation annotation = element.getAnnotation();
            if (annotation == null) continue;
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("cacheable.and.cache.put.on.the.same.method", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static List<SpringJamCacheableElement> getCacheableElements(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection", "getCacheableElements"));
        }
        List elements = ContainerUtil.newSmartList();
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCacheable.CACHEABLE_JAM_KEY, (PsiElement)method));
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCustomCacheable.CUSTOM_CACHEABLE_JAM_KEY, (PsiElement)method));
        return elements;
    }

    private static List<SpringJamCacheableElement> getCachePutElements(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection", "getCachePutElements"));
        }
        List elements = ContainerUtil.newSmartList();
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, (PsiElement)method));
        ContainerUtil.addAll((Collection)elements, (Iterable)SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCustomCachePut.CUSTOM_CACHE_PUT_JAM_KEY, (PsiElement)method));
        return elements;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheableAndCachePutInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/cacheable/highlighting/SpringCacheableAndCachePutInspection", "getShortName"));
        }
        return "SpringCacheableAndCachePutInspection";
    }
}

