/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.highlighting.SpringCacheableBaseInspection;
import com.intellij.spring.model.events.jam.SpringEventListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringEventListenerInspection
extends SpringCacheableBaseInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiAnnotation annotation;
        SpringEventListener eventListener;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/events/highlighting/SpringEventListenerInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/events/highlighting/SpringEventListenerInspection", "checkMethod"));
        }
        ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
        if (SpringEventListenerInspection.isPlainJavaFileInSpringModule((PsiElement)method) && method.getParameterList().getParametersCount() > 1 && (eventListener = (SpringEventListener)SemService.getSemService((Project)method.getProject()).getSemElement(SpringEventListener.EVENT_LISTENER_ROOT_JAM_KEY, (PsiElement)method)) != null && (annotation = eventListener.getAnnotation()) != null) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("event.listener.method.parameters.count", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
        return holder.getResultsArray();
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringEventListenerInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/highlighting/SpringEventListenerInspection", "getShortName"));
        }
        return "SpringEventListenerInspection";
    }
}

