/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.extensions.beanValidation;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringValidationCustomComponentsDiscoverer
extends CustomLocalComponentsDiscoverer {
    @NonNls
    private static final String VALIDATOR_FACTORY = "javax.validation.ValidatorFactory";
    private static final String CONSTRAINT_VALIDATOR = "javax.validation.ConstraintValidator";

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel springModel) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer", "getCustomComponents"));
        }
        Module module = springModel.getModule();
        if (module == null || DumbService.isDumb((Project)module.getProject())) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer", "getCustomComponents"));
            }
            return list;
        }
        PsiClass constraintValidator = SpringCommonUtils.findLibraryClass((Module)module, (String)CONSTRAINT_VALIDATOR);
        if (constraintValidator == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer", "getCustomComponents"));
            }
            return list;
        }
        PsiClass validatorFactory = SpringCommonUtils.findLibraryClass((Module)module, (String)VALIDATOR_FACTORY);
        if (validatorFactory == null || !SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)validatorFactory))) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer", "getCustomComponents"));
            }
            return list;
        }
        HashSet myValidators = new HashSet();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (PsiClass aClass : ClassInheritorsSearch.search((PsiClass)constraintValidator, (SearchScope)scope, (boolean)true).findAll()) {
            PsiModifierList modifierList;
            if (aClass.isInterface() || (modifierList = aClass.getModifierList()) == null || modifierList.hasModifierProperty("abstract")) continue;
            myValidators.add(new CustomSpringComponent(aClass));
        }
        HashSet hashSet = myValidators;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer", "getCustomComponents"));
        }
        return hashSet;
    }
}

