/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.extensions.myBatis;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMyBatisBeansProvider
extends CustomLocalComponentsDiscoverer {
    @NonNls
    private static final String MAPPER_FACTORY_BEAN = "org.mybatis.spring.mapper.MapperFactoryBean";

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel springModel) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "getCustomComponents"));
        }
        Module module = springModel.getModule();
        if (module == null || !(springModel instanceof LocalXmlModel) || DumbService.isDumb((Project)module.getProject())) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "getCustomComponents"));
            }
            return list;
        }
        PsiClass mapperFactoryBeanClass = SpringCommonUtils.findLibraryClass((Module)module, (String)MAPPER_FACTORY_BEAN);
        if (mapperFactoryBeanClass == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "getCustomComponents"));
            }
            return list;
        }
        SpringBeanSearchParameters.BeanClass params = SpringBeanSearchParameters.byClass(module.getProject(), SpringModelSearchParameters.byClass((PsiClass)mapperFactoryBeanClass));
        params.setVirtualFile(((XmlFile)((LocalXmlModel)springModel).getConfig()).getVirtualFile());
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        SpringXmlBeansIndex.processBeansByClass(params, (Processor<SpringBeanPointer>)processor);
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        HashSet myBatisMappers = new HashSet();
        for (SpringBeanPointer springBaseBeanPointer : processor.getResults()) {
            SpringMyBatisBeansProvider.processBasePackages((Collection<CommonSpringBean>)myBatisMappers, facade, scope, springBaseBeanPointer);
            SpringMyBatisBeansProvider.processMarkerInterface((Collection<CommonSpringBean>)myBatisMappers, facade, scope, springBaseBeanPointer);
            SpringMyBatisBeansProvider.processCustomAnnotations((Collection<CommonSpringBean>)myBatisMappers, facade, scope, springBaseBeanPointer);
        }
        HashSet hashSet = myBatisMappers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "getCustomComponents"));
        }
        return hashSet;
    }

    private static void processMarkerInterface(@NotNull Collection<CommonSpringBean> mappers, @NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @NotNull SpringBeanPointer pointer) {
        if (mappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappers", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processMarkerInterface"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processMarkerInterface"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processMarkerInterface"));
        }
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processMarkerInterface"));
        }
        SpringMyBatisBeansProvider.processMarkerInterface(mappers, facade, scope, SpringPropertyUtils.findPropertyByName((CommonSpringBean)pointer.getSpringBean(), (String)"markerInterface"));
        SpringMyBatisBeansProvider.processMarkerInterface(mappers, facade, scope, SpringPropertyUtils.findPropertyByName((CommonSpringBean)pointer.getSpringBean(), (String)"mapperInterface"));
    }

    private static void processMarkerInterface(@NotNull Collection<CommonSpringBean> mappers, @NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @Nullable SpringPropertyDefinition markerInterface) {
        PsiClass aClass;
        String value;
        if (mappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappers", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processMarkerInterface"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processMarkerInterface"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processMarkerInterface"));
        }
        if (markerInterface != null && (value = markerInterface.getValueAsString()) != null && (aClass = facade.findClass(value, scope)) != null) {
            mappers.add((CommonSpringBean)new CustomSpringComponent(aClass));
            for (PsiClass psiClass : ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true).findAll()) {
                mappers.add((CommonSpringBean)new CustomSpringComponent(psiClass));
            }
        }
    }

    private static void processCustomAnnotations(@NotNull Collection<CommonSpringBean> mappers, @NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @NotNull SpringBeanPointer pointer) {
        PsiClass aClass;
        String value;
        if (mappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappers", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processCustomAnnotations"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processCustomAnnotations"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processCustomAnnotations"));
        }
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processCustomAnnotations"));
        }
        SpringPropertyDefinition annotationClass = SpringPropertyUtils.findPropertyByName((CommonSpringBean)pointer.getSpringBean(), (String)"annotationClass");
        if (annotationClass != null && (value = annotationClass.getValueAsString()) != null && (aClass = facade.findClass(value, scope)) != null && aClass.isAnnotationType()) {
            for (PsiClass annotatedClass : AnnotatedElementsSearch.searchPsiClasses((PsiClass)aClass, (SearchScope)scope).findAll()) {
                mappers.add((CommonSpringBean)new CustomSpringComponent(annotatedClass));
            }
        }
    }

    private static void processBasePackages(final @NotNull Collection<CommonSpringBean> myBatisMappers, final @NotNull JavaPsiFacade facade, final @NotNull GlobalSearchScope scope, @NotNull SpringBeanPointer springBaseBeanPointer) {
        String value;
        if (myBatisMappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myBatisMappers", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processBasePackages"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processBasePackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processBasePackages"));
        }
        if (springBaseBeanPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBaseBeanPointer", "com/intellij/spring/model/extensions/myBatis/SpringMyBatisBeansProvider", "processBasePackages"));
        }
        SpringPropertyDefinition basePackages = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBaseBeanPointer.getSpringBean(), (String)"basePackage");
        if (basePackages != null && (value = basePackages.getValueAsString()) != null) {
            new DelimitedListProcessor(" ,"){

                protected void processToken(int start, int end, boolean delimitersOnly) {
                    String packageName = value.substring(start, end);
                    PsiPackage aPackage = facade.findPackage(packageName.trim());
                    if (aPackage != null) {
                        SpringMyBatisBeansProvider.processBasePackage(scope, aPackage, myBatisMappers);
                    }
                }
            }.processText(value);
        }
    }

    private static void processBasePackage(GlobalSearchScope scope, PsiPackage aPackage, Collection<CommonSpringBean> myBatisMappers) {
        for (PsiClass psiClass : aPackage.getClasses(scope)) {
            if (!psiClass.isInterface()) continue;
            myBatisMappers.add((CommonSpringBean)new CustomSpringComponent(psiClass));
        }
        for (PsiClass psiClass : aPackage.getSubPackages(scope)) {
            SpringMyBatisBeansProvider.processBasePackage(scope, (PsiPackage)psiClass, myBatisMappers);
        }
    }
}

