/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LanguageAnnotationSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationSupport;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringObjectFactoryEffectiveTypeProvider;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.ShowBeansQuickFix;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.spring.references.SpringQualifierReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJavaAutowiringInspection
extends BaseJavaLocalInspectionTool {
    private static boolean isRelevantClass(@Nullable PsiClass psiClass) {
        return psiClass != null && SpringLibraryUtil.hasSpringLibrary((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) && (SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass) || SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass));
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkClass"));
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract") || !SpringJavaAutowiringInspection.isRelevantClass(psiClass)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, psiClass.getContainingFile(), isOnTheFly);
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        if (info.isStereotypeJavaBean()) {
            Set<PsiMethod> requiredConstructors;
            Set<String> annotations = SpringAutowireUtil.getAutowiredAnnotations(module);
            HashMap autowiredConstructors = new HashMap();
            PsiMethod[] constructors = psiClass.getConstructors();
            boolean hasNoArgConstructor = constructors.length == 0;
            for (PsiMethod method : constructors) {
                if (!hasNoArgConstructor && method.getParameterList().getParametersCount() == 0) {
                    hasNoArgConstructor = true;
                }
                for (String annotation : annotations) {
                    PsiAnnotation autowiredAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{annotation});
                    if (autowiredAnno == null) continue;
                    autowiredConstructors.put(method, autowiredAnno);
                }
            }
            if (!hasNoArgConstructor && autowiredConstructors.size() == 0 && constructors.length > 1) {
                PsiIdentifier identifier;
                boolean isContextBeanMapped = false;
                for (JamSpringBeanPointer pointer : info.getStereotypeMappedBeans()) {
                    if (!(pointer.getSpringBean() instanceof ContextJavaBean)) continue;
                    isContextBeanMapped = true;
                    break;
                }
                if (!isContextBeanMapped && (identifier = psiClass.getNameIdentifier()) != null) {
                    holder.registerProblem((PsiElement)identifier, SpringBundle.message("class.without.matching.constructor.for.autowiring", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
            if ((requiredConstructors = SpringJavaAutowiringInspection.getRequiredConstructors((Map<PsiMethod, PsiAnnotation>)autowiredConstructors)).size() > 1) {
                for (PsiMethod constructor : requiredConstructors) {
                    PsiIdentifier identifier = constructor.getNameIdentifier();
                    if (identifier == null) continue;
                    holder.registerProblem((PsiElement)identifier, SpringBundle.message("multiple.autowiring.constructor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        }
        return holder.getResultsArray();
    }

    @NotNull
    private static Set<PsiMethod> getRequiredConstructors(@NotNull Map<PsiMethod, PsiAnnotation> constructors) {
        if (constructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructors", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getRequiredConstructors"));
        }
        HashSet requiredConstructors = new HashSet();
        for (Map.Entry<PsiMethod, PsiAnnotation> constructor : constructors.entrySet()) {
            PsiAnnotation annotation = constructor.getValue();
            PsiMethod method = constructor.getKey();
            if ("org.springframework.beans.factory.annotation.Autowired".equals(annotation.getQualifiedName())) {
                Boolean required = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"required");
                if (required != null && !required.booleanValue()) continue;
                requiredConstructors.add(method);
                continue;
            }
            requiredConstructors.add(method);
        }
        HashSet hashSet = requiredConstructors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getRequiredConstructors"));
        }
        return hashSet;
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        CommonSpringModel model;
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkMethod"));
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)psiMethod.getContainingFile()) && SpringJavaAutowiringInspection.isRelevantClass(psiMethod.getContainingClass()) && SpringAutowireUtil.isInjectionPoint(psiMethod) && (model = SpringAutowireUtil.getProcessingSpringModel(psiMethod.getContainingClass())) != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, psiMethod.getContainingFile(), isOnTheFly);
            boolean required = SpringAutowireUtil.isRequired((PsiModifierListOwner)psiMethod);
            SpringJavaAutowiringInspection.checkAutowiredMethod(psiMethod, holder, model, required);
            return holder.getResultsArray();
        }
        return null;
    }

    public ProblemDescriptor[] checkField(@NotNull PsiField psiField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        CommonSpringModel model;
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkField"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkField"));
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)psiField.getContainingFile()) && SpringJavaAutowiringInspection.isRelevantClass(psiField.getContainingClass()) && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField) && (model = SpringAutowireUtil.getProcessingSpringModel(psiField.getContainingClass())) != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, psiField.getContainingFile(), isOnTheFly);
            boolean required = SpringAutowireUtil.isRequired((PsiModifierListOwner)psiField);
            SpringJavaAutowiringInspection.checkAutowiredPsiMember((PsiModifierListOwner)psiField, psiField.getType(), holder, model, required);
            return holder.getResultsArray();
        }
        return null;
    }

    private static void checkAutowiredMethod(PsiMethod psiMethod, @NotNull ProblemsHolder holder, CommonSpringModel springModel, boolean required) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkAutowiredMethod"));
        }
        PsiAnnotation resourceAnnotation = SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)psiMethod);
        if (resourceAnnotation != null) {
            PsiType type = PropertyUtil.getPropertyType((PsiMember)psiMethod);
            if (type != null) {
                SpringJavaAutowiringInspection.checkAutowiredPsiMember((PsiModifierListOwner)psiMethod, type, holder, springModel, required);
            }
        } else if (psiMethod.getParameterList().getParametersCount() == 0 && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) {
            PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
            if (nameIdentifier != null) {
                String msg = SpringBundle.message("bean.autowiring.by.type.no.parameter.for.autowired.method", psiMethod.isConstructor() ? "constructor" : "method");
                holder.registerProblem((PsiElement)nameIdentifier, msg, new LocalQuickFix[0]);
            }
        } else {
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"org.springframework.beans.factory.annotation.Value", (boolean)true)) continue;
                SpringJavaAutowiringInspection.checkAutowiredPsiMember((PsiModifierListOwner)parameter, parameter.getType(), holder, springModel, required);
            }
        }
    }

    @Nullable
    public static Set<SpringBeanPointer> checkAutowiredPsiMember(PsiModifierListOwner modifierListOwner, @NotNull PsiType psiType, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        PsiAnnotation qualifiedAnnotation;
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkAutowiredPsiMember"));
        }
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkAutowiredPsiMember"));
        }
        PsiAnnotation resourceAnnotation = SpringAutowireUtil.getResourceAnnotation(modifierListOwner);
        if (resourceAnnotation != null && modifierListOwner instanceof PsiMember) {
            SpringBeanPointer bean;
            PsiAnnotationMemberValue attributeValue = resourceAnnotation.findDeclaredAttributeValue("name");
            if (attributeValue != null) {
                return SpringJavaAutowiringInspection.checkByNameAutowiring(attributeValue, holder, springModel, psiType, psiType);
            }
            String name = null;
            if (modifierListOwner instanceof PsiMethod) {
                name = PropertyUtil.getPropertyNameBySetter((PsiMethod)((PsiMethod)modifierListOwner));
            } else if (modifierListOwner instanceof PsiField) {
                name = ((PsiField)modifierListOwner).getName();
            }
            if (name != null && (bean = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)name)) != null) {
                return Collections.singleton(bean.getBasePointer());
            }
        }
        if ((qualifiedAnnotation = SpringJavaAutowiringInspection.getEffectiveQualifiedAnnotation(modifierListOwner)) != null) {
            return SpringJavaAutowiringInspection.checkQualifiedAutowiring(psiType, qualifiedAnnotation, holder, springModel);
        }
        return SpringJavaAutowiringInspection.checkByTypeAutowire((PsiNameIdentifierOwner)modifierListOwner, psiType, holder, springModel, required);
    }

    @NotNull
    private static PsiType getSearchType(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getSearchType"));
        }
        PsiType objectFactoryEffectiveType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(psiType);
        if (objectFactoryEffectiveType != null) {
            PsiType psiType2 = objectFactoryEffectiveType;
            if (psiType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getSearchType"));
            }
            return psiType2;
        }
        PsiType psiType3 = psiType;
        if (psiType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getSearchType"));
        }
        return psiType3;
    }

    private static PsiAnnotation getEffectiveQualifiedAnnotation(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getEffectiveQualifiedAnnotation"));
        }
        return modifierListOwner instanceof PsiMethod ? null : SpringAutowireUtil.getQualifiedAnnotation(modifierListOwner);
    }

    @Nullable
    private static Set<SpringBeanPointer> checkByNameAutowiring(PsiAnnotationMemberValue annotationMemberValue, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model, PsiType ... memberEffectiveTypes) {
        SpringBeanPointer bean;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkByNameAutowiring"));
        }
        PsiReference ref = null;
        String beanName = null;
        boolean isFactoryBeanRef = false;
        for (PsiReference reference : annotationMemberValue.getReferences()) {
            PsiConstantEvaluationHelper helper;
            Object o;
            if (reference instanceof SpringBeanReference) {
                ref = reference;
                SpringBeanReference springBeanReference = (SpringBeanReference)reference;
                beanName = springBeanReference.getValue();
                isFactoryBeanRef = springBeanReference.isFactoryBeanRef();
                break;
            }
            if (!(reference instanceof PsiReferenceExpression)) continue;
            ref = reference;
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiField) || !((o = (helper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)((PsiField)element).getInitializer())) instanceof String)) continue;
            beanName = (String)o;
        }
        if (ref == null) {
            return null;
        }
        if (beanName != null && (bean = SpringModelSearchers.findBean((CommonSpringModel)model, beanName)) != null) {
            HashSet byNames = new HashSet();
            for (PsiType memberEffectiveType : memberEffectiveTypes) {
                PsiType[] beanTypes;
                for (PsiType psiType : beanTypes = SpringJavaAutowiringInspection.getEffectiveBeanTypes(isFactoryBeanRef, bean)) {
                    if (!SpringJavaAutowiringInspection.canBeAutowiredByType(memberEffectiveType, psiType)) continue;
                    byNames.add(bean.getBasePointer());
                }
                if (byNames.size() <= 0) continue;
                return byNames;
            }
            if (holder != null) {
                holder.registerProblem(ref, SpringBundle.message("cannot.autowire.bean.of.type", memberEffectiveTypes[0].getCanonicalText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            return null;
        }
        if (holder != null) {
            if (ref instanceof SpringBeanReference) {
                holder.registerProblem(ref);
            } else if (beanName != null) {
                holder.registerProblem(ref.getElement(), SpringApiBundle.message((String)"model.bean.error.message", (Object[])new Object[]{beanName}), new LocalQuickFix[0]);
            }
        }
        return null;
    }

    private static PsiType[] getEffectiveBeanTypes(boolean factoryBeanRef, SpringBeanPointer bean) {
        PsiClass beanClass;
        if (factoryBeanRef && (beanClass = bean.getBeanClass()) != null) {
            return new PsiType[]{PsiTypesUtil.getClassType((PsiClass)beanClass)};
        }
        return bean.getEffectiveBeanTypes();
    }

    @Nullable
    private static Set<SpringBeanPointer> checkQualifiedAutowiring(PsiType searchType, PsiAnnotation qualifiedAnnotation, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model) {
        Set<SpringBeanPointer> beanPointers;
        SpringBeanPointer pointer;
        String name;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkQualifiedAutowiring"));
        }
        PsiAnnotationMemberValue attributeValue = qualifiedAnnotation.findDeclaredAttributeValue("value");
        PsiReference qreference = null;
        String string = name = attributeValue == null ? null : (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)attributeValue, String.class);
        if (attributeValue != null) {
            PsiReference[] references;
            for (PsiReference reference : references = attributeValue.getReferences()) {
                if (!(reference instanceof SpringQualifierReference)) continue;
                qreference = reference;
                if (((SpringQualifierReference)reference).multiResolve(false).length != 0) continue;
                if (holder != null && reference.getElement().isPhysical()) {
                    holder.registerProblem(reference, SpringBundle.message("bean.class.unknown.qualifier.bean", name), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
                return null;
            }
        }
        List<SpringBeanPointer> candidates = SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model);
        if (name != null && (pointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)name)) != null) {
            candidates = new ArrayList<SpringBeanPointer>(candidates);
            candidates.add(pointer.getBasePointer());
        }
        if ((beanPointers = SpringAutowireUtil.excludeAutowireCandidates(candidates, model)).size() == 0) {
            if (holder != null) {
                if (attributeValue != null) {
                    SpringJavaAutowiringInspection.reportProblem(holder, qreference, attributeValue, SpringBundle.message("bean.class.unknown.qualifier.bean", name));
                } else {
                    String qualifiedName = qualifiedAnnotation.getQualifiedName();
                    assert (qualifiedName != null);
                    SpringJavaAutowiringInspection.reportProblem(holder, qreference, (PsiAnnotationMemberValue)qualifiedAnnotation, SpringBundle.message("cannot.find.bean.qualified.by", "@" + StringUtil.getShortName((String)qualifiedName)));
                }
            }
            return null;
        }
        if (beanPointers.size() == 1) {
            boolean isAssignable = false;
            block1: for (SpringBeanPointer bean : beanPointers) {
                PsiType[] psiTypes;
                for (PsiType psiType : psiTypes = bean.getEffectiveBeanTypes()) {
                    if (!SpringJavaAutowiringInspection.canBeAutowiredByType(searchType, psiType)) continue;
                    isAssignable = true;
                    continue block1;
                }
            }
            if (!isAssignable && SpringJavaAutowiringInspection.getIterableBeanPointers(searchType, model, null).size() == 0) {
                if (holder != null) {
                    String message = SpringBundle.message("bean.class.autowired.incorrect.qualifier.type", searchType.getPresentableText());
                    SpringJavaAutowiringInspection.reportProblem(holder, qreference, (PsiAnnotationMemberValue)(attributeValue == null ? qualifiedAnnotation : attributeValue), message);
                }
                return null;
            }
        }
        return beanPointers;
    }

    private static boolean canBeAutowiredByType(@NotNull PsiType psiType, @NotNull PsiType searchType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "canBeAutowiredByType"));
        }
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "canBeAutowiredByType"));
        }
        if (psiType.isAssignableFrom(searchType)) {
            return true;
        }
        PsiType iterableType = SpringJavaAutowiringInspection.getIterableType(psiType);
        if (iterableType != null && iterableType.isAssignableFrom(searchType)) {
            return true;
        }
        return SpringJavaAutowiringInspection.isObjectFactoryEffectiveType(psiType, searchType);
    }

    private static boolean isObjectFactoryEffectiveType(@NotNull PsiType psiType, @NotNull PsiType aType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "isObjectFactoryEffectiveType"));
        }
        if (aType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "isObjectFactoryEffectiveType"));
        }
        PsiType objectFactoryEffectiveType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(aType);
        return objectFactoryEffectiveType != null && psiType.isAssignableFrom(objectFactoryEffectiveType);
    }

    private static void reportProblem(@NotNull ProblemsHolder holder, @Nullable PsiReference qreference, @NotNull PsiAnnotationMemberValue attributeValue, String text) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "reportProblem"));
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "reportProblem"));
        }
        if (qreference == null) {
            holder.registerProblem((PsiElement)attributeValue, text, new LocalQuickFix[0]);
        } else {
            holder.registerProblem(qreference, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static boolean isTypedMapWithStringKey(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "isTypedMapWithStringKey"));
        }
        if (psiType instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.Map")) {
            PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Map", (int)0, (boolean)false);
            return keyType != null && InheritanceUtil.isInheritor((PsiType)keyType, (String)"java.lang.String");
        }
        return false;
    }

    @Nullable
    private static Set<SpringBeanPointer> checkByTypeAutowire(PsiNameIdentifierOwner psiNameIdentifierOwner, @NotNull PsiType searchType, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model, boolean required) {
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkByTypeAutowire"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "checkByTypeAutowire"));
        }
        PsiElement psiElement = psiNameIdentifierOwner.getNameIdentifier();
        assert (psiElement != null) : psiNameIdentifierOwner;
        String primaryCandidateName = psiNameIdentifierOwner.getName();
        Set<SpringBeanPointer> beanPointers = SpringAutowireUtil.autowireByType(model, searchType, primaryCandidateName);
        Set<SpringBeanPointer> iterableBeanPointers = SpringJavaAutowiringInspection.getIterableBeanPointers(searchType, model, primaryCandidateName);
        if (beanPointers.isEmpty() && iterableBeanPointers.isEmpty() && required) {
            if (!(holder == null || SpringAutowireUtil.isAutowiredByDefault(searchType) || SpringJavaAutowiringInspection.isObjectFactory(searchType) || SpringJavaAutowiringInspection.isInjectionPoint(searchType) || SpringAutowireUtil.isJavaUtilOptional(searchType))) {
                holder.registerProblem(psiElement, SpringJavaAutowiringInspection.getBeansNotFoundMessage(searchType), new LocalQuickFix[0]);
            }
            return null;
        }
        if (iterableBeanPointers.isEmpty() && beanPointers.size() > 1 && holder != null) {
            Set<SpringBeanPointer> filtered = SpringJavaAutowiringInspection.filterOverridenBeans(beanPointers);
            if ((filtered = SpringJavaAutowiringInspection.filterSelfReferencedBeans(psiNameIdentifierOwner, filtered)).size() > 1) {
                if (SpringJavaAutowiringInspection.isNonDefinedActiveProfile(model.getActiveProfiles()) && SpringJavaAutowiringInspection.isAllBeansInDifferentProfiles(filtered)) {
                    return beanPointers;
                }
                PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiModifierListOwner.class, (boolean)false);
                holder.registerProblem(psiElement, SpringJavaAutowiringInspection.getErrorMessage(searchType, filtered), new LocalQuickFix[]{new AddSpringBeanQualifierFix(psiModifierListOwner, beanPointers, SpringJavaAutowiringInspection.getQualifierAnnotation(psiModifierListOwner)), new ShowBeansQuickFix(beanPointers)});
            }
        }
        return iterableBeanPointers.isEmpty() ? beanPointers : iterableBeanPointers;
    }

    @NotNull
    private static Set<SpringBeanPointer> getIterableBeanPointers(@NotNull PsiType searchType, @NotNull CommonSpringModel model, String primaryCandidateName) {
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getIterableBeanPointers"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getIterableBeanPointers"));
        }
        PsiType secondarySearchType = SpringJavaAutowiringInspection.getIterableSearchType(searchType);
        Set<SpringBeanPointer> set = secondarySearchType != null ? SpringAutowireUtil.autowireByType(model, secondarySearchType, primaryCandidateName) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getIterableBeanPointers"));
        }
        return set;
    }

    private static String getBeansNotFoundMessage(@NotNull PsiType searchType) {
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getBeansNotFoundMessage"));
        }
        PsiType secondarySearchType = SpringJavaAutowiringInspection.getIterableSearchType(searchType);
        return secondarySearchType != null ? SpringBundle.message("bean.autowiring.by.type.no.beans", secondarySearchType.getPresentableText(), searchType.getPresentableText()) : SpringBundle.message("bean.autowiring.by.type.none", searchType.getPresentableText());
    }

    @Nullable
    private static PsiType getIterableSearchType(@NotNull PsiType searchType) {
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getIterableSearchType"));
        }
        PsiType iterableType = SpringJavaAutowiringInspection.getIterableType(searchType);
        if (iterableType != null) {
            return iterableType;
        }
        if (SpringJavaAutowiringInspection.isTypedMapWithStringKey(searchType)) {
            return PsiUtil.substituteTypeParameter((PsiType)searchType, (String)"java.util.Map", (int)1, (boolean)false);
        }
        return SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(searchType);
    }

    @Nullable
    private static PsiType getIterableType(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getIterableType"));
        }
        return psiType instanceof PsiArrayType ? ((PsiArrayType)psiType).getComponentType() : PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)true);
    }

    private static boolean isObjectFactory(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "isObjectFactory"));
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.ObjectFactory");
        }
        return false;
    }

    private static boolean isInjectionPoint(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "isInjectionPoint"));
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && "org.springframework.beans.factory.InjectionPoint".equals(psiClass.getQualifiedName());
        }
        return false;
    }

    @NotNull
    private static String getErrorMessage(@NotNull PsiType beanType, Set<SpringBeanPointer> autowiredPointers) {
        if (beanType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanType", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getErrorMessage"));
        }
        SortedList sortedByNamePointers = new SortedList((o1, o2) -> ((String)o1.first).compareTo((String)o2.first));
        for (SpringBeanPointer pointer : autowiredPointers) {
            sortedByNamePointers.add(Pair.create((Object)SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer), (Object)SpringPresentationProvider.getSpringBeanLocation((SpringBeanPointer)pointer)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        sb.append("<tr><td>");
        sb.append(SpringBundle.message("bean.class.autowired.by.type", beanType.getPresentableText()));
        sb.append("</td></tr>");
        sb.append("<tr><td>");
        sb.append("<table>");
        sb.append("<tr><td valign='top'>Beans:</td>");
        sb.append("<td>");
        for (Pair pair : sortedByNamePointers) {
            sb.append((String)pair.first);
            sb.append("&nbsp;&nbsp; (");
            sb.append((String)pair.second);
            sb.append(")<br>");
        }
        sb.append("</td></tr>");
        sb.append("</table>");
        sb.append("</td></tr>");
        sb.append("</table></html>");
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getErrorMessage"));
        }
        return string;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterSelfReferencedBeans(@NotNull PsiNameIdentifierOwner psiNameIdentifierOwner, @NotNull Set<SpringBeanPointer> pointers) {
        if (psiNameIdentifierOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiNameIdentifierOwner", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "filterSelfReferencedBeans"));
        }
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "filterSelfReferencedBeans"));
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiNameIdentifierOwner, PsiMethod.class);
        if (psiMethod == null) {
            Set<SpringBeanPointer> set = pointers;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "filterSelfReferencedBeans"));
            }
            return set;
        }
        LinkedHashSet filtered = ContainerUtil.newLinkedHashSet();
        for (SpringBeanPointer pointer : pointers) {
            if (psiMethod.equals(pointer.getSpringBean().getIdentifyingPsiElement())) continue;
            filtered.add(pointer);
        }
        LinkedHashSet linkedHashSet = filtered;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "filterSelfReferencedBeans"));
        }
        return linkedHashSet;
    }

    private static boolean isAllBeansInDifferentProfiles(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "isAllBeansInDifferentProfiles"));
        }
        Set names = ContainerUtil.newConcurrentSet();
        for (SpringBeanPointer pointer : pointers) {
            CommonSpringBean bean = pointer.getSpringBean();
            for (String profileName : bean.getProfile().getNames()) {
                if (names.contains(profileName)) {
                    return false;
                }
                names.add(profileName);
            }
        }
        return true;
    }

    private static boolean isNonDefinedActiveProfile(@Nullable Set<String> activeProfiles) {
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        boolean isDefaultProfile = activeProfiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(activeProfiles.iterator().next());
        return !isDefaultProfile;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterOverridenBeans(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "filterOverridenBeans"));
        }
        MultiMap names = new MultiMap();
        Set set = ContainerUtil.map2SetNotNull(pointers, pointer -> {
            boolean isOverriden = false;
            String name = pointer.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                VirtualFile containingFile = pointer.getContainingFile().getVirtualFile();
                if (names.containsKey((Object)name) && !names.values().contains(containingFile)) {
                    isOverriden = true;
                }
                names.putValue((Object)name, (Object)containingFile);
            }
            return isOverriden ? null : pointer;
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "filterOverridenBeans"));
        }
        return set;
    }

    @NotNull
    private static String getQualifierAnnotation(@Nullable PsiModifierListOwner psiModifierListOwner) {
        PsiMember psiMember;
        if (psiModifierListOwner != null && (psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiMember.class, (boolean)false)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.inject.Inject", (boolean)true)) {
            if ("javax.inject.Named" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getQualifierAnnotation"));
            }
            return "javax.inject.Named";
        }
        if ("org.springframework.beans.factory.annotation.Qualifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getQualifierAnnotation"));
        }
        return "org.springframework.beans.factory.annotation.Qualifier";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringJavaAutowiringInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getShortName"));
        }
        return "SpringJavaAutowiringInspection";
    }

    private static Expression getQualifierNamesSuggestNamesExpression(final PsiLiteral psiLiteral, final @NotNull Collection<SpringBeanPointer> beanPointers) {
        if (beanPointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanPointers", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getQualifierNamesSuggestNamesExpression"));
        }
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                return new TextResult(ElementManipulators.getValueText((PsiElement)psiLiteral));
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElement> items = new LinkedHashSet<LookupElement>();
                PsiClass psiAnnoClass = SpringQualifierReference.findAnnoPsiClass(psiLiteral);
                for (SpringBeanPointer pointer : beanPointers) {
                    String value;
                    CommonSpringBean bean = pointer.getSpringBean();
                    SpringQualifier qualifier = bean.getSpringQualifier();
                    if (qualifier == null || psiAnnoClass == null || (value = qualifier.getQualifierValue()) == null || !(qualifier instanceof DefaultSpringBeanQualifier) && !Comparing.equal((Object)qualifier.getQualifierType(), (Object)psiAnnoClass)) continue;
                    items.add(SpringConverterUtil.createCompletionVariant((SpringBeanPointer)pointer, (String)value));
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
    }

    @NotNull
    private static String getBeanPointerName(@NotNull SpringBeanPointer beanPointer) {
        if (beanPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanPointer", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getBeanPointerName"));
        }
        String name = beanPointer.getName();
        String string = StringUtil.isEmptyOrSpaces((String)name) ? "Unknown" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection", "getBeanPointerName"));
        }
        return string;
    }

    private static class AddSpringBeanQualifierFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiModifierListOwner> myModifierListOwnerPointer;
        private final Collection<SpringBeanPointer> myBeanPointers;
        private final String myQualifierAnno;

        public AddSpringBeanQualifierFix(PsiModifierListOwner psiElement, @NotNull Collection<SpringBeanPointer> beanPointers, @NotNull String qualifierAnno) {
            if (beanPointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanPointers", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection$AddSpringBeanQualifierFix", "<init>"));
            }
            if (qualifierAnno == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierAnno", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection$AddSpringBeanQualifierFix", "<init>"));
            }
            this.myModifierListOwnerPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer((PsiElement)psiElement);
            this.myBeanPointers = beanPointers;
            this.myQualifierAnno = qualifierAnno;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("SpringAutowiringInspection.add.qualifier.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection$AddSpringBeanQualifierFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiModifierList modifierList;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection$AddSpringBeanQualifierFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection$AddSpringBeanQualifierFix", "applyFix"));
            }
            final PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)this.myModifierListOwnerPointer.getElement();
            if (modifierListOwner == null) {
                return;
            }
            if (FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)modifierListOwner) && (modifierList = modifierListOwner.getModifierList()) != null && this.myBeanPointers.size() > 0) {
                new WriteCommandAction(modifierListOwner.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection$AddSpringBeanQualifierFix$1", "run"));
                        }
                        PsiAnnotation annotation = modifierList.addAnnotation(myQualifierAnno);
                        PsiAnnotationSupport support = (PsiAnnotationSupport)LanguageAnnotationSupport.INSTANCE.forLanguage(annotation.getLanguage());
                        PsiLiteral psiLiteral = (PsiLiteral)annotation.setDeclaredAttributeValue("value", (PsiAnnotationMemberValue)support.createLiteralValue(SpringJavaAutowiringInspection.getBeanPointerName((SpringBeanPointer)myBeanPointers.iterator().next()), (PsiElement)annotation));
                        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
                        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                        codeStyleManager.shortenClassReferences(formatter.reformat((PsiElement)annotation));
                        Editor editor = AddSpringBeanQualifierFix.getEditor(modifierListOwner);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                        TemplateManager manager = TemplateManager.getInstance((Project)modifierListOwner.getProject());
                        manager.startTemplate(editor, this.createQualifierNameTemplate(psiLiteral));
                    }
                }.execute();
            }
        }

        private Template createQualifierNameTemplate(@NotNull PsiLiteral psiLiteral) {
            if (psiLiteral == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiLiteral", "com/intellij/spring/model/highlighting/SpringJavaAutowiringInspection$AddSpringBeanQualifierFix", "createQualifierNameTemplate"));
            }
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)psiLiteral.getContainingFile());
            TextRange textRange = psiLiteral.getTextRange();
            String valueText = ElementManipulators.getValueText((PsiElement)psiLiteral);
            builder.replaceRange(TextRange.from((int)(textRange.getStartOffset() + 1), (int)valueText.length()), SpringJavaAutowiringInspection.getQualifierNamesSuggestNamesExpression(psiLiteral, this.myBeanPointers));
            return builder.buildInlineTemplate();
        }

        public static Editor getEditor(PsiModifierListOwner modifierListOwner) {
            PsiFile psiFile = modifierListOwner.getContainingFile();
            Project project = psiFile.getProject();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            assert (virtualFile != null);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, 0), false);
            assert (editor != null);
            return editor;
        }
    }
}

