/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.highlighting.config.ConfigureFileSetFix;
import com.intellij.spring.model.highlighting.config.CreateSpringFacetFix;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.spi.SpringSpiManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFacetCodeInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/highlighting/config/SpringFacetCodeInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/config/SpringFacetCodeInspection", "checkClass"));
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)psiClass.getProject())) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (psiClass.hasModifierProperty("static")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (SpringModelUtils.getInstance().isUsedConfigurationFile(containingFile, false)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)psiClass.getProject());
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!SpringSpiManager.getInstance((Module)module).processClassesListValues(false, psiClass.getQualifiedName(), (property, aClass) -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/highlighting/config/SpringFacetCodeInspection", "lambda$checkClass$0"));
            }
            return !aClass.isEquivalentTo((PsiElement)psiClass);
        })) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SpringModelSearchParameters.BeanClass params = SpringModelSearchParameters.byClass((PsiClass)psiClass);
        for (CommonSpringModel springModel : SpringManager.getInstance((Project)psiClass.getProject()).getAllModels(module)) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)params)) continue;
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Object fix = SpringCommonUtils.hasSpringFacet((Module)module) ? new ConfigureFileSetFix(module, virtualFile) : new CreateSpringFacetFix(module);
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        PsiIdentifier highlightElement = identifier != null ? identifier : psiClass;
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)highlightElement, SpringBundle.message("spring.facet.inspection.context.not.configured.for.file", new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        return new ProblemDescriptor[]{descriptor};
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringFacetCodeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/SpringFacetCodeInspection", "getShortName"));
        }
        return "SpringFacetCodeInspection";
    }
}

