/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.structure.SpringStructureViewComponent;
import com.intellij.spring.model.structure.SpringStructureViewModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringXmlStructureViewBuilderProvider
implements XmlStructureViewBuilderProvider {
    @Nullable
    public StructureViewBuilder createStructureViewBuilder(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/structure/SpringXmlStructureViewBuilderProvider", "createStructureViewBuilder"));
        }
        if (SpringDomUtils.isSpringXml((XmlFile)file)) {
            return new TreeBasedStructureViewBuilder(){

                @NotNull
                public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                    SpringStructureViewModel springStructureViewModel = new SpringStructureViewModel(file, editor);
                    if (springStructureViewModel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringXmlStructureViewBuilderProvider$1", "createStructureViewModel"));
                    }
                    return springStructureViewModel;
                }

                @NotNull
                public StructureView createStructureView(FileEditor fileEditor, @NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/structure/SpringXmlStructureViewBuilderProvider$1", "createStructureView"));
                    }
                    final StructureViewModel model = this.createStructureViewModel(fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null);
                    SpringStructureViewComponent view = new SpringStructureViewComponent(fileEditor, model, project);
                    Disposer.register((Disposable)view, (Disposable)new Disposable(){

                        public void dispose() {
                            model.dispose();
                        }
                    });
                    SpringStructureViewComponent springStructureViewComponent = view;
                    if (springStructureViewComponent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/structure/SpringXmlStructureViewBuilderProvider$1", "createStructureView"));
                    }
                    return springStructureViewComponent;
                }
            };
        }
        return null;
    }
}

