/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeUtilImpl
extends PsiTypeUtil {
    private final Map<Class, Class[]> listOrSetConverters = new HashMap();
    private final Project myProject;

    public PsiTypeUtilImpl(Project project) {
        this.myProject = project;
        Class[] classes = new Class[]{Object[].class, boolean[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class};
        this.listOrSetConverters.put(Set.class, classes);
        this.listOrSetConverters.put(List.class, classes);
    }

    @Nullable
    public PsiType findType(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/utils/PsiTypeUtilImpl", "findType"));
        }
        if (aClass.isArray()) {
            Class<?> componentType = aClass.getComponentType();
            PsiType componentClassType = this.findType(componentType);
            return componentClassType != null ? componentClassType.createArrayType() : null;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        if (aClass.isPrimitive()) {
            return javaPsiFacade.getElementFactory().createPrimitiveType(aClass.getName());
        }
        PsiClass psiClass = javaPsiFacade.findClass(aClass.getName(), GlobalSearchScope.allScope((Project)this.myProject));
        if (psiClass == null) {
            return null;
        }
        return javaPsiFacade.getElementFactory().createType(psiClass);
    }

    public boolean isCollectionType(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/utils/PsiTypeUtilImpl", "isCollectionType"));
        }
        PsiType collectionType = this.findType(Collection.class);
        return collectionType != null && collectionType.isAssignableFrom(psiType);
    }

    public boolean isConvertable(@NotNull PsiType from, @NotNull List<? extends PsiType> types) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/spring/model/utils/PsiTypeUtilImpl", "isConvertable"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/model/utils/PsiTypeUtilImpl", "isConvertable"));
        }
        for (PsiType psiType : types) {
            if (psiType == null || !this.isConvertable(from, psiType)) continue;
            return true;
        }
        return false;
    }

    private boolean isConvertable(@NotNull PsiType from, @NotNull PsiType to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/spring/model/utils/PsiTypeUtilImpl", "isConvertable"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/spring/model/utils/PsiTypeUtilImpl", "isConvertable"));
        }
        if (to instanceof PsiClassType) {
            to = ((PsiClassType)to).rawType();
        }
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (from.equalsToText("java.lang.String") && PsiTypeUtilImpl.isStringConvertable(to)) {
            return true;
        }
        if (from.equalsToText("java.util.Set") && to.equalsToText("java.util.List") || to.equalsToText("java.util.Set") && from.equalsToText("java.util.List")) {
            return true;
        }
        if (to instanceof PsiArrayType) {
            PsiClass resolved;
            PsiType type = ((PsiArrayType)to).getComponentType();
            if (type.isAssignableFrom(from)) {
                return true;
            }
            if (from instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)(resolved = ((PsiClassType)from).resolve()), (String)"java.util.Collection")) {
                return true;
            }
        }
        if (to instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)((PsiClassType)to).resolve(), (String)"java.util.Properties")) {
            return from instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)((PsiClassType)from).resolve(), (String)"java.util.Map");
        }
        for (Class registeredClass : this.listOrSetConverters.keySet()) {
            Class[] classes;
            PsiType registeredFromType = this.findType(registeredClass);
            if (registeredFromType == null || !from.isAssignableFrom(registeredFromType)) continue;
            for (Class aClass : classes = this.listOrSetConverters.get(registeredClass)) {
                PsiType registeredTooType = this.findType(aClass);
                if (registeredTooType == null || !registeredTooType.equals(to) && !registeredTooType.isAssignableFrom(to)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isStringConvertable(PsiType requiredType) {
        block4: {
            block3: {
                if (!(requiredType instanceof PsiClassType)) break block3;
                PsiClass psiClass = ((PsiClassType)requiredType).resolve();
                if (psiClass == null) break block4;
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    PsiParameterList parameterList = constructor.getParameterList();
                    if (parameterList.getParametersCount() != 1) continue;
                    PsiParameter parameter = parameterList.getParameters()[0];
                    if (!String.class.getCanonicalName().equals(parameter.getType().getCanonicalText())) continue;
                    return true;
                }
                break block4;
            }
            if (requiredType instanceof PsiPrimitiveType) {
                PsiType[] convertable;
                for (PsiType psiType : convertable = new PsiType[]{PsiType.BOOLEAN, PsiType.BYTE, PsiType.CHAR, PsiType.DOUBLE, PsiType.FLOAT, PsiType.INT, PsiType.LONG, PsiType.SHORT}) {
                    if (!requiredType.equals(psiType)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

